/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.transformations.simplification;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.FormulaTransformation;
import org.logicng.formulas.NAryOperator;
import org.logicng.formulas.Not;
import org.logicng.transformations.simplification.DefaultRatingFunction;
import org.logicng.transformations.simplification.RatingFunction;
import org.logicng.util.Pair;

public final class FactorOutSimplifier
implements FormulaTransformation {
    private final RatingFunction<? extends Number> ratingFunction;

    public FactorOutSimplifier(RatingFunction<? extends Number> ratingFunction) {
        this.ratingFunction = ratingFunction;
    }

    public FactorOutSimplifier() {
        this(new DefaultRatingFunction());
    }

    @Override
    public Formula apply(Formula formula, boolean cache) {
        Formula last;
        Formula simplified = formula;
        while (!(simplified = this.applyRec(last = simplified, cache)).equals(last)) {
        }
        return simplified;
    }

    private Formula applyRec(Formula formula, boolean cache) {
        switch (formula.type()) {
            case OR: 
            case AND: {
                ArrayList<Formula> newOps = new ArrayList<Formula>();
                for (Formula op : formula) {
                    newOps.add(this.apply(op, cache));
                }
                Formula newFormula = formula.factory().naryOperator(formula.type(), newOps);
                return newFormula instanceof NAryOperator ? this.simplify((NAryOperator)newFormula) : newFormula;
            }
            case NOT: {
                return this.apply(((Not)formula).operand(), cache).negate();
            }
            case FALSE: 
            case TRUE: 
            case LITERAL: 
            case IMPL: 
            case EQUIV: 
            case PBC: {
                return formula;
            }
        }
        throw new IllegalStateException("Unknown formula type: " + (Object)((Object)formula.type()));
    }

    private Formula simplify(NAryOperator formula) {
        Formula simplified = FactorOutSimplifier.factorOut(formula);
        return simplified == null || ((Number)this.ratingFunction.apply(formula, true)).doubleValue() <= ((Number)this.ratingFunction.apply(simplified, true)).doubleValue() ? formula : simplified;
    }

    private static Formula factorOut(NAryOperator formula) {
        Formula factorOutFormula = FactorOutSimplifier.computeMaxOccurringSubformula(formula);
        if (factorOutFormula == null) {
            return null;
        }
        FormulaFactory f = formula.factory();
        FType type = formula.type();
        ArrayList<Formula> formulasWithRemoved = new ArrayList<Formula>();
        ArrayList<Formula> unchangedFormulas = new ArrayList<Formula>();
        for (Formula operand : formula) {
            if (operand.type() == FType.LITERAL) {
                if (operand.equals(factorOutFormula)) {
                    formulasWithRemoved.add(f.constant(type == FType.OR));
                    continue;
                }
                unchangedFormulas.add(operand);
                continue;
            }
            if (operand.type() == FType.AND || operand.type() == FType.OR) {
                boolean removed = false;
                ArrayList<Formula> newOps = new ArrayList<Formula>();
                for (Formula op : operand) {
                    if (!op.equals(factorOutFormula)) {
                        newOps.add(op);
                        continue;
                    }
                    removed = true;
                }
                (removed ? formulasWithRemoved : unchangedFormulas).add(f.naryOperator(operand.type(), newOps));
                continue;
            }
            unchangedFormulas.add(operand);
        }
        return f.naryOperator(type, f.naryOperator(type, unchangedFormulas), f.naryOperator(FType.dual(type), factorOutFormula, f.naryOperator(type, formulasWithRemoved)));
    }

    private static Formula computeMaxOccurringSubformula(NAryOperator formula) {
        HashMap<Formula, Integer> formulaCounts = new HashMap<Formula, Integer>();
        for (Formula operand : formula) {
            if (operand.type() == FType.LITERAL) {
                formulaCounts.merge(operand, 1, Integer::sum);
                continue;
            }
            if (operand.type() != FType.AND && operand.type() != FType.OR) continue;
            for (Formula subOperand : operand) {
                formulaCounts.merge(subOperand, 1, Integer::sum);
            }
        }
        Pair<Object, Integer> max = formulaCounts.entrySet().stream().max(Comparator.comparingInt(Map.Entry::getValue)).map(e -> new Pair(e.getKey(), e.getValue())).orElse(new Pair<Object, Integer>(null, 0));
        return max.second() < 2 ? null : (Formula)max.first();
    }
}

