/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.transformations.simplification;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.logicng.formulas.Equivalence;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.FormulaTransformation;
import org.logicng.formulas.Implication;
import org.logicng.formulas.Not;
import org.logicng.formulas.cache.TransformationCacheEntry;

public final class DistributiveSimplifier
implements FormulaTransformation {
    @Override
    public Formula apply(Formula formula, boolean cache) {
        Formula result;
        FormulaFactory f = formula.factory();
        switch (formula.type()) {
            case FALSE: 
            case TRUE: 
            case LITERAL: 
            case PBC: {
                result = formula;
                break;
            }
            case EQUIV: {
                Equivalence equiv = (Equivalence)formula;
                result = f.equivalence(this.apply(equiv.left(), cache), this.apply(equiv.right(), cache));
                break;
            }
            case IMPL: {
                Implication impl = (Implication)formula;
                result = f.implication(this.apply(impl.left(), cache), this.apply(impl.right(), cache));
                break;
            }
            case NOT: {
                Not not = (Not)formula;
                result = f.not(this.apply(not.operand(), cache));
                break;
            }
            case OR: 
            case AND: {
                result = this.distributeNAry(formula, cache, f);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown formula type: " + (Object)((Object)formula.type()));
            }
        }
        if (cache) {
            formula.setTransformationCacheEntry(TransformationCacheEntry.DISTRIBUTIVE_SIMPLIFICATION, result);
        }
        return result;
    }

    private Formula distributeNAry(Formula formula, boolean cache, FormulaFactory f) {
        FType outerType = formula.type();
        FType innerType = FType.dual(outerType);
        LinkedHashSet<Formula> operands = new LinkedHashSet<Formula>();
        for (Formula op : formula) {
            operands.add(this.apply(op, cache));
        }
        LinkedHashMap<Formula, Set> part2Operands = new LinkedHashMap<Formula, Set>();
        Formula mostCommon = null;
        int mostCommonAmount = 0;
        for (Formula op : operands) {
            if (op.type() != innerType) continue;
            for (Formula part : op) {
                Set partOperands = part2Operands.computeIfAbsent(part, k -> new LinkedHashSet());
                partOperands.add(op);
                if (partOperands.size() <= mostCommonAmount) continue;
                mostCommon = part;
                mostCommonAmount = partOperands.size();
            }
        }
        if (mostCommon == null || mostCommonAmount == 1) {
            Formula result = f.naryOperator(outerType, operands);
            return result;
        }
        operands.removeAll((Collection)part2Operands.get(mostCommon));
        LinkedHashSet<Formula> relevantFormulas = new LinkedHashSet<Formula>();
        for (Formula preRelevantFormula : (Set)part2Operands.get(mostCommon)) {
            LinkedHashSet<Formula> relevantParts = new LinkedHashSet<Formula>();
            for (Formula part : preRelevantFormula) {
                if (part.equals(mostCommon)) continue;
                relevantParts.add(part);
            }
            relevantFormulas.add(f.naryOperator(innerType, relevantParts));
        }
        operands.add(f.naryOperator(innerType, mostCommon, f.naryOperator(outerType, relevantFormulas)));
        Formula result = f.naryOperator(outerType, operands);
        return result;
    }
}

