/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.transformations.simplification;

import org.logicng.backbones.Backbone;
import org.logicng.backbones.BackboneType;
import org.logicng.datastructures.Assignment;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaTransformation;
import org.logicng.solvers.MiniSat;
import org.logicng.solvers.SATSolver;
import org.logicng.solvers.functions.BackboneFunction;

public final class BackboneSimplifier
implements FormulaTransformation {
    @Override
    public Formula apply(Formula formula, boolean cache) {
        MiniSat solver = MiniSat.miniSat(formula.factory());
        solver.add(formula);
        Backbone backbone = ((SATSolver)solver).execute(BackboneFunction.builder().variables(formula.variables()).type(BackboneType.POSITIVE_AND_NEGATIVE).build());
        if (!backbone.isSat()) {
            return formula.factory().falsum();
        }
        if (!backbone.getNegativeBackbone().isEmpty() || !backbone.getPositiveBackbone().isEmpty()) {
            Formula backboneFormula = backbone.toFormula(formula.factory());
            Assignment assignment = new Assignment(backbone.getCompleteBackbone());
            Formula restrictedFormula = formula.restrict(assignment);
            return formula.factory().and(backboneFormula, restrictedFormula);
        }
        return formula;
    }
}

