/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.transformations.simplification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.logicng.backbones.Backbone;
import org.logicng.backbones.BackboneGeneration;
import org.logicng.datastructures.Assignment;
import org.logicng.explanations.smus.SmusComputation;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.FormulaTransformation;
import org.logicng.formulas.Literal;
import org.logicng.primecomputation.PrimeCompiler;
import org.logicng.primecomputation.PrimeResult;
import org.logicng.transformations.simplification.FactorOutSimplifier;
import org.logicng.transformations.simplification.NegationSimplifier;
import org.logicng.transformations.simplification.RatingFunction;
import org.logicng.util.FormulaHelper;

public final class AdvancedSimplifier
implements FormulaTransformation {
    private final RatingFunction<?> ratingFunction;

    public AdvancedSimplifier(RatingFunction<?> ratingFunction) {
        this.ratingFunction = ratingFunction;
    }

    @Override
    public Formula apply(Formula formula, boolean cache) {
        FormulaFactory f = formula.factory();
        Backbone backbone = BackboneGeneration.compute(formula, formula.variables());
        if (!backbone.isSat()) {
            return f.falsum();
        }
        SortedSet<Literal> backboneLiterals = backbone.getCompleteBackbone();
        Formula restrictedFormula = formula.restrict(new Assignment(backboneLiterals));
        List<SortedSet<Literal>> primeImplicants = PrimeCompiler.getWithMinimization().compute(restrictedFormula, PrimeResult.CoverageType.IMPLICANTS_COMPLETE).getPrimeImplicants();
        List<Formula> minimizedPIs = SmusComputation.computeSmusForFormulas(this.negateAllLiterals(primeImplicants, f), Collections.singletonList(restrictedFormula), f);
        assert (minimizedPIs != null) : "The conjunction of a satisfiable formula and its negated prime implications is always a contradiction";
        Formula minDnf = f.or(this.negateAllLiteralsInFormulas(minimizedPIs, f).stream().map(xva$0 -> f.and((Formula)xva$0)).collect(Collectors.toList()));
        Formula fullFactor = minDnf.transform(new FactorOutSimplifier(this.ratingFunction));
        return f.and(f.and(backboneLiterals), fullFactor).transform(new NegationSimplifier());
    }

    private List<Formula> negateAllLiterals(Collection<SortedSet<Literal>> literalSets, FormulaFactory f) {
        ArrayList<Formula> result = new ArrayList<Formula>();
        for (SortedSet<Literal> literals : literalSets) {
            result.add(f.or(FormulaHelper.negateLiterals(literals, ArrayList::new)));
        }
        return result;
    }

    private List<Formula> negateAllLiteralsInFormulas(Collection<Formula> formulas, FormulaFactory f) {
        ArrayList<Formula> result = new ArrayList<Formula>();
        for (Formula formula : formulas) {
            result.add(f.and(FormulaHelper.negateLiterals(formula.literals(), ArrayList::new)));
        }
        return result;
    }
}

