/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.transformations.qmc;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.TreeSet;
import java.util.Vector;
import org.logicng.datastructures.Tristate;
import org.logicng.formulas.Formula;
import org.logicng.transformations.qmc.Term;

public class TermTable {
    protected final Vector<Formula> columnHeaders;
    protected final Vector<Term> lineHeaders;
    protected final Vector<Vector<Boolean>> matrixLines;
    protected final Vector<Vector<Boolean>> matrixColumns;

    TermTable(LinkedHashSet<Term> terms) {
        int i;
        this.lineHeaders = new Vector(terms.size());
        this.columnHeaders = this.initializeColumnHeaders(terms);
        this.matrixLines = new Vector(terms.size());
        this.matrixColumns = new Vector(this.columnHeaders.size());
        Vector<Boolean> matrixLineTemplate = new Vector<Boolean>(this.columnHeaders.size());
        for (int i2 = 0; i2 < this.columnHeaders.size(); ++i2) {
            matrixLineTemplate.add(false);
        }
        Vector<Boolean> matrixColumnTemplate = new Vector<Boolean>(terms.size());
        for (i = 0; i < terms.size(); ++i) {
            matrixColumnTemplate.add(false);
        }
        for (i = 0; i < this.columnHeaders.size(); ++i) {
            this.matrixColumns.add(new Vector(matrixColumnTemplate));
        }
        int count = 0;
        for (Term term : terms) {
            this.lineHeaders.add(term);
            Vector<Boolean> matrixLine = new Vector<Boolean>(matrixLineTemplate);
            this.matrixLines.add(matrixLine);
            for (Formula minterm : term.minterms()) {
                int index = this.columnHeaders.indexOf(minterm);
                matrixLine.setElementAt(true, index);
                this.matrixColumns.get(index).setElementAt(true, count);
            }
            ++count;
        }
    }

    protected Vector<Formula> initializeColumnHeaders(LinkedHashSet<Term> terms) {
        LinkedHashSet<Formula> header = new LinkedHashSet<Formula>();
        for (Term term : terms) {
            header.addAll(term.minterms());
        }
        return new Vector<Formula>(header);
    }

    void simplifyTableByDominance() {
        boolean eliminatedLines;
        boolean eliminatedColumns;
        boolean changed;
        do {
            eliminatedColumns = this.eliminateColumnDominance();
            eliminatedLines = this.eliminateLineDominance();
        } while (changed = eliminatedColumns || eliminatedLines);
    }

    protected boolean eliminateColumnDominance() {
        TreeSet<Integer> toEliminate = new TreeSet<Integer>();
        for (int i = 0; i < this.matrixColumns.size(); ++i) {
            for (int j = i + 1; j < this.matrixColumns.size(); ++j) {
                if (TermTable.isSubsetOf(this.matrixColumns.get(i), this.matrixColumns.get(j))) {
                    toEliminate.add(j);
                    continue;
                }
                if (!TermTable.isSubsetOf(this.matrixColumns.get(j), this.matrixColumns.get(i))) continue;
                toEliminate.add(i);
            }
        }
        int count = 0;
        for (Integer toDelete : toEliminate) {
            this.deleteColumn(toDelete - count++);
        }
        return !toEliminate.isEmpty();
    }

    protected boolean eliminateLineDominance() {
        TreeSet<Integer> toEliminate = new TreeSet<Integer>();
        for (int i = 0; i < this.matrixLines.size(); ++i) {
            for (int j = i + 1; j < this.matrixLines.size(); ++j) {
                if (TermTable.isSubsetOf(this.matrixLines.get(i), this.matrixLines.get(j))) {
                    toEliminate.add(i);
                    continue;
                }
                if (!TermTable.isSubsetOf(this.matrixLines.get(j), this.matrixLines.get(i))) continue;
                toEliminate.add(j);
            }
        }
        int count = 0;
        for (Integer toDelete : toEliminate) {
            this.deleteLine(toDelete - count++);
        }
        return !toEliminate.isEmpty();
    }

    static boolean isSubsetOf(Vector<Boolean> vec1, Vector<Boolean> vec2) {
        for (int i = 0; i < vec1.size(); ++i) {
            if (!vec1.get(i).booleanValue() || vec2.get(i).booleanValue()) continue;
            return false;
        }
        return true;
    }

    protected void deleteColumn(int colIndex) {
        this.columnHeaders.removeElementAt(colIndex);
        this.matrixColumns.removeElementAt(colIndex);
        for (Vector<Boolean> line : this.matrixLines) {
            line.removeElementAt(colIndex);
        }
    }

    protected void deleteLine(int lineIndex) {
        this.lineHeaders.removeElementAt(lineIndex);
        this.matrixLines.removeElementAt(lineIndex);
        for (Vector<Boolean> column : this.matrixColumns) {
            column.removeElementAt(lineIndex);
        }
    }

    Vector<Vector<Boolean>> lines() {
        return this.matrixLines;
    }

    Vector<Vector<Boolean>> columns() {
        return this.matrixColumns;
    }

    Vector<Formula> columnHeaders() {
        return this.columnHeaders;
    }

    Vector<Term> lineHeaders() {
        return this.lineHeaders;
    }

    public String toString() {
        Vector<String> lineHeaderStrings = new Vector<String>();
        for (Term header : this.lineHeaders) {
            lineHeaderStrings.add(this.formatBits(header.bits()));
        }
        int lineHeaderSize = ((String)lineHeaderStrings.firstElement()).length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < lineHeaderSize; ++i) {
            sb.append(" ");
        }
        sb.append(" | ");
        LinkedHashMap<String, String> legend = new LinkedHashMap<String, String>();
        int columnSize = 0;
        for (int i = 0; i < this.columnHeaders.size(); ++i) {
            String key = "m" + i;
            legend.put(key, this.columnHeaders.get(i).toString());
            if (key.length() <= columnSize) continue;
            columnSize = key.length();
        }
        for (String s : legend.keySet()) {
            sb.append(String.format("%s | ", TermTable.padRight(s, columnSize)));
        }
        sb.append(String.format("%n", new Object[0]));
        for (int i = 0; i < this.matrixLines.size(); ++i) {
            sb.append(String.format("%s | %s%n", lineHeaderStrings.get(i), this.formatMatrixLine(this.matrixLines.get(i), columnSize)));
        }
        return sb.toString();
    }

    protected String formatMatrixLine(Vector<Boolean> booleans, int size) {
        StringBuilder sb = new StringBuilder();
        for (Boolean entry : booleans) {
            sb.append(TermTable.padRight(entry != false ? "X" : " ", size)).append(" | ");
        }
        return sb.toString();
    }

    protected String formatBits(Tristate[] bits) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < bits.length; ++i) {
            if (bits[i] == Tristate.TRUE) {
                sb.append("1");
            } else if (bits[i] == Tristate.FALSE) {
                sb.append("0");
            } else {
                sb.append("-");
            }
            if (i >= bits.length - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    private static String padRight(String s, int n) {
        return String.format("%1$-" + n + "s", s);
    }
}

