/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.transformations.qmc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.logicng.datastructures.Tristate;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;

public class Term {
    protected final Tristate[] bits;
    protected final List<Formula> minterms;
    protected final int termClass;
    protected boolean used;
    protected final long undefNum;

    Term(Tristate[] bits, List<Formula> minterms) {
        this.bits = bits;
        this.minterms = minterms;
        this.termClass = this.countNonNegativeBits(bits);
        this.undefNum = this.computeUndefNum(bits);
    }

    protected int countNonNegativeBits(Tristate[] bits) {
        int result = 0;
        for (Tristate bit : bits) {
            if (bit == Tristate.FALSE) continue;
            ++result;
        }
        return result;
    }

    protected long computeUndefNum(Tristate[] bits) {
        long sum = 0L;
        for (int i = bits.length - 1; i >= 0; --i) {
            if (bits[i] != Tristate.UNDEF) continue;
            sum = (long)((double)sum + Math.pow(2.0, bits.length - 1 - i));
        }
        return sum;
    }

    Tristate[] bits() {
        return this.bits;
    }

    List<Formula> minterms() {
        return this.minterms;
    }

    int termClass() {
        return this.termClass;
    }

    boolean isUsed() {
        return this.used;
    }

    void setUsed(boolean used) {
        this.used = used;
    }

    Term combine(Term other) {
        if (this.bits.length != other.bits.length) {
            return null;
        }
        if (this.undefNum != other.undefNum) {
            return null;
        }
        int diffPosition = -1;
        for (int i = 0; i < this.bits.length; ++i) {
            if (this.bits[i] == other.bits[i]) continue;
            if (diffPosition != -1) {
                return null;
            }
            diffPosition = i;
        }
        if (diffPosition == -1) {
            return null;
        }
        Tristate[] newBits = Arrays.copyOf(this.bits, this.bits.length);
        newBits[diffPosition] = Tristate.UNDEF;
        ArrayList<Formula> newMinterms = new ArrayList<Formula>(this.minterms);
        newMinterms.addAll(other.minterms);
        return new Term(newBits, newMinterms);
    }

    Formula translateToFormula(List<Variable> varOrder) {
        FormulaFactory f = varOrder.get(0).factory();
        assert (this.bits.length == varOrder.size());
        ArrayList<Literal> operands = new ArrayList<Literal>(varOrder.size());
        for (int i = 0; i < this.bits.length; ++i) {
            if (this.bits[i] == Tristate.UNDEF) continue;
            operands.add(this.bits[i] == Tristate.TRUE ? (Literal)varOrder.get(i) : varOrder.get(i).negate());
        }
        return f.and(operands);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Term term = (Term)o;
        return Arrays.equals((Object[])this.bits, (Object[])term.bits);
    }

    public int hashCode() {
        return Arrays.hashCode((Object[])this.bits);
    }

    public String toString() {
        return "Term{bits=" + Arrays.toString((Object[])this.bits) + ", minterms=" + this.minterms + ", termClass=" + this.termClass + '}';
    }
}

