/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.transformations.qmc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.logicng.cardinalityconstraints.CCIncrementalData;
import org.logicng.datastructures.Assignment;
import org.logicng.datastructures.Tristate;
import org.logicng.formulas.CType;
import org.logicng.formulas.CardinalityConstraint;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;
import org.logicng.solvers.MiniSat;
import org.logicng.solvers.SATSolver;
import org.logicng.transformations.qmc.Term;
import org.logicng.transformations.qmc.TermTable;

public class QuineMcCluskeyAlgorithm {
    public static Formula compute(Formula formula, Collection<Variable> relevantVariables) {
        FormulaFactory f = formula.factory();
        MiniSat solver = MiniSat.miniSat(f);
        solver.add(formula);
        List<Assignment> models = relevantVariables == null ? solver.enumerateAllModels(formula.variables()) : solver.enumerateAllModels(relevantVariables);
        return QuineMcCluskeyAlgorithm.compute(models, f);
    }

    public static Formula compute(Formula formula) {
        return QuineMcCluskeyAlgorithm.compute(formula, formula.variables());
    }

    public static Formula compute(List<Assignment> models, FormulaFactory f) {
        if (models.isEmpty()) {
            return f.falsum();
        }
        if (models.size() == 1) {
            return models.get(0).formula(f);
        }
        ArrayList<Variable> varOrder = new ArrayList<Variable>(models.get(0).positiveVariables());
        varOrder.addAll(models.get(0).negativeVariables());
        Collections.sort(varOrder);
        List<Term> terms = QuineMcCluskeyAlgorithm.transformModels2Terms(models, varOrder, f);
        LinkedHashSet<Term> primeImplicants = QuineMcCluskeyAlgorithm.computePrimeImplicants(terms);
        TermTable primeTermTable = new TermTable(primeImplicants);
        primeTermTable.simplifyTableByDominance();
        List<Term> chosenTerms = QuineMcCluskeyAlgorithm.chooseSatBased(primeTermTable, f);
        return QuineMcCluskeyAlgorithm.computeFormula(chosenTerms, varOrder);
    }

    static List<Term> transformModels2Terms(List<Assignment> models, List<Variable> varOrder, FormulaFactory f) {
        ArrayList<Term> terms = new ArrayList<Term>(models.size());
        for (Assignment model : models) {
            ArrayList<Literal> minterm = new ArrayList<Literal>();
            for (Variable variable : varOrder) {
                minterm.add(model.evaluateLit(variable) ? variable : variable.negate());
            }
            terms.add(QuineMcCluskeyAlgorithm.convertToTerm(minterm, f));
        }
        return terms;
    }

    static LinkedHashSet<Term> computePrimeImplicants(List<Term> terms) {
        SortedMap<Integer, LinkedHashSet<Term>> termsInClasses = QuineMcCluskeyAlgorithm.generateInitialTermClasses(terms);
        SortedMap<Integer, LinkedHashSet<Term>> newTermsInClasses = QuineMcCluskeyAlgorithm.combineInTermClasses(termsInClasses);
        LinkedHashSet<Term> primeImplicants = QuineMcCluskeyAlgorithm.getUnusedTerms(termsInClasses);
        while (!newTermsInClasses.isEmpty()) {
            termsInClasses = newTermsInClasses;
            newTermsInClasses = QuineMcCluskeyAlgorithm.combineInTermClasses(termsInClasses);
            primeImplicants.addAll(QuineMcCluskeyAlgorithm.getUnusedTerms(termsInClasses));
        }
        return primeImplicants;
    }

    static SortedMap<Integer, LinkedHashSet<Term>> combineInTermClasses(SortedMap<Integer, LinkedHashSet<Term>> termsInClasses) {
        TreeMap<Integer, LinkedHashSet<Term>> newTermsInClasses = new TreeMap<Integer, LinkedHashSet<Term>>();
        for (int i = 0; i < termsInClasses.lastKey(); ++i) {
            LinkedHashSet thisClass = (LinkedHashSet)termsInClasses.get(i);
            LinkedHashSet otherClass = (LinkedHashSet)termsInClasses.get(i + 1);
            if (thisClass == null || otherClass == null) continue;
            for (Term thisTerm : thisClass) {
                for (Term otherTerm : otherClass) {
                    Term combined = thisTerm.combine(otherTerm);
                    if (combined == null) continue;
                    thisTerm.setUsed(true);
                    otherTerm.setUsed(true);
                    newTermsInClasses.computeIfAbsent(combined.termClass(), k -> new LinkedHashSet()).add(combined);
                }
            }
        }
        return newTermsInClasses;
    }

    static LinkedHashSet<Term> getUnusedTerms(SortedMap<Integer, LinkedHashSet<Term>> termsInClasses) {
        LinkedHashSet<Term> unusedTerms = new LinkedHashSet<Term>();
        for (Map.Entry<Integer, LinkedHashSet<Term>> entry : termsInClasses.entrySet()) {
            for (Term term : entry.getValue()) {
                if (term.isUsed()) continue;
                unusedTerms.add(term);
            }
        }
        return unusedTerms;
    }

    static SortedMap<Integer, LinkedHashSet<Term>> generateInitialTermClasses(List<Term> terms) {
        TreeMap<Integer, LinkedHashSet<Term>> termsInClasses = new TreeMap<Integer, LinkedHashSet<Term>>();
        for (Term term : terms) {
            termsInClasses.computeIfAbsent(term.termClass(), k -> new LinkedHashSet()).add(term);
        }
        return termsInClasses;
    }

    static Formula computeFormula(List<Term> chosenTerms, List<Variable> varOrder) {
        FormulaFactory f = varOrder.get(0).factory();
        ArrayList<Formula> operands = new ArrayList<Formula>(chosenTerms.size());
        for (Term term : chosenTerms) {
            operands.add(term.translateToFormula(varOrder));
        }
        return f.or(operands);
    }

    static Term convertToTerm(List<Literal> minterm, FormulaFactory f) {
        Tristate[] bits = new Tristate[minterm.size()];
        for (int i = 0; i < minterm.size(); ++i) {
            bits[i] = Tristate.fromBool(minterm.get(i).phase());
        }
        return new Term(bits, Collections.singletonList(f.and(minterm)));
    }

    static List<Term> chooseSatBased(TermTable table, FormulaFactory f) {
        LinkedHashMap<Variable, Term> var2Term = new LinkedHashMap<Variable, Term>();
        LinkedHashMap<Formula, Variable> formula2VarMapping = new LinkedHashMap<Formula, Variable>();
        SATSolver satSolver = QuineMcCluskeyAlgorithm.initializeSolver(table, f, var2Term, formula2VarMapping);
        if (satSolver.sat() == Tristate.FALSE) {
            throw new IllegalStateException("Solver must be satisfiable after adding the initial formula.");
        }
        return QuineMcCluskeyAlgorithm.minimize(satSolver, var2Term, f);
    }

    static SATSolver initializeSolver(TermTable table, FormulaFactory f, LinkedHashMap<Variable, Term> var2Term, LinkedHashMap<Formula, Variable> formula2VarMapping) {
        LinkedHashMap minterm2Variants = new LinkedHashMap();
        int count = 0;
        String prefix = "@MINTERM_SEL_";
        for (Formula formula : table.columnHeaders()) {
            Variable selector = f.variable(prefix + count++);
            formula2VarMapping.put(formula, selector);
            minterm2Variants.put(selector, new ArrayList());
        }
        count = 0;
        prefix = "@TERM_SEL_";
        MiniSat solver = MiniSat.miniSat(f);
        for (Term term : table.lineHeaders()) {
            Variable mintermSelector;
            Variable termSelector = f.variable(prefix + count);
            var2Term.put(termSelector, term);
            ArrayList<Variable> mintermSelectors = new ArrayList<Variable>();
            for (Formula formula : term.minterms()) {
                mintermSelector = formula2VarMapping.get(formula);
                if (mintermSelector == null) continue;
                Variable selectorVariant = f.variable(mintermSelector.name() + "_" + count);
                ((List)minterm2Variants.get(mintermSelector)).add(selectorVariant);
                mintermSelectors.add(selectorVariant);
            }
            ArrayList<Literal> operands = new ArrayList<Literal>();
            for (int i = 0; i < mintermSelectors.size(); ++i) {
                mintermSelector = (Variable)mintermSelectors.get(i);
                solver.add(f.clause(termSelector.negate(), mintermSelector));
                operands.add(mintermSelector.negate());
                for (int j = i + 1; j < mintermSelectors.size(); ++j) {
                    Variable mintermSelector2 = (Variable)mintermSelectors.get(j);
                    solver.add(f.or(mintermSelector.negate(), mintermSelector2));
                    solver.add(f.or(mintermSelector2.negate(), mintermSelector));
                }
            }
            operands.add(termSelector);
            solver.add(f.clause(operands));
            ++count;
        }
        for (List variables : minterm2Variants.values()) {
            solver.add(f.clause(variables));
        }
        return solver;
    }

    static List<Term> minimize(SATSolver satSolver, LinkedHashMap<Variable, Term> var2Term, FormulaFactory f) {
        Assignment initialModel = satSolver.model();
        List<Variable> currentTermVars = QuineMcCluskeyAlgorithm.computeCurrentTermVars(initialModel, var2Term.keySet());
        if (currentTermVars.size() == 2) {
            satSolver.add(f.amo(var2Term.keySet()));
            if (satSolver.sat() == Tristate.TRUE) {
                currentTermVars = QuineMcCluskeyAlgorithm.computeCurrentTermVars(satSolver.model(), var2Term.keySet());
            }
        } else {
            Formula cc = f.cc(CType.LE, currentTermVars.size() - 1, var2Term.keySet());
            assert (cc instanceof CardinalityConstraint);
            CCIncrementalData incData = satSolver.addIncrementalCC((CardinalityConstraint)cc);
            while (satSolver.sat() == Tristate.TRUE) {
                currentTermVars = QuineMcCluskeyAlgorithm.computeCurrentTermVars(satSolver.model(), var2Term.keySet());
                incData.newUpperBoundForSolver(currentTermVars.size() - 1);
            }
        }
        return QuineMcCluskeyAlgorithm.computeTerms(currentTermVars, var2Term);
    }

    static List<Term> computeTerms(List<Variable> currentTermVars, LinkedHashMap<Variable, Term> var2Term) {
        ArrayList<Term> terms = new ArrayList<Term>(currentTermVars.size());
        for (Variable currentTermVar : currentTermVars) {
            terms.add(var2Term.get(currentTermVar));
        }
        return terms;
    }

    static List<Variable> computeCurrentTermVars(Assignment model, Collection<Variable> vars) {
        ArrayList<Variable> result = new ArrayList<Variable>();
        for (Variable var : vars) {
            if (!model.evaluateLit(var)) continue;
            result.add(var);
        }
        return result;
    }
}

