/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.transformations.qe;

import java.util.Arrays;
import java.util.Collection;
import org.logicng.datastructures.Assignment;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.FormulaTransformation;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;

public final class UniversalQuantifierElimination
implements FormulaTransformation {
    private final Variable[] elimination;

    public UniversalQuantifierElimination(Variable ... variables) {
        this.elimination = Arrays.copyOf(variables, variables.length);
    }

    public UniversalQuantifierElimination(Collection<Variable> variables) {
        this.elimination = variables.toArray(new Variable[0]);
    }

    @Override
    public Formula apply(Formula formula, boolean cache) {
        Formula result = formula;
        FormulaFactory f = formula.factory();
        for (Variable var : this.elimination) {
            result = f.and(result.restrict(new Assignment((Literal)var)), result.restrict(new Assignment(var.negate())));
        }
        return result;
    }
}

