/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.transformations.dnf;

import java.util.ArrayList;
import java.util.SortedSet;
import org.logicng.datastructures.ubtrees.UBTree;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaTransformation;
import org.logicng.formulas.Literal;
import org.logicng.predicates.DNFPredicate;
import org.logicng.transformations.Subsumption;

public final class DNFSubsumption
extends Subsumption
implements FormulaTransformation {
    @Override
    public Formula apply(Formula formula, boolean cache) {
        if (!formula.holds(DNFPredicate.get())) {
            throw new IllegalArgumentException("DNF subsumption can only be applied to formulas in DNF");
        }
        if (formula.type().precedence() >= FType.LITERAL.precedence() || formula.type() == FType.AND) {
            return formula;
        }
        assert (formula.type() == FType.OR);
        UBTree<Literal> ubTree = DNFSubsumption.generateSubsumedUBTree(formula);
        ArrayList<Formula> minterms = new ArrayList<Formula>();
        for (SortedSet<Literal> literals : ubTree.allSets()) {
            minterms.add(formula.factory().and(literals));
        }
        return formula.factory().or(minterms);
    }
}

