/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.transformations.dnf;

import java.util.ArrayList;
import java.util.List;
import org.logicng.datastructures.Assignment;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.FormulaTransformation;
import org.logicng.solvers.MiniSat;
import org.logicng.solvers.SATSolver;
import org.logicng.solvers.functions.ModelEnumerationFunction;

public final class CanonicalDNFEnumeration
implements FormulaTransformation {
    @Override
    public Formula apply(Formula formula, boolean cache) {
        FormulaFactory f = formula.factory();
        MiniSat solver = MiniSat.miniSat(f);
        solver.add(formula);
        List<Assignment> enumeration = ((SATSolver)solver).execute(ModelEnumerationFunction.builder().build());
        if (enumeration.isEmpty()) {
            return f.falsum();
        }
        ArrayList<Formula> ops = new ArrayList<Formula>();
        for (Assignment a : enumeration) {
            ops.add(a.formula(f));
        }
        return f.or(ops);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

