/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.transformations.cnf;

import java.util.ArrayList;
import java.util.List;
import org.logicng.datastructures.Assignment;
import org.logicng.formulas.And;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.FormulaTransformation;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;
import org.logicng.formulas.cache.TransformationCacheEntry;
import org.logicng.predicates.CNFPredicate;
import org.logicng.transformations.cnf.CNFFactorization;

public final class TseitinTransformation
implements FormulaTransformation {
    private final int boundaryForFactorization;
    private final CNFFactorization factorization = new CNFFactorization();

    public TseitinTransformation(int boundaryForFactorization) {
        this.boundaryForFactorization = boundaryForFactorization;
    }

    public TseitinTransformation() {
        this.boundaryForFactorization = 12;
    }

    @Override
    public Formula apply(Formula formula, boolean cache) {
        Formula f = formula.nnf();
        if (f.holds(CNFPredicate.get())) {
            return f;
        }
        Formula tseitin = f.transformationCacheEntry(TransformationCacheEntry.TSEITIN);
        if (tseitin != null) {
            Assignment topLevel = new Assignment((Literal)f.transformationCacheEntry(TransformationCacheEntry.TSEITIN_VARIABLE));
            return f.transformationCacheEntry(TransformationCacheEntry.TSEITIN).restrict(topLevel);
        }
        if (f.numberOfAtoms() < (long)this.boundaryForFactorization) {
            tseitin = f.transform(this.factorization);
        } else {
            for (Formula formula1 : f.apply(f.factory().subformulaFunction())) {
                this.computeTseitin(formula1);
            }
            Assignment topLevel = new Assignment((Literal)f.transformationCacheEntry(TransformationCacheEntry.TSEITIN_VARIABLE));
            tseitin = f.transformationCacheEntry(TransformationCacheEntry.TSEITIN).restrict(topLevel);
        }
        if (cache) {
            formula.setTransformationCacheEntry(TransformationCacheEntry.TSEITIN_VARIABLE, f.transformationCacheEntry(TransformationCacheEntry.TSEITIN_VARIABLE));
        }
        return tseitin;
    }

    private void computeTseitin(Formula formula) {
        if (formula.transformationCacheEntry(TransformationCacheEntry.TSEITIN) != null) {
            return;
        }
        FormulaFactory f = formula.factory();
        switch (formula.type()) {
            case LITERAL: {
                formula.setTransformationCacheEntry(TransformationCacheEntry.TSEITIN, formula);
                formula.setTransformationCacheEntry(TransformationCacheEntry.TSEITIN_VARIABLE, formula);
                break;
            }
            case AND: 
            case OR: {
                boolean isConjunction = formula instanceof And;
                Variable tsLiteral = f.newCNFVariable();
                ArrayList<Formula> nops = new ArrayList<Formula>();
                ArrayList<Formula> operands = new ArrayList<Formula>(formula.numberOfOperands());
                ArrayList<Formula> negOperands = new ArrayList<Formula>(formula.numberOfOperands());
                if (isConjunction) {
                    negOperands.add(tsLiteral);
                    this.handleNary(formula, nops, operands, negOperands);
                    for (Formula operand : operands) {
                        nops.add(f.or(tsLiteral.negate(), operand));
                    }
                    nops.add(f.or(negOperands));
                } else {
                    operands.add(tsLiteral.negate());
                    this.handleNary(formula, nops, operands, negOperands);
                    for (Formula operand : negOperands) {
                        nops.add(f.or(tsLiteral, operand));
                    }
                    nops.add(f.or(operands));
                }
                formula.setTransformationCacheEntry(TransformationCacheEntry.TSEITIN_VARIABLE, tsLiteral);
                formula.setTransformationCacheEntry(TransformationCacheEntry.TSEITIN, f.and(nops));
                break;
            }
            default: {
                throw new IllegalArgumentException("Could not process the formula type " + (Object)((Object)formula.type()));
            }
        }
    }

    private void handleNary(Formula formula, List<Formula> nops, List<Formula> operands, List<Formula> negOperands) {
        for (Formula op : formula) {
            if (op.type() != FType.LITERAL) {
                this.computeTseitin(op);
                nops.add(op.transformationCacheEntry(TransformationCacheEntry.TSEITIN));
            }
            operands.add(op.transformationCacheEntry(TransformationCacheEntry.TSEITIN_VARIABLE));
            negOperands.add(op.transformationCacheEntry(TransformationCacheEntry.TSEITIN_VARIABLE).negate());
        }
    }

    public String toString() {
        return String.format("TseitinTransformation{boundary=%d}", this.boundaryForFactorization);
    }
}

