/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.transformations.cnf;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.logicng.collections.LNGIntVector;
import org.logicng.formulas.Equivalence;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.Implication;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Not;
import org.logicng.predicates.CNFPredicate;
import org.logicng.predicates.ContainsPBCPredicate;
import org.logicng.propositions.Proposition;
import org.logicng.solvers.sat.MiniSatStyleSolver;
import org.logicng.util.Pair;

public final class PlaistedGreenbaumTransformationSolver {
    private final boolean performNNF;
    private final Map<Formula, VarCacheEntry> variableCache;
    private final MiniSatStyleSolver solver;
    private final boolean initialPhase;

    public PlaistedGreenbaumTransformationSolver(boolean performNNF, MiniSatStyleSolver solver, boolean initialPhase) {
        this.performNNF = performNNF;
        this.variableCache = new HashMap<Formula, VarCacheEntry>();
        this.solver = solver;
        this.initialPhase = initialPhase;
    }

    public void addCNFtoSolver(Formula formula, Proposition proposition) {
        Formula withoutPBCs;
        Formula workingFormula = this.performNNF ? formula.nnf() : formula;
        Formula formula2 = withoutPBCs = !this.performNNF && workingFormula.holds(ContainsPBCPredicate.get()) ? workingFormula.nnf() : workingFormula;
        if (withoutPBCs.holds(CNFPredicate.get())) {
            this.addCNF(withoutPBCs, proposition);
        } else {
            LNGIntVector topLevelVars = this.computeTransformation(withoutPBCs, true, proposition, true);
            if (topLevelVars != null) {
                this.solver.addClause(topLevelVars, proposition);
            }
        }
    }

    public void clearCache() {
        this.variableCache.clear();
    }

    private void addCNF(Formula cnf, Proposition proposition) {
        switch (cnf.type()) {
            case TRUE: {
                break;
            }
            case FALSE: 
            case LITERAL: 
            case OR: {
                this.solver.addClause(this.generateClauseVector(cnf.literals()), proposition);
                break;
            }
            case AND: {
                for (Formula clause : cnf) {
                    this.solver.addClause(this.generateClauseVector(clause.literals()), proposition);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Input formula ist not a valid CNF: " + cnf);
            }
        }
    }

    private LNGIntVector computeTransformation(Formula formula, boolean polarity, Proposition proposition, boolean topLevel) {
        switch (formula.type()) {
            case LITERAL: {
                Literal lit = (Literal)formula;
                return polarity ? PlaistedGreenbaumTransformationSolver.vector(this.solverLiteral(lit.name(), lit.phase())) : PlaistedGreenbaumTransformationSolver.vector(this.solverLiteral(lit.name(), lit.phase()) ^ 1);
            }
            case NOT: {
                return this.computeTransformation(((Not)formula).operand(), !polarity, proposition, topLevel);
            }
            case OR: 
            case AND: {
                return this.handleNary(formula, polarity, proposition, topLevel);
            }
            case IMPL: {
                return this.handleImplication((Implication)formula, polarity, proposition, topLevel);
            }
            case EQUIV: {
                return this.handleEquivalence((Equivalence)formula, polarity, proposition, topLevel);
            }
        }
        throw new IllegalArgumentException("Could not process the formula type " + (Object)((Object)formula.type()));
    }

    private LNGIntVector handleImplication(Implication formula, boolean polarity, Proposition proposition, boolean topLevel) {
        int pgVar;
        Pair<Boolean, Integer> pgVarResult;
        boolean skipPg = polarity || topLevel;
        Pair<Boolean, Integer> pair = pgVarResult = skipPg ? new Pair<Boolean, Integer>(false, null) : this.getPgVar(formula, polarity);
        if (pgVarResult.first().booleanValue()) {
            return polarity ? PlaistedGreenbaumTransformationSolver.vector(pgVarResult.second()) : PlaistedGreenbaumTransformationSolver.vector(pgVarResult.second() ^ 1);
        }
        int n = pgVar = skipPg ? -1 : pgVarResult.second();
        if (polarity) {
            LNGIntVector leftPgVarNeg = this.computeTransformation(formula.left(), false, proposition, false);
            LNGIntVector rightPgVarPos = this.computeTransformation(formula.right(), true, proposition, false);
            return PlaistedGreenbaumTransformationSolver.vector(leftPgVarNeg, rightPgVarPos);
        }
        LNGIntVector leftPgVarPos = this.computeTransformation(formula.left(), true, proposition, topLevel);
        LNGIntVector rightPgVarNeg = this.computeTransformation(formula.right(), false, proposition, topLevel);
        if (topLevel) {
            if (leftPgVarPos != null) {
                this.solver.addClause(leftPgVarPos, proposition);
            }
            if (rightPgVarNeg != null) {
                this.solver.addClause(rightPgVarNeg, proposition);
            }
            return null;
        }
        this.solver.addClause(PlaistedGreenbaumTransformationSolver.vector(pgVar, leftPgVarPos), proposition);
        this.solver.addClause(PlaistedGreenbaumTransformationSolver.vector(pgVar, rightPgVarNeg), proposition);
        return PlaistedGreenbaumTransformationSolver.vector(pgVar ^ 1);
    }

    private LNGIntVector handleEquivalence(Equivalence formula, boolean polarity, Proposition proposition, boolean topLevel) {
        Pair<Boolean, Integer> pgVarResult;
        boolean skipPg = topLevel;
        Pair<Boolean, Integer> pair = pgVarResult = skipPg ? new Pair<Boolean, Integer>(false, null) : this.getPgVar(formula, polarity);
        if (pgVarResult.first().booleanValue()) {
            return polarity ? PlaistedGreenbaumTransformationSolver.vector(pgVarResult.second()) : PlaistedGreenbaumTransformationSolver.vector(pgVarResult.second() ^ 1);
        }
        int pgVar = skipPg ? -1 : pgVarResult.second();
        LNGIntVector leftPgVarPos = this.computeTransformation(formula.left(), true, proposition, false);
        LNGIntVector leftPgVarNeg = this.computeTransformation(formula.left(), false, proposition, false);
        LNGIntVector rightPgVarPos = this.computeTransformation(formula.right(), true, proposition, false);
        LNGIntVector rightPgVarNeg = this.computeTransformation(formula.right(), false, proposition, false);
        if (polarity) {
            if (topLevel) {
                this.solver.addClause(PlaistedGreenbaumTransformationSolver.vector(leftPgVarNeg, rightPgVarPos), proposition);
                this.solver.addClause(PlaistedGreenbaumTransformationSolver.vector(leftPgVarPos, rightPgVarNeg), proposition);
                return null;
            }
            this.solver.addClause(PlaistedGreenbaumTransformationSolver.vector(pgVar ^ 1, leftPgVarNeg, rightPgVarPos), proposition);
            this.solver.addClause(PlaistedGreenbaumTransformationSolver.vector(pgVar ^ 1, leftPgVarPos, rightPgVarNeg), proposition);
        } else {
            if (topLevel) {
                this.solver.addClause(PlaistedGreenbaumTransformationSolver.vector(leftPgVarPos, rightPgVarPos), proposition);
                this.solver.addClause(PlaistedGreenbaumTransformationSolver.vector(leftPgVarNeg, rightPgVarNeg), proposition);
                return null;
            }
            this.solver.addClause(PlaistedGreenbaumTransformationSolver.vector(pgVar, leftPgVarPos, rightPgVarPos), proposition);
            this.solver.addClause(PlaistedGreenbaumTransformationSolver.vector(pgVar, leftPgVarNeg, rightPgVarNeg), proposition);
        }
        return polarity ? PlaistedGreenbaumTransformationSolver.vector(pgVar) : PlaistedGreenbaumTransformationSolver.vector(pgVar ^ 1);
    }

    private LNGIntVector handleNary(Formula formula, boolean polarity, Proposition proposition, boolean topLevel) {
        Pair<Boolean, Integer> pgVarResult;
        boolean skipPg = topLevel || formula.type() == FType.AND && !polarity || formula.type() == FType.OR && polarity;
        Pair<Boolean, Integer> pair = pgVarResult = skipPg ? new Pair<Boolean, Integer>(false, null) : this.getPgVar(formula, polarity);
        if (pgVarResult.first().booleanValue()) {
            return polarity ? PlaistedGreenbaumTransformationSolver.vector(pgVarResult.second()) : PlaistedGreenbaumTransformationSolver.vector(pgVarResult.second() ^ 1);
        }
        int pgVar = skipPg ? -1 : pgVarResult.second();
        switch (formula.type()) {
            case AND: {
                if (polarity) {
                    for (Formula op : formula) {
                        LNGIntVector opPgVars = this.computeTransformation(op, true, proposition, topLevel);
                        if (topLevel) {
                            if (opPgVars == null) continue;
                            this.solver.addClause(opPgVars, proposition);
                            continue;
                        }
                        this.solver.addClause(PlaistedGreenbaumTransformationSolver.vector(pgVar ^ 1, opPgVars), proposition);
                    }
                    if (!topLevel) break;
                    return null;
                }
                LNGIntVector singleClause = new LNGIntVector();
                for (Formula op : formula) {
                    LNGIntVector opPgVars = this.computeTransformation(op, false, proposition, false);
                    for (int i = 0; i < opPgVars.size(); ++i) {
                        singleClause.push(opPgVars.get(i));
                    }
                }
                return singleClause;
            }
            case OR: {
                if (polarity) {
                    LNGIntVector singleClause = new LNGIntVector();
                    for (Formula op : formula) {
                        LNGIntVector opPgVars = this.computeTransformation(op, true, proposition, false);
                        for (int i = 0; i < opPgVars.size(); ++i) {
                            singleClause.push(opPgVars.get(i));
                        }
                    }
                    return singleClause;
                }
                for (Formula op : formula) {
                    LNGIntVector opPgVars = this.computeTransformation(op, false, proposition, topLevel);
                    if (topLevel) {
                        if (opPgVars == null) continue;
                        this.solver.addClause(opPgVars, proposition);
                        continue;
                    }
                    this.solver.addClause(PlaistedGreenbaumTransformationSolver.vector(pgVar, opPgVars), proposition);
                }
                if (!topLevel) break;
                return null;
            }
            default: {
                throw new IllegalArgumentException("Unexpected type: " + (Object)((Object)formula.type()));
            }
        }
        return polarity ? PlaistedGreenbaumTransformationSolver.vector(pgVar) : PlaistedGreenbaumTransformationSolver.vector(pgVar ^ 1);
    }

    private Pair<Boolean, Integer> getPgVar(Formula formula, boolean polarity) {
        VarCacheEntry entry = this.variableCache.computeIfAbsent(formula, i -> new VarCacheEntry(this.newSolverVariable()));
        boolean wasCached = entry.setPolarityCached(polarity);
        int pgVar = entry.pgVar;
        return new Pair<Boolean, Integer>(wasCached, pgVar);
    }

    private LNGIntVector generateClauseVector(Collection<Literal> literals) {
        LNGIntVector clauseVec = new LNGIntVector(literals.size());
        for (Literal lit : literals) {
            clauseVec.unsafePush(this.solverLiteral(lit.name(), lit.phase()));
        }
        return clauseVec;
    }

    private int solverLiteral(String name, boolean phase) {
        int index = this.solver.idxForName(name);
        if (index == -1) {
            index = this.solver.newVar(!this.initialPhase, true);
            this.solver.addName(name, index);
        }
        return phase ? index * 2 : index * 2 ^ 1;
    }

    private int newSolverVariable() {
        int index = this.solver.newVar(!this.initialPhase, true);
        String name = "@RESERVED_CNF_MINISAT_" + index;
        this.solver.addName(name, index);
        return index * 2;
    }

    private static LNGIntVector vector(int ... elts) {
        return new LNGIntVector(elts);
    }

    private static LNGIntVector vector(LNGIntVector a, LNGIntVector b) {
        int i;
        LNGIntVector result = new LNGIntVector(a.size() + b.size());
        for (i = 0; i < a.size(); ++i) {
            result.unsafePush(a.get(i));
        }
        for (i = 0; i < b.size(); ++i) {
            result.unsafePush(b.get(i));
        }
        return result;
    }

    private static LNGIntVector vector(int elt, LNGIntVector a) {
        LNGIntVector result = new LNGIntVector(a.size() + 1);
        result.unsafePush(elt);
        for (int i = 0; i < a.size(); ++i) {
            result.unsafePush(a.get(i));
        }
        return result;
    }

    private static LNGIntVector vector(int elt, LNGIntVector a, LNGIntVector b) {
        int i;
        LNGIntVector result = new LNGIntVector(a.size() + b.size() + 1);
        result.unsafePush(elt);
        for (i = 0; i < a.size(); ++i) {
            result.unsafePush(a.get(i));
        }
        for (i = 0; i < b.size(); ++i) {
            result.unsafePush(b.get(i));
        }
        return result;
    }

    private static class VarCacheEntry {
        private final Integer pgVar;
        private boolean posPolarityCached = false;
        private boolean negPolarityCached = false;

        public VarCacheEntry(Integer pgVar) {
            this.pgVar = pgVar;
        }

        public boolean setPolarityCached(boolean polarity) {
            boolean wasCached;
            if (polarity) {
                wasCached = this.posPolarityCached;
                this.posPolarityCached = true;
            } else {
                wasCached = this.negPolarityCached;
                this.negPolarityCached = true;
            }
            return wasCached;
        }
    }
}

