/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.transformations.cnf;

import java.util.ArrayList;
import org.logicng.datastructures.Assignment;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.FormulaTransformation;
import org.logicng.formulas.Literal;
import org.logicng.formulas.cache.TransformationCacheEntry;
import org.logicng.predicates.CNFPredicate;
import org.logicng.transformations.cnf.CNFFactorization;

public final class PlaistedGreenbaumTransformation
implements FormulaTransformation {
    private final int boundaryForFactorization;
    private final CNFFactorization factorization = new CNFFactorization();

    public PlaistedGreenbaumTransformation(int boundaryForFactorization) {
        this.boundaryForFactorization = boundaryForFactorization;
    }

    public PlaistedGreenbaumTransformation() {
        this(12);
    }

    private static Literal pgVariable(Formula formula) {
        if (formula.type() == FType.LITERAL) {
            return (Literal)formula;
        }
        Literal var = (Literal)formula.transformationCacheEntry(TransformationCacheEntry.PLAISTED_GREENBAUM_VARIABLE);
        if (var == null) {
            var = formula.factory().newCNFVariable();
            formula.setTransformationCacheEntry(TransformationCacheEntry.PLAISTED_GREENBAUM_VARIABLE, var);
        }
        return var;
    }

    @Override
    public Formula apply(Formula formula, boolean cache) {
        Formula pg;
        Formula nnf = formula.nnf();
        if (nnf.holds(CNFPredicate.get())) {
            return nnf;
        }
        if (nnf.numberOfAtoms() < (long)this.boundaryForFactorization) {
            pg = nnf.transform(this.factorization);
        } else {
            pg = this.computeTransformation(nnf);
            Assignment topLevel = new Assignment((Literal)nnf.transformationCacheEntry(TransformationCacheEntry.PLAISTED_GREENBAUM_VARIABLE));
            pg = pg.restrict(topLevel);
        }
        if (cache) {
            formula.setTransformationCacheEntry(TransformationCacheEntry.PLAISTED_GREENBAUM_VARIABLE, nnf.transformationCacheEntry(TransformationCacheEntry.PLAISTED_GREENBAUM_VARIABLE));
        }
        return pg;
    }

    private Formula computeTransformation(Formula formula) {
        FormulaFactory f = formula.factory();
        switch (formula.type()) {
            case LITERAL: {
                return f.verum();
            }
            case OR: 
            case AND: {
                ArrayList<Formula> nops = new ArrayList<Formula>();
                nops.add(this.computePosPolarity(formula));
                for (Formula op : formula) {
                    nops.add(this.computeTransformation(op));
                }
                return f.and(nops);
            }
        }
        throw new IllegalArgumentException("Could not process the formula type " + (Object)((Object)formula.type()));
    }

    private Formula computePosPolarity(Formula formula) {
        Formula result = formula.transformationCacheEntry(TransformationCacheEntry.PLAISTED_GREENBAUM_POS);
        if (result != null) {
            return result;
        }
        FormulaFactory f = formula.factory();
        Literal pgVar = PlaistedGreenbaumTransformation.pgVariable(formula);
        switch (formula.type()) {
            case AND: {
                ArrayList<Formula> nops = new ArrayList<Formula>();
                for (Formula op : formula) {
                    nops.add(f.clause(pgVar.negate(), PlaistedGreenbaumTransformation.pgVariable(op)));
                }
                result = f.and(nops);
                formula.setTransformationCacheEntry(TransformationCacheEntry.PLAISTED_GREENBAUM_POS, result);
                return result;
            }
            case OR: {
                ArrayList<Literal> nops = new ArrayList<Literal>();
                nops.add(pgVar.negate());
                for (Formula op : formula) {
                    nops.add(PlaistedGreenbaumTransformation.pgVariable(op));
                }
                result = f.clause(nops);
                formula.setTransformationCacheEntry(TransformationCacheEntry.PLAISTED_GREENBAUM_POS, result);
                return result;
            }
        }
        throw new IllegalArgumentException("Unknown or unexpected formula type. Expected AND or OR formula type only.");
    }

    public String toString() {
        return String.format("PlaistedGreenbaumTransformation{boundary=%d}", this.boundaryForFactorization);
    }
}

