/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.transformations.cnf;

import java.util.ArrayList;
import java.util.SortedSet;
import org.logicng.datastructures.ubtrees.UBTree;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaTransformation;
import org.logicng.formulas.Literal;
import org.logicng.predicates.CNFPredicate;
import org.logicng.transformations.Subsumption;

public final class CNFSubsumption
extends Subsumption
implements FormulaTransformation {
    @Override
    public Formula apply(Formula formula, boolean cache) {
        if (!formula.holds(CNFPredicate.get())) {
            throw new IllegalArgumentException("CNF subsumption can only be applied to formulas in CNF");
        }
        if (formula.type().precedence() >= FType.LITERAL.precedence() || formula.type() == FType.OR) {
            return formula;
        }
        assert (formula.type() == FType.AND);
        UBTree<Literal> ubTree = CNFSubsumption.generateSubsumedUBTree(formula);
        ArrayList<Formula> clauses = new ArrayList<Formula>();
        for (SortedSet<Literal> literals : ubTree.allSets()) {
            clauses.add(formula.factory().clause(literals));
        }
        return formula.factory().cnf(clauses);
    }
}

