/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.transformations.cnf;

import java.util.Iterator;
import java.util.LinkedHashSet;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.FormulaTransformation;
import org.logicng.formulas.cache.TransformationCacheEntry;
import org.logicng.handlers.FactorizationHandler;

public final class CNFFactorization
implements FormulaTransformation {
    private final FactorizationHandler handler;
    private boolean proceed = true;

    public CNFFactorization() {
        this.handler = null;
    }

    public CNFFactorization(FactorizationHandler handler) {
        this.handler = handler;
    }

    @Override
    public Formula apply(Formula formula, boolean cache) {
        if (this.handler != null) {
            this.handler.started();
        }
        this.proceed = true;
        return this.applyRec(formula, cache);
    }

    private Formula applyRec(Formula formula, boolean cache) {
        if (!this.proceed) {
            return null;
        }
        if (formula.type().precedence() >= FType.LITERAL.precedence()) {
            return formula;
        }
        Formula cached = formula.transformationCacheEntry(TransformationCacheEntry.FACTORIZED_CNF);
        if (cached != null) {
            return cached;
        }
        switch (formula.type()) {
            case NOT: 
            case IMPL: 
            case EQUIV: {
                cached = this.applyRec(formula.nnf(), cache);
                break;
            }
            case OR: {
                LinkedHashSet<Formula> nops = new LinkedHashSet<Formula>();
                for (Formula op : formula) {
                    if (!this.proceed) {
                        return null;
                    }
                    nops.add(this.applyRec(op, cache));
                }
                Iterator it = nops.iterator();
                cached = (Formula)it.next();
                while (it.hasNext()) {
                    if (!this.proceed) {
                        return null;
                    }
                    cached = this.distribute(cached, (Formula)it.next());
                }
                break;
            }
            case AND: {
                LinkedHashSet<Formula> nops = new LinkedHashSet<Formula>();
                for (Formula op : formula) {
                    Formula apply = this.applyRec(op, cache);
                    if (!this.proceed) {
                        return null;
                    }
                    nops.add(apply);
                }
                cached = formula.factory().and(nops);
                break;
            }
            case PBC: {
                cached = formula.nnf();
                break;
            }
            default: {
                throw new IllegalArgumentException("Could not process the formula type " + (Object)((Object)formula.type()));
            }
        }
        if (this.proceed) {
            if (cache) {
                formula.setTransformationCacheEntry(TransformationCacheEntry.FACTORIZED_CNF, cached);
            }
            return cached;
        }
        return null;
    }

    private Formula distribute(Formula f1, Formula f2) {
        if (this.handler != null) {
            this.proceed = this.handler.performedDistribution();
        }
        if (this.proceed) {
            FormulaFactory f = f1.factory();
            if (f1.type() == FType.AND || f2.type() == FType.AND) {
                LinkedHashSet<Formula> nops = new LinkedHashSet<Formula>();
                for (Formula op : f1.type() == FType.AND ? f1 : f2) {
                    Formula distribute = this.distribute(op, f1.type() == FType.AND ? f2 : f1);
                    if (!this.proceed) {
                        return null;
                    }
                    nops.add(distribute);
                }
                return f.and(nops);
            }
            Formula clause = f.or(f1, f2);
            if (this.handler != null) {
                this.proceed = this.handler.createdClause(clause);
            }
            return clause;
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

