/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.transformations.cnf;

import java.util.ArrayList;
import org.logicng.configurations.Configuration;
import org.logicng.configurations.ConfigurationType;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.handlers.ComputationHandler;
import org.logicng.handlers.FactorizationHandler;
import org.logicng.transformations.cnf.BDDCNFTransformation;
import org.logicng.transformations.cnf.CNFConfig;
import org.logicng.transformations.cnf.CNFFactorization;
import org.logicng.transformations.cnf.PlaistedGreenbaumTransformation;
import org.logicng.transformations.cnf.TseitinTransformation;

public class CNFEncoder {
    protected final FormulaFactory f;
    protected final CNFConfig config;
    protected final CNFConfig defaultConfig;
    protected CNFFactorization factorization;
    protected CNFFactorization advancedFactorization;
    protected BDDCNFTransformation bddCnfTransformation;
    protected TseitinTransformation tseitin;
    protected PlaistedGreenbaumTransformation plaistedGreenbaum;
    protected int currentAtomBoundary;
    protected AdvancedFactorizationHandler factorizationHandler;

    public CNFEncoder(FormulaFactory f, CNFConfig config) {
        this.f = f;
        this.config = config;
        this.defaultConfig = CNFConfig.builder().build();
    }

    public CNFEncoder(FormulaFactory f) {
        this(f, null);
    }

    public Formula encode(Formula formula) {
        switch (this.config().algorithm) {
            case FACTORIZATION: {
                if (this.factorization == null) {
                    this.factorization = new CNFFactorization();
                }
                return formula.transform(this.factorization);
            }
            case TSEITIN: {
                if (this.tseitin == null || this.currentAtomBoundary != this.config().atomBoundary) {
                    this.currentAtomBoundary = this.config().atomBoundary;
                    this.tseitin = new TseitinTransformation(this.config().atomBoundary);
                }
                return formula.transform(this.tseitin);
            }
            case PLAISTED_GREENBAUM: {
                if (this.plaistedGreenbaum == null || this.currentAtomBoundary != this.config().atomBoundary) {
                    this.currentAtomBoundary = this.config().atomBoundary;
                    this.plaistedGreenbaum = new PlaistedGreenbaumTransformation(this.config().atomBoundary);
                }
                return formula.transform(this.plaistedGreenbaum);
            }
            case BDD: {
                if (this.bddCnfTransformation == null) {
                    this.bddCnfTransformation = new BDDCNFTransformation();
                }
                return formula.transform(this.bddCnfTransformation);
            }
            case ADVANCED: {
                if (this.factorizationHandler == null) {
                    this.factorizationHandler = new AdvancedFactorizationHandler();
                    this.advancedFactorization = new CNFFactorization(this.factorizationHandler);
                }
                this.factorizationHandler.setBounds(this.config().distributionBoundary, this.config().createdClauseBoundary);
                return this.advancedEncoding(formula);
            }
        }
        throw new IllegalStateException("Unknown CNF encoding algorithm: " + (Object)((Object)this.config().algorithm));
    }

    protected Formula advancedEncoding(Formula formula) {
        if (formula.type() == FType.AND) {
            ArrayList<Formula> operands = new ArrayList<Formula>(formula.numberOfOperands());
            for (Formula op : formula) {
                operands.add(this.singleAdvancedEncoding(op));
            }
            return this.f.and(operands);
        }
        return this.singleAdvancedEncoding(formula);
    }

    protected Formula singleAdvancedEncoding(Formula formula) {
        Formula result = formula.transform(this.advancedFactorization);
        if (result == null) {
            switch (this.config().fallbackAlgorithmForAdvancedEncoding) {
                case TSEITIN: {
                    if (this.tseitin == null || this.currentAtomBoundary != this.config().atomBoundary) {
                        this.currentAtomBoundary = this.config().atomBoundary;
                        this.tseitin = new TseitinTransformation(this.config().atomBoundary);
                    }
                    result = formula.transform(this.tseitin);
                    break;
                }
                case PLAISTED_GREENBAUM: {
                    if (this.plaistedGreenbaum == null || this.currentAtomBoundary != this.config().atomBoundary) {
                        this.currentAtomBoundary = this.config().atomBoundary;
                        this.plaistedGreenbaum = new PlaistedGreenbaumTransformation(this.config().atomBoundary);
                    }
                    result = formula.transform(this.plaistedGreenbaum);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid fallback CNF encoding algorithm: " + (Object)((Object)this.config().fallbackAlgorithmForAdvancedEncoding));
                }
            }
        }
        return result;
    }

    public CNFConfig config() {
        if (this.config != null) {
            return this.config;
        }
        Configuration cnfConfig = this.f.configurationFor(ConfigurationType.CNF);
        return cnfConfig != null ? (CNFConfig)cnfConfig : this.defaultConfig;
    }

    public String toString() {
        return this.config().toString();
    }

    protected static class AdvancedFactorizationHandler
    extends ComputationHandler
    implements FactorizationHandler {
        protected int distributionBoundary;
        protected int createdClauseBoundary;
        protected int currentDistributions;
        protected int currentClauses;

        protected AdvancedFactorizationHandler() {
        }

        protected void setBounds(int distributionBoundary, int createdClauseBoundary) {
            this.distributionBoundary = distributionBoundary;
            this.createdClauseBoundary = createdClauseBoundary;
        }

        @Override
        public void started() {
            super.started();
            this.currentDistributions = 0;
            this.currentClauses = 0;
        }

        @Override
        public boolean performedDistribution() {
            this.aborted = this.distributionBoundary != -1 && ++this.currentDistributions > this.distributionBoundary;
            return !this.aborted;
        }

        @Override
        public boolean createdClause(Formula clause) {
            this.aborted = this.createdClauseBoundary != -1 && ++this.currentClauses > this.createdClauseBoundary;
            return !this.aborted;
        }
    }
}

