/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.transformations.cnf;

import org.logicng.configurations.Configuration;
import org.logicng.configurations.ConfigurationType;

public final class CNFConfig
extends Configuration {
    final Algorithm algorithm;
    final Algorithm fallbackAlgorithmForAdvancedEncoding;
    final int distributionBoundary;
    final int createdClauseBoundary;
    final int atomBoundary;

    private CNFConfig(Builder builder) {
        super(ConfigurationType.CNF);
        this.algorithm = builder.algorithm;
        this.fallbackAlgorithmForAdvancedEncoding = builder.fallbackAlgorithmForAdvancedEncoding;
        this.distributionBoundary = builder.distributionBoundary;
        this.createdClauseBoundary = builder.createdClauseBoundary;
        this.atomBoundary = builder.atomBoundary;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(String.format("CNFConfig{%n", new Object[0]));
        sb.append("algorithm=").append((Object)this.algorithm).append(System.lineSeparator());
        sb.append("fallbackAlgorithmForAdvancedEncoding=").append((Object)this.fallbackAlgorithmForAdvancedEncoding).append(System.lineSeparator());
        sb.append("distributedBoundary=").append(this.distributionBoundary).append(System.lineSeparator());
        sb.append("createdClauseBoundary=").append(this.createdClauseBoundary).append(System.lineSeparator());
        sb.append("atomBoundary=").append(this.atomBoundary).append(System.lineSeparator());
        sb.append("}").append(System.lineSeparator());
        return sb.toString();
    }

    public static class Builder {
        private Algorithm algorithm = Algorithm.ADVANCED;
        private Algorithm fallbackAlgorithmForAdvancedEncoding = Algorithm.TSEITIN;
        private int distributionBoundary = -1;
        private int createdClauseBoundary = 1000;
        private int atomBoundary = 12;

        private Builder() {
        }

        public Builder algorithm(Algorithm algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder fallbackAlgorithmForAdvancedEncoding(Algorithm fallbackAlgorithmForAdvancedEncoding) {
            if (fallbackAlgorithmForAdvancedEncoding != Algorithm.TSEITIN && fallbackAlgorithmForAdvancedEncoding != Algorithm.PLAISTED_GREENBAUM) {
                throw new IllegalArgumentException("Fallback algorithm for advanced CNF encoding must be one of Tseitin or Plaisted & Greenbaum");
            }
            this.fallbackAlgorithmForAdvancedEncoding = fallbackAlgorithmForAdvancedEncoding;
            return this;
        }

        public Builder distributionBoundary(int distributionBoundary) {
            this.distributionBoundary = distributionBoundary;
            return this;
        }

        public Builder createdClauseBoundary(int createdClauseBoundary) {
            this.createdClauseBoundary = createdClauseBoundary;
            return this;
        }

        public Builder atomBoundary(int atomBoundary) {
            this.atomBoundary = atomBoundary;
            return this;
        }

        public CNFConfig build() {
            return new CNFConfig(this);
        }
    }

    public static enum Algorithm {
        FACTORIZATION,
        TSEITIN,
        PLAISTED_GREENBAUM,
        ADVANCED,
        BDD;

    }
}

