/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.transformations.cnf;

import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.FormulaTransformation;
import org.logicng.formulas.cache.TransformationCacheEntry;
import org.logicng.knowledgecompilation.bdds.BDDFactory;
import org.logicng.knowledgecompilation.bdds.jbuddy.BDDKernel;
import org.logicng.predicates.CNFPredicate;
import org.logicng.transformations.UnitPropagation;

public final class BDDCNFTransformation
implements FormulaTransformation {
    private final UnitPropagation up = new UnitPropagation();
    private final BDDKernel kernel;

    public BDDCNFTransformation(BDDKernel kernel) {
        this.kernel = kernel;
    }

    public BDDCNFTransformation(FormulaFactory f, int numVars) {
        this.kernel = new BDDKernel(f, numVars, Math.max(numVars * 30, 20000), Math.max(numVars * 20, 20000));
    }

    public BDDCNFTransformation() {
        this(null);
    }

    @Override
    public Formula apply(Formula formula, boolean cache) {
        if (formula.type().precedence() >= FType.LITERAL.precedence()) {
            return formula;
        }
        if (formula.holds(CNFPredicate.get())) {
            return formula;
        }
        Formula cached = formula.transformationCacheEntry(TransformationCacheEntry.BDD_CNF);
        if (cache && cached != null) {
            return cached;
        }
        Formula cnf = BDDFactory.build(formula, this.kernel, null).cnf().transform(this.up);
        if (cache) {
            formula.setTransformationCacheEntry(TransformationCacheEntry.BDD_CNF, cnf);
        }
        return cnf;
    }
}

