/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.transformations;

import java.util.ArrayList;
import org.logicng.collections.LNGIntVector;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.FormulaTransformation;
import org.logicng.formulas.Literal;
import org.logicng.formulas.cache.TransformationCacheEntry;
import org.logicng.solvers.datastructures.MSClause;
import org.logicng.solvers.sat.MiniSat2Solver;
import org.logicng.solvers.sat.MiniSatConfig;

public final class UnitPropagation
implements FormulaTransformation {
    @Override
    public Formula apply(Formula formula, boolean cache) {
        Formula cached = formula.transformationCacheEntry(TransformationCacheEntry.UNIT_PROPAGATION);
        if (cached != null) {
            return cached;
        }
        MiniSatPropagator miniSatPropagator = new MiniSatPropagator();
        miniSatPropagator.add(formula);
        Formula result = miniSatPropagator.propagatedFormula(formula.factory());
        if (cache) {
            formula.setTransformationCacheEntry(TransformationCacheEntry.UNIT_PROPAGATION, result);
        }
        return result;
    }

    private static class MiniSatPropagator
    extends MiniSat2Solver {
        public MiniSatPropagator() {
            super(MiniSatConfig.builder().incremental(false).build());
        }

        public void add(Formula formula) {
            Formula cnf = formula.cnf();
            switch (cnf.type()) {
                case TRUE: {
                    break;
                }
                case FALSE: 
                case LITERAL: 
                case OR: {
                    this.addClause(this.generateClauseVector(cnf), null);
                    break;
                }
                case AND: {
                    for (Formula op : cnf) {
                        this.addClause(this.generateClauseVector(op), null);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected formula type in CNF: " + (Object)((Object)cnf.type()));
                }
            }
        }

        public Formula propagatedFormula(FormulaFactory f) {
            assert (this.decisionLevel() == 0);
            if (!this.ok || this.propagate() != null) {
                return f.falsum();
            }
            ArrayList<Formula> clauses = new ArrayList<Formula>();
            for (MSClause clause : this.clauses) {
                clauses.add(this.clauseToFormula(clause, f));
            }
            for (int i = 0; i < this.trail.size(); ++i) {
                clauses.add(this.solverLiteralToFormula(this.trail.get(i), f));
            }
            return f.and(clauses);
        }

        private Literal solverLiteralToFormula(int lit, FormulaFactory f) {
            return f.literal(this.nameForIdx(MiniSatPropagator.var(lit)), !MiniSatPropagator.sign(lit));
        }

        private Formula clauseToFormula(MSClause clause, FormulaFactory f) {
            ArrayList<Literal> literals = new ArrayList<Literal>(clause.size());
            block4: for (int i = 0; i < clause.size(); ++i) {
                int lit = clause.get(i);
                switch (this.value(lit)) {
                    case TRUE: {
                        return f.verum();
                    }
                    case UNDEF: {
                        literals.add(this.solverLiteralToFormula(lit, f));
                        continue block4;
                    }
                }
            }
            return f.or(literals);
        }

        private LNGIntVector generateClauseVector(Formula clause) {
            LNGIntVector clauseVec = new LNGIntVector(clause.numberOfOperands());
            for (Literal lit : clause.literals()) {
                int index = this.idxForName(lit.name());
                if (index == -1) {
                    index = this.newVar(false, false);
                    this.addName(lit.name(), index);
                }
                int litNum = lit.phase() ? index * 2 : index * 2 ^ 1;
                clauseVec.push(litNum);
            }
            return clauseVec;
        }
    }
}

