/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.transformations;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import org.logicng.datastructures.ubtrees.UBTree;
import org.logicng.formulas.Formula;
import org.logicng.formulas.Literal;

public abstract class Subsumption {
    protected static UBTree<Literal> generateSubsumedUBTree(Formula formula) {
        TreeMap<Integer, List> mapping = new TreeMap<Integer, List>();
        for (Formula term : formula) {
            mapping.computeIfAbsent(term.literals().size(), k -> new ArrayList()).add(term.literals());
        }
        UBTree<Literal> ubTree = new UBTree<Literal>();
        for (Map.Entry entry : mapping.entrySet()) {
            for (SortedSet set : (List)entry.getValue()) {
                if (ubTree.firstSubset(set) != null) continue;
                ubTree.addSet(set);
            }
        }
        return ubTree;
    }
}

