/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.transformations;

import java.util.ArrayList;
import java.util.List;
import org.logicng.cardinalityconstraints.CCAMOPure;
import org.logicng.datastructures.EncodingResult;
import org.logicng.formulas.BinaryOperator;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.FormulaTransformation;
import org.logicng.formulas.NAryOperator;
import org.logicng.formulas.Not;
import org.logicng.formulas.PBConstraint;
import org.logicng.formulas.Variable;
import org.logicng.util.FormulaHelper;

public final class PureExpansionTransformation
implements FormulaTransformation {
    private final CCAMOPure amoEncoder = new CCAMOPure();

    @Override
    public Formula apply(Formula formula, boolean cache) {
        FormulaFactory f = formula.factory();
        switch (formula.type()) {
            case FALSE: 
            case TRUE: 
            case LITERAL: {
                return formula;
            }
            case NOT: {
                Not not = (Not)formula;
                return f.not(this.apply(not.operand(), cache));
            }
            case OR: 
            case AND: {
                NAryOperator nary = (NAryOperator)formula;
                ArrayList<Formula> newOps = new ArrayList<Formula>(nary.numberOfOperands());
                for (Formula op : nary) {
                    newOps.add(this.apply(op, cache));
                }
                return f.naryOperator(formula.type(), newOps);
            }
            case IMPL: 
            case EQUIV: {
                BinaryOperator binary = (BinaryOperator)formula;
                Formula newLeft = this.apply(binary.left(), cache);
                Formula newRight = this.apply(binary.right(), cache);
                return f.binaryOperator(formula.type(), newLeft, newRight);
            }
            case PBC: {
                PBConstraint pbc = (PBConstraint)formula;
                if (pbc.isAmo() || pbc.isExo()) {
                    EncodingResult encodingResult = EncodingResult.resultForFormula(f);
                    Formula[] vars = FormulaHelper.literalsAsVariables(pbc.operands());
                    this.amoEncoder.build(encodingResult, (Variable[])vars);
                    List<Formula> encoding = encodingResult.result();
                    if (pbc.isExo()) {
                        encoding.add(f.or(vars));
                    }
                    return f.and(encoding);
                }
                throw new UnsupportedOperationException("Pure encoding for a PBC of type other than AMO or EXO is currently not supported.");
            }
        }
        throw new IllegalStateException("Unknown formula type: " + (Object)((Object)formula.type()));
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

