/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.transformations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.logicng.formulas.BinaryOperator;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.FormulaTransformation;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Not;
import org.logicng.formulas.PBConstraint;

public final class LiteralSubstitution
implements FormulaTransformation {
    private final Map<Literal, Literal> substitution;

    public LiteralSubstitution(Map<Literal, Literal> substitution) {
        this.substitution = substitution;
    }

    public LiteralSubstitution() {
        this.substitution = new HashMap<Literal, Literal>();
    }

    public void addSubstitution(Literal from, Literal to) {
        this.substitution.put(from, to);
    }

    @Override
    public Formula apply(Formula formula, boolean cache) {
        FormulaFactory f = formula.factory();
        switch (formula.type()) {
            case TRUE: 
            case FALSE: {
                return formula;
            }
            case LITERAL: {
                Literal literal = (Literal)formula;
                Literal lit = this.substitution.get(literal);
                if (lit != null) {
                    return lit;
                }
                if (!literal.phase()) {
                    lit = this.substitution.get(literal.variable());
                    return lit != null ? lit.negate() : formula;
                }
                return formula;
            }
            case NOT: {
                return f.not(this.apply(((Not)formula).operand(), cache));
            }
            case EQUIV: 
            case IMPL: {
                BinaryOperator binOp = (BinaryOperator)formula;
                return f.binaryOperator(formula.type(), this.apply(binOp.left(), cache), this.apply(binOp.right(), cache));
            }
            case OR: 
            case AND: {
                ArrayList<Formula> operands = new ArrayList<Formula>();
                for (Formula op : formula) {
                    operands.add(this.apply(op, cache));
                }
                return f.naryOperator(formula.type(), operands);
            }
            case PBC: {
                PBConstraint pbc = (PBConstraint)formula;
                Literal[] originalOperands = pbc.operands();
                Literal[] literals = new Literal[originalOperands.length];
                for (int i = 0; i < literals.length; ++i) {
                    literals[i] = (Literal)this.apply(originalOperands[i], false);
                }
                return f.pbc(pbc.comparator(), pbc.rhs(), literals, pbc.coefficients());
            }
        }
        throw new IllegalArgumentException("Unknown formula type: " + (Object)((Object)formula.type()));
    }
}

