/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.transformations;

import java.util.LinkedHashSet;
import org.logicng.formulas.And;
import org.logicng.formulas.Equivalence;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.FormulaTransformation;
import org.logicng.formulas.Implication;
import org.logicng.formulas.Literal;
import org.logicng.formulas.NAryOperator;
import org.logicng.formulas.Not;
import org.logicng.formulas.Or;
import org.logicng.formulas.PBConstraint;

public final class FormulaFactoryImporter
implements FormulaTransformation {
    private final FormulaFactory newFormulaFactory;

    public FormulaFactoryImporter(FormulaFactory newFormulaFactory) {
        this.newFormulaFactory = newFormulaFactory;
    }

    @Override
    public Formula apply(Formula formula, boolean cache) {
        if (formula.factory() == this.newFormulaFactory) {
            return formula;
        }
        switch (formula.type()) {
            case TRUE: {
                return this.newFormulaFactory.verum();
            }
            case FALSE: {
                return this.newFormulaFactory.falsum();
            }
            case LITERAL: {
                Literal literal = (Literal)formula;
                return this.newFormulaFactory.literal(literal.name(), literal.phase());
            }
            case NOT: {
                Not not = (Not)formula;
                return this.newFormulaFactory.not(this.apply(not.operand(), cache));
            }
            case IMPL: {
                Implication implication = (Implication)formula;
                return this.newFormulaFactory.implication(this.apply(implication.left(), cache), this.apply(implication.right(), cache));
            }
            case EQUIV: {
                Equivalence equivalence = (Equivalence)formula;
                return this.newFormulaFactory.equivalence(this.apply(equivalence.left(), cache), this.apply(equivalence.right(), cache));
            }
            case OR: {
                Or or = (Or)formula;
                return this.newFormulaFactory.or(this.gatherAppliedOperands(or));
            }
            case AND: {
                And and = (And)formula;
                return this.newFormulaFactory.and(this.gatherAppliedOperands(and));
            }
            case PBC: {
                PBConstraint pbc = (PBConstraint)formula;
                Literal[] literals = new Literal[pbc.operands().length];
                for (int i = 0; i < pbc.operands().length; ++i) {
                    literals[i] = (Literal)this.apply(pbc.operands()[i], cache);
                }
                return this.newFormulaFactory.pbc(pbc.comparator(), pbc.rhs(), literals, pbc.coefficients());
            }
        }
        throw new IllegalArgumentException("Unknown LogicNG formula type: " + (Object)((Object)formula.type()));
    }

    private LinkedHashSet<Formula> gatherAppliedOperands(NAryOperator operator) {
        LinkedHashSet<Formula> applied = new LinkedHashSet<Formula>();
        for (Formula operand : operator) {
            applied.add(this.apply(operand, false));
        }
        return applied;
    }
}

