/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.transformations;

import org.logicng.datastructures.Substitution;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaTransformation;
import org.logicng.formulas.Variable;
import org.logicng.formulas.cache.TransformationCacheEntry;

public final class Anonymizer
implements FormulaTransformation {
    private final Substitution substitution;
    private final String prefix;
    private int counter;

    public Anonymizer(String prefix, int startCounter) {
        this.prefix = prefix;
        this.substitution = new Substitution();
        this.counter = startCounter;
    }

    public Anonymizer(String prefix) {
        this(prefix, 0);
    }

    public Anonymizer() {
        this("v");
    }

    @Override
    public Formula apply(Formula formula, boolean cache) {
        if (formula.variables().isEmpty()) {
            return formula;
        }
        Formula cached = formula.transformationCacheEntry(TransformationCacheEntry.ANONYMIZATION);
        if (cache && cached != null) {
            return cached;
        }
        for (Variable variable : formula.variables()) {
            if (this.substitution.getSubstitution(variable) != null) continue;
            this.substitution.addMapping(variable, formula.factory().variable(this.prefix + this.counter++));
        }
        Formula transformed = formula.substitute(this.substitution);
        if (cache) {
            formula.setTransformationCacheEntry(TransformationCacheEntry.ANONYMIZATION, transformed);
        }
        return transformed;
    }
}

