/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.transformations;

import java.util.LinkedHashSet;
import org.logicng.formulas.And;
import org.logicng.formulas.Equivalence;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.FormulaTransformation;
import org.logicng.formulas.Implication;
import org.logicng.formulas.Not;
import org.logicng.formulas.Or;
import org.logicng.formulas.cache.CacheEntry;
import org.logicng.formulas.cache.PredicateCacheEntry;
import org.logicng.formulas.cache.TransformationCacheEntry;

public final class AIGTransformation
implements FormulaTransformation {
    private FormulaFactory f;
    private boolean cache;

    @Override
    public Formula apply(Formula formula, boolean cache) {
        this.f = formula.factory();
        this.cache = cache;
        switch (formula.type()) {
            case FALSE: 
            case TRUE: 
            case LITERAL: {
                return formula;
            }
            case NOT: {
                return this.transformNot((Not)formula);
            }
            case IMPL: {
                return this.transformImplication((Implication)formula);
            }
            case EQUIV: {
                return this.transformEquivalence((Equivalence)formula);
            }
            case AND: {
                return this.transformAnd((And)formula);
            }
            case OR: {
                return this.transformOr((Or)formula);
            }
            case PBC: {
                return this.apply(formula.cnf(), cache);
            }
        }
        throw new IllegalArgumentException("Could not process the formula type " + (Object)((Object)formula.type()));
    }

    private Formula transformNot(Not not) {
        Formula aig = not.transformationCacheEntry(TransformationCacheEntry.AIG);
        if (aig == null) {
            aig = this.f.not(this.apply(not.operand(), this.cache));
            if (this.cache) {
                not.setTransformationCacheEntry(TransformationCacheEntry.AIG, aig);
                aig.setPredicateCacheEntry((CacheEntry)PredicateCacheEntry.IS_AIG, true);
            }
        }
        return aig;
    }

    private Formula transformImplication(Implication impl) {
        Formula aig = impl.transformationCacheEntry(TransformationCacheEntry.AIG);
        if (aig == null) {
            aig = this.f.not(this.f.and(this.apply(impl.left(), this.cache), this.f.not(this.apply(impl.right(), this.cache))));
            if (this.cache) {
                impl.setTransformationCacheEntry(TransformationCacheEntry.AIG, aig);
                aig.setPredicateCacheEntry((CacheEntry)PredicateCacheEntry.IS_AIG, true);
            }
        }
        return aig;
    }

    private Formula transformEquivalence(Equivalence equiv) {
        Formula aig = equiv.transformationCacheEntry(TransformationCacheEntry.AIG);
        if (aig == null) {
            aig = this.f.and(this.f.not(this.f.and(this.apply(equiv.left(), this.cache), this.f.not(this.apply(equiv.right(), this.cache)))), this.f.not(this.f.and(this.f.not(equiv.left()), equiv.right())));
            if (this.cache) {
                equiv.setTransformationCacheEntry(TransformationCacheEntry.AIG, aig);
                aig.setPredicateCacheEntry((CacheEntry)PredicateCacheEntry.IS_AIG, true);
            }
        }
        return aig;
    }

    private Formula transformAnd(And and) {
        Formula aig = and.transformationCacheEntry(TransformationCacheEntry.AIG);
        if (aig == null) {
            LinkedHashSet<Formula> nops = new LinkedHashSet<Formula>(and.numberOfOperands());
            for (Formula op : and) {
                nops.add(this.apply(op, this.cache));
            }
            aig = this.f.and(nops);
            if (this.cache) {
                and.setTransformationCacheEntry(TransformationCacheEntry.AIG, aig);
                aig.setPredicateCacheEntry((CacheEntry)PredicateCacheEntry.IS_AIG, true);
            }
        }
        return aig;
    }

    private Formula transformOr(Or or) {
        Formula aig = or.transformationCacheEntry(TransformationCacheEntry.AIG);
        if (aig == null) {
            LinkedHashSet<Formula> nops = new LinkedHashSet<Formula>(or.numberOfOperands());
            for (Formula op : or) {
                nops.add(this.f.not(this.apply(op, this.cache)));
            }
            aig = this.f.not(this.f.and(nops));
            if (this.cache) {
                or.setTransformationCacheEntry(TransformationCacheEntry.AIG, aig);
                aig.setPredicateCacheEntry((CacheEntry)PredicateCacheEntry.IS_AIG, true);
            }
        }
        return aig;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

