/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.solvers.sat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import org.logicng.backbones.Backbone;
import org.logicng.backbones.BackboneType;
import org.logicng.collections.LNGBooleanVector;
import org.logicng.collections.LNGIntVector;
import org.logicng.collections.LNGVector;
import org.logicng.datastructures.Tristate;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;
import org.logicng.handlers.SATHandler;
import org.logicng.propositions.Proposition;
import org.logicng.solvers.datastructures.LNGHeap;
import org.logicng.solvers.datastructures.MSClause;
import org.logicng.solvers.datastructures.MSVariable;
import org.logicng.solvers.datastructures.MSWatcher;
import org.logicng.solvers.sat.MiniSatConfig;

public abstract class MiniSatStyleSolver {
    public static final int LIT_UNDEF = -1;
    protected final MiniSatConfig config;
    protected boolean ok;
    protected int qhead;
    protected LNGVector<MSClause> clauses;
    protected LNGVector<MSClause> learnts;
    protected LNGVector<LNGVector<MSWatcher>> watches;
    protected LNGVector<MSVariable> vars;
    protected LNGHeap orderHeap;
    protected LNGIntVector trail;
    protected LNGIntVector trailLim;
    protected LNGBooleanVector model;
    protected LNGIntVector conflict;
    protected LNGIntVector assumptions;
    protected LNGBooleanVector seen;
    protected LNGIntVector analyzeStack;
    protected LNGIntVector analyzeToClear;
    protected int analyzeBtLevel;
    protected double claInc;
    protected int simpDBAssigns;
    protected int simpDBProps;
    protected int clausesLiterals;
    protected int learntsLiterals;
    protected double varDecay;
    protected double varInc;
    protected MiniSatConfig.ClauseMinimization ccminMode;
    protected int restartFirst;
    protected double restartInc;
    protected double clauseDecay;
    protected boolean shouldRemoveSatsisfied;
    protected double learntsizeFactor;
    protected double learntsizeInc;
    protected boolean incremental;
    protected Map<String, Integer> name2idx;
    protected Map<Integer, String> idx2name;
    protected SATHandler handler;
    protected boolean canceledByHandler;
    protected LNGVector<ProofInformation> pgOriginalClauses;
    protected LNGVector<LNGIntVector> pgProof;
    protected Stack<Integer> backboneCandidates;
    protected LNGIntVector backboneAssumptions;
    protected HashMap<Integer, Tristate> backboneMap;
    protected boolean computingBackbone;
    protected LNGIntVector selectionOrder;
    protected int selectionOrderIdx;
    protected double learntsizeAdjustConfl;
    protected int learntsizeAdjustCnt;
    protected int learntsizeAdjustStartConfl;
    protected double learntsizeAdjustInc;
    protected double maxLearnts;

    protected MiniSatStyleSolver(MiniSatConfig config) {
        this.config = config;
        this.initialize();
    }

    public Map<String, Integer> getName2idx() {
        return this.name2idx;
    }

    public static int mkLit(int var, boolean sign) {
        return var + var + (sign ? 1 : 0);
    }

    public static int not(int lit) {
        return lit ^ 1;
    }

    public static boolean sign(int lit) {
        return (lit & 1) == 1;
    }

    public static int var(int lit) {
        return lit >> 1;
    }

    protected static double luby(double y, int x) {
        int intX = x;
        int size = 1;
        int seq = 0;
        while (size < intX + 1) {
            ++seq;
            size = 2 * size + 1;
        }
        while (size - 1 != intX) {
            size = size - 1 >> 1;
            --seq;
            intX %= size;
        }
        return Math.pow(y, seq);
    }

    protected void initialize() {
        this.initializeConfig();
        this.ok = true;
        this.qhead = 0;
        this.clauses = new LNGVector();
        this.learnts = new LNGVector();
        this.watches = new LNGVector();
        this.vars = new LNGVector();
        this.orderHeap = new LNGHeap(this);
        this.trail = new LNGIntVector();
        this.trailLim = new LNGIntVector();
        this.model = new LNGBooleanVector();
        this.conflict = new LNGIntVector();
        this.assumptions = new LNGIntVector();
        this.seen = new LNGBooleanVector();
        this.analyzeStack = new LNGIntVector();
        this.analyzeToClear = new LNGIntVector();
        this.analyzeBtLevel = 0;
        this.claInc = 1.0;
        this.simpDBAssigns = -1;
        this.simpDBProps = 0;
        this.clausesLiterals = 0;
        this.learntsLiterals = 0;
        this.name2idx = new TreeMap<String, Integer>();
        this.idx2name = new TreeMap<Integer, String>();
        this.canceledByHandler = false;
        if (this.config.proofGeneration) {
            this.pgOriginalClauses = new LNGVector();
            this.pgProof = new LNGVector();
        }
        this.computingBackbone = false;
        this.selectionOrder = new LNGIntVector();
        this.selectionOrderIdx = 0;
    }

    protected void initializeConfig() {
        this.varDecay = this.config.varDecay;
        this.varInc = this.config.varInc;
        this.ccminMode = this.config.clauseMin;
        this.restartFirst = this.config.restartFirst;
        this.restartInc = this.config.restartInc;
        this.clauseDecay = this.config.clauseDecay;
        this.shouldRemoveSatsisfied = this.config.removeSatisfied;
        this.learntsizeFactor = this.config.learntsizeFactor;
        this.learntsizeInc = this.config.learntsizeInc;
        this.incremental = this.config.incremental;
    }

    protected MSVariable v(int lit) {
        return this.vars.get(lit >> 1);
    }

    protected Tristate value(int lit) {
        return MiniSatStyleSolver.sign(lit) ? Tristate.negate(this.v(lit).assignment()) : this.v(lit).assignment();
    }

    public boolean lt(int x, int y) {
        return this.vars.get(x).activity() > this.vars.get(y).activity();
    }

    public int idxForName(String name) {
        Integer id = this.name2idx.get(name);
        return id == null ? -1 : id;
    }

    public String nameForIdx(int var) {
        return this.idx2name.get(var);
    }

    public void addName(String name, int id) {
        this.name2idx.put(name, id);
        this.idx2name.put(id, name);
    }

    public abstract int newVar(boolean var1, boolean var2);

    public boolean addClause(int lit, Proposition proposition) {
        LNGIntVector unit = new LNGIntVector(1);
        unit.push(lit);
        return this.addClause(unit, proposition);
    }

    public abstract boolean addClause(LNGIntVector var1, Proposition var2);

    public abstract Tristate solve(SATHandler var1);

    public Tristate solve(SATHandler handler, LNGIntVector assumptions) {
        this.assumptions = new LNGIntVector(assumptions);
        Tristate result = this.solve(handler);
        this.assumptions.clear();
        return result;
    }

    public abstract void reset();

    public LNGBooleanVector model() {
        return this.model;
    }

    public boolean ok() {
        return this.ok;
    }

    public LNGIntVector conflict() {
        return this.conflict;
    }

    public abstract int[] saveState();

    public abstract void loadState(int[] var1);

    public int nVars() {
        return this.vars.size();
    }

    public Map<String, Integer> name2idx() {
        return this.name2idx;
    }

    protected int nAssigns() {
        return this.trail.size();
    }

    protected int decisionLevel() {
        return this.trailLim.size();
    }

    protected int abstractLevel(int x) {
        return 1 << (this.vars.get(x).level() & 0x1F);
    }

    protected void insertVarOrder(int x) {
        if (!this.orderHeap.inHeap(x) && this.vars.get(x).decision()) {
            this.orderHeap.insert(x);
        }
    }

    protected int pickBranchLit() {
        if (this.selectionOrder.size() > 0 && this.selectionOrderIdx < this.selectionOrder.size()) {
            while (this.selectionOrderIdx < this.selectionOrder.size()) {
                int lit;
                int var;
                MSVariable msVariable;
                if ((msVariable = this.vars.get(var = MiniSatStyleSolver.var(lit = this.selectionOrder.get(this.selectionOrderIdx++)))).assignment() != Tristate.UNDEF) continue;
                return lit;
            }
        }
        int next = -1;
        while (next == -1 || this.vars.get(next).assignment() != Tristate.UNDEF || !this.vars.get(next).decision()) {
            if (this.orderHeap.empty()) {
                return -1;
            }
            next = this.orderHeap.removeMin();
        }
        return MiniSatStyleSolver.mkLit(next, this.vars.get(next).polarity());
    }

    protected void varDecayActivity() {
        this.varInc *= 1.0 / this.varDecay;
    }

    protected void varBumpActivity(int v) {
        this.varBumpActivity(v, this.varInc);
    }

    protected void varBumpActivity(int v, double inc) {
        MSVariable var = this.vars.get(v);
        var.incrementActivity(inc);
        if (var.activity() > 1.0E100) {
            for (MSVariable variable : this.vars) {
                variable.rescaleActivity();
            }
            this.varInc *= 1.0E-100;
        }
        if (this.orderHeap.inHeap(v)) {
            this.orderHeap.decrease(v);
        }
    }

    protected void rebuildOrderHeap() {
        LNGIntVector vs = new LNGIntVector();
        for (int v = 0; v < this.nVars(); ++v) {
            if (!this.vars.get(v).decision() || this.vars.get(v).assignment() != Tristate.UNDEF) continue;
            vs.push(v);
        }
        this.orderHeap.build(vs);
    }

    protected boolean locked(MSClause c) {
        return this.value(c.get(0)) == Tristate.TRUE && this.v(c.get(0)).reason() != null && this.v(c.get(0)).reason() == c;
    }

    protected void claDecayActivity() {
        this.claInc *= 1.0 / this.clauseDecay;
    }

    protected void claBumpActivity(MSClause c) {
        c.incrementActivity(this.claInc);
        if (c.activity() > 1.0E20) {
            for (MSClause clause : this.learnts) {
                clause.rescaleActivity();
            }
            this.claInc *= 1.0E-20;
        }
    }

    protected abstract void uncheckedEnqueue(int var1, MSClause var2);

    protected abstract void attachClause(MSClause var1);

    protected abstract void detachClause(MSClause var1);

    protected abstract void removeClause(MSClause var1);

    protected abstract MSClause propagate();

    protected abstract boolean litRedundant(int var1, int var2);

    protected abstract void analyzeFinal(int var1, LNGIntVector var2);

    protected void cancelUntil(int level) {
        if (this.decisionLevel() > level) {
            if (!this.computingBackbone) {
                for (int c = this.trail.size() - 1; c >= this.trailLim.get(level); --c) {
                    int x = MiniSatStyleSolver.var(this.trail.get(c));
                    MSVariable v = this.vars.get(x);
                    v.assign(Tristate.UNDEF);
                    v.setPolarity(MiniSatStyleSolver.sign(this.trail.get(c)));
                    this.insertVarOrder(x);
                }
            } else {
                for (int c = this.trail.size() - 1; c >= this.trailLim.get(level); --c) {
                    int x = MiniSatStyleSolver.var(this.trail.get(c));
                    MSVariable v = this.vars.get(x);
                    v.assign(Tristate.UNDEF);
                    v.setPolarity(!this.computingBackbone && MiniSatStyleSolver.sign(this.trail.get(c)));
                    this.insertVarOrder(x);
                }
            }
            this.qhead = this.trailLim.get(level);
            this.trail.removeElements(this.trail.size() - this.trailLim.get(level));
            this.trailLim.removeElements(this.trailLim.size() - level);
        }
    }

    protected abstract void reduceDB();

    protected abstract void removeSatisfied(LNGVector<MSClause> var1);

    protected abstract boolean satisfied(MSClause var1);

    protected abstract boolean simplify();

    protected void decayActivities() {
        this.varDecayActivity();
        if (!this.incremental) {
            this.claDecayActivity();
        }
        if (--this.learntsizeAdjustCnt == 0) {
            this.learntsizeAdjustConfl *= this.learntsizeAdjustInc;
            this.learntsizeAdjustCnt = (int)this.learntsizeAdjustConfl;
            this.maxLearnts *= this.learntsizeInc;
        }
    }

    public LNGVector<ProofInformation> pgOriginalClauses() {
        return this.pgOriginalClauses;
    }

    public LNGVector<LNGIntVector> pgProof() {
        return this.pgProof;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ok            ").append(this.ok).append(System.lineSeparator());
        sb.append("qhead         ").append(this.qhead).append(System.lineSeparator());
        sb.append("#clauses      ").append(this.clauses.size()).append(System.lineSeparator());
        sb.append("#learnts      ").append(this.learnts.size()).append(System.lineSeparator());
        sb.append("#watches      ").append(this.watches.size()).append(System.lineSeparator());
        sb.append("#vars         ").append(this.vars.size()).append(System.lineSeparator());
        sb.append("#orderheap    ").append(this.orderHeap.size()).append(System.lineSeparator());
        sb.append("#trail        ").append(this.trail.size()).append(System.lineSeparator());
        sb.append("#trailLim     ").append(this.trailLim.size()).append(System.lineSeparator());
        sb.append("model         ").append(this.model).append(System.lineSeparator());
        sb.append("conflict      ").append(this.conflict).append(System.lineSeparator());
        sb.append("assumptions   ").append(this.assumptions).append(System.lineSeparator());
        sb.append("#seen         ").append(this.seen.size()).append(System.lineSeparator());
        sb.append("#stack        ").append(this.analyzeStack.size()).append(System.lineSeparator());
        sb.append("#toclear      ").append(this.analyzeToClear.size()).append(System.lineSeparator());
        sb.append("claInc        ").append(this.claInc).append(System.lineSeparator());
        sb.append("simpDBAssigns ").append(this.simpDBAssigns).append(System.lineSeparator());
        sb.append("simpDBProps   ").append(this.simpDBProps).append(System.lineSeparator());
        sb.append("#clause lits  ").append(this.clausesLiterals).append(System.lineSeparator());
        sb.append("#learnts lits ").append(this.learntsLiterals).append(System.lineSeparator());
        return sb.toString();
    }

    public LNGIntVector upZeroLiterals() {
        int lit;
        LNGIntVector upZeroLiterals = new LNGIntVector();
        for (int i = 0; i < this.trail.size() && this.v(lit = this.trail.get(i)).level() <= 0; ++i) {
            upZeroLiterals.push(lit);
        }
        return upZeroLiterals;
    }

    public Backbone computeBackbone(Collection<Variable> variables, BackboneType type) {
        boolean sat;
        boolean bl = sat = this.solve(null) == Tristate.TRUE;
        if (sat) {
            this.computingBackbone = true;
            List<Integer> relevantVarIndices = this.getRelevantVarIndices(variables);
            this.initBackboneDS(relevantVarIndices);
            this.computeBackbone(relevantVarIndices, type);
            Backbone backbone = this.buildBackbone(variables, type);
            this.computingBackbone = false;
            return backbone;
        }
        return Backbone.unsatBackbone();
    }

    protected List<Integer> getRelevantVarIndices(Collection<Variable> variables) {
        ArrayList<Integer> relevantVarIndices = new ArrayList<Integer>(variables.size());
        for (Variable var : variables) {
            Integer idx = this.name2idx.get(var.name());
            if (idx == null) continue;
            relevantVarIndices.add(idx);
        }
        return relevantVarIndices;
    }

    protected void initBackboneDS(List<Integer> variables) {
        this.backboneCandidates = new Stack();
        this.backboneAssumptions = new LNGIntVector(variables.size());
        this.backboneMap = new HashMap();
        for (Integer var : variables) {
            this.backboneMap.put(var, Tristate.UNDEF);
        }
    }

    protected void computeBackbone(List<Integer> variables, BackboneType type) {
        Stack<Integer> candidates = this.createInitialCandidates(variables, type);
        while (candidates.size() > 0) {
            int lit = candidates.pop();
            if (this.solveWithLit(lit)) {
                this.refineUpperBound();
                continue;
            }
            this.addBackboneLiteral(lit);
        }
    }

    protected Stack<Integer> createInitialCandidates(List<Integer> variables, BackboneType type) {
        for (Integer var : variables) {
            if (this.isUPZeroLit(var)) {
                int backboneLit = MiniSatStyleSolver.mkLit(var, !this.model.get(var));
                this.addBackboneLiteral(backboneLit);
                continue;
            }
            boolean modelPhase = this.model.get(var);
            if ((!this.isBothOrNegativeType(type) || modelPhase) && (!this.isBothOrPositiveType(type) || !modelPhase)) continue;
            int lit = MiniSatStyleSolver.mkLit(var, !modelPhase);
            if (this.config.bbInitialUBCheckForRotatableLiterals && this.isRotatable(lit)) continue;
            this.backboneCandidates.add(lit);
        }
        return this.backboneCandidates;
    }

    protected void refineUpperBound() {
        for (Integer lit : new ArrayList<Integer>(this.backboneCandidates)) {
            int var = MiniSatStyleSolver.var(lit);
            if (this.isUPZeroLit(var)) {
                this.backboneCandidates.remove(lit);
                this.addBackboneLiteral(lit);
                continue;
            }
            if (this.config.bbCheckForComplementModelLiterals && this.model.get(var) == MiniSatStyleSolver.sign(lit)) {
                this.backboneCandidates.remove(lit);
                continue;
            }
            if (!this.config.bbCheckForRotatableLiterals || !this.isRotatable(lit)) continue;
            this.backboneCandidates.remove(lit);
        }
    }

    protected boolean solveWithLit(int lit) {
        this.backboneAssumptions.push(MiniSatStyleSolver.not(lit));
        boolean sat = this.solve(null, this.backboneAssumptions) == Tristate.TRUE;
        this.backboneAssumptions.pop();
        return sat;
    }

    protected Backbone buildBackbone(Collection<Variable> variables, BackboneType type) {
        TreeSet<Variable> posBackboneVars = this.isBothOrPositiveType(type) ? new TreeSet<Variable>() : null;
        TreeSet<Variable> negBackboneVars = this.isBothOrNegativeType(type) ? new TreeSet<Variable>() : null;
        TreeSet<Variable> optionalVars = this.isBothType(type) ? new TreeSet<Variable>() : null;
        block5: for (Variable var : variables) {
            Integer idx = this.name2idx.get(var.name());
            if (idx == null) {
                if (!this.isBothType(type)) continue;
                optionalVars.add(var);
                continue;
            }
            switch (this.backboneMap.get(idx)) {
                case TRUE: {
                    if (!this.isBothOrPositiveType(type)) continue block5;
                    posBackboneVars.add(var);
                    continue block5;
                }
                case FALSE: {
                    if (!this.isBothOrNegativeType(type)) continue block5;
                    negBackboneVars.add(var);
                    continue block5;
                }
                case UNDEF: {
                    if (!this.isBothType(type)) continue block5;
                    optionalVars.add(var);
                    continue block5;
                }
            }
            throw new IllegalStateException("Unknown tristate: " + (Object)((Object)this.backboneMap.get(idx)));
        }
        return Backbone.satBackbone(posBackboneVars, negBackboneVars, optionalVars);
    }

    protected boolean isUPZeroLit(int var) {
        return this.vars.get(var).level() == 0;
    }

    protected boolean isUnit(int lit, MSClause clause) {
        for (int i = 0; i < clause.size(); ++i) {
            int clauseLit = clause.get(i);
            if (lit == clauseLit || this.model.get(MiniSatStyleSolver.var(clauseLit)) == MiniSatStyleSolver.sign(clauseLit)) continue;
            return false;
        }
        return true;
    }

    protected boolean isRotatable(int lit) {
        if (this.v(lit).reason() != null) {
            return false;
        }
        for (MSWatcher watcher : this.watches.get(MiniSatStyleSolver.not(lit))) {
            if (!this.isUnit(lit, watcher.clause())) continue;
            return false;
        }
        return true;
    }

    protected void addBackboneLiteral(int lit) {
        this.backboneMap.put(MiniSatStyleSolver.var(lit), MiniSatStyleSolver.sign(lit) ? Tristate.FALSE : Tristate.TRUE);
        this.backboneAssumptions.push(lit);
    }

    protected boolean isBothOrPositiveType(BackboneType type) {
        return type == BackboneType.POSITIVE_AND_NEGATIVE || type == BackboneType.ONLY_POSITIVE;
    }

    protected boolean isBothOrNegativeType(BackboneType type) {
        return type == BackboneType.POSITIVE_AND_NEGATIVE || type == BackboneType.ONLY_NEGATIVE;
    }

    protected boolean isBothType(BackboneType type) {
        return type == BackboneType.POSITIVE_AND_NEGATIVE;
    }

    public LNGVector<MSClause> clauses() {
        return this.clauses;
    }

    public LNGVector<MSVariable> variables() {
        return this.vars;
    }

    public void setSelectionOrder(List<? extends Literal> selectionOrder) {
        this.selectionOrder.clear();
        for (Literal literal : selectionOrder) {
            Integer var = this.name2idx.get(literal.name());
            if (var == null) continue;
            this.selectionOrder.push(MiniSatStyleSolver.mkLit(var, !literal.phase()));
        }
    }

    public void resetSelectionOrder() {
        this.selectionOrder.clear();
    }

    public static class ProofInformation {
        protected final LNGIntVector clause;
        protected final Proposition proposition;

        public ProofInformation(LNGIntVector clause, Proposition proposition) {
            this.clause = clause;
            this.proposition = proposition;
        }

        public LNGIntVector clause() {
            return this.clause;
        }

        public Proposition proposition() {
            return this.proposition;
        }

        public String toString() {
            return "ProofInformation{clause=" + this.clause + ", proposition=" + this.proposition + '}';
        }
    }
}

