/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.solvers.sat;

import org.logicng.configurations.Configuration;
import org.logicng.configurations.ConfigurationType;

public final class MiniSatConfig
extends Configuration {
    final double varDecay;
    final double varInc;
    final ClauseMinimization clauseMin;
    final int restartFirst;
    final double restartInc;
    final double clauseDecay;
    final boolean removeSatisfied;
    final double learntsizeFactor;
    final double learntsizeInc;
    final boolean incremental;
    final boolean initialPhase;
    final boolean proofGeneration;
    final CNFMethod cnfMethod;
    final boolean auxiliaryVariablesInModels;
    final boolean bbInitialUBCheckForRotatableLiterals;
    final boolean bbCheckForComplementModelLiterals;
    final boolean bbCheckForRotatableLiterals;

    private MiniSatConfig(Builder builder) {
        super(ConfigurationType.MINISAT);
        this.varDecay = builder.varDecay;
        this.varInc = builder.varInc;
        this.clauseMin = builder.clauseMin;
        this.restartFirst = builder.restartFirst;
        this.restartInc = builder.restartInc;
        this.clauseDecay = builder.clauseDecay;
        this.removeSatisfied = builder.removeSatisfied;
        this.learntsizeFactor = builder.learntsizeFactor;
        this.learntsizeInc = builder.learntsizeInc;
        this.incremental = builder.incremental;
        this.initialPhase = builder.initialPhase;
        this.proofGeneration = builder.proofGeneration;
        this.cnfMethod = builder.cnfMethod;
        this.auxiliaryVariablesInModels = builder.auxiliaryVariablesInModels;
        this.bbInitialUBCheckForRotatableLiterals = builder.bbInitialUBCheckForRotatableLiterals;
        this.bbCheckForComplementModelLiterals = builder.bbCheckForComplementModelLiterals;
        this.bbCheckForRotatableLiterals = builder.bbCheckForRotatableLiterals;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean incremental() {
        return this.incremental;
    }

    public boolean initialPhase() {
        return this.initialPhase;
    }

    public boolean proofGeneration() {
        return this.proofGeneration;
    }

    public CNFMethod getCnfMethod() {
        return this.cnfMethod;
    }

    public boolean isAuxiliaryVariablesInModels() {
        return this.auxiliaryVariablesInModels;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MiniSatConfig{").append(System.lineSeparator());
        sb.append("varDecay=").append(this.varDecay).append(System.lineSeparator());
        sb.append("varInc=").append(this.varInc).append(System.lineSeparator());
        sb.append("clauseMin=").append((Object)this.clauseMin).append(System.lineSeparator());
        sb.append("restartFirst=").append(this.restartFirst).append(System.lineSeparator());
        sb.append("restartInc=").append(this.restartInc).append(System.lineSeparator());
        sb.append("clauseDecay=").append(this.clauseDecay).append(System.lineSeparator());
        sb.append("removeSatisfied=").append(this.removeSatisfied).append(System.lineSeparator());
        sb.append("learntsizeFactor=").append(this.learntsizeFactor).append(System.lineSeparator());
        sb.append("learntsizeInc=").append(this.learntsizeInc).append(System.lineSeparator());
        sb.append("incremental=").append(this.incremental).append(System.lineSeparator());
        sb.append("initialPhase=").append(this.initialPhase).append(System.lineSeparator());
        sb.append("proofGeneration=").append(this.proofGeneration).append(System.lineSeparator());
        sb.append("cnfMethod=").append((Object)this.cnfMethod).append(System.lineSeparator());
        sb.append("auxiliaryVariablesInModels=").append(this.auxiliaryVariablesInModels).append(System.lineSeparator());
        sb.append("bbInitialUBCheckForRotatableLiterals=").append(this.bbInitialUBCheckForRotatableLiterals).append(System.lineSeparator());
        sb.append("bbCheckForComplementModelLiterals=").append(this.bbCheckForComplementModelLiterals).append(System.lineSeparator());
        sb.append("bbCheckForRotatableLiterals=").append(this.bbCheckForRotatableLiterals).append(System.lineSeparator());
        sb.append("}");
        return sb.toString();
    }

    public static class Builder {
        private double varDecay = 0.95;
        private double varInc = 1.0;
        private ClauseMinimization clauseMin = ClauseMinimization.DEEP;
        private int restartFirst = 100;
        private double restartInc = 2.0;
        private double clauseDecay = 0.999;
        private boolean removeSatisfied = true;
        private double learntsizeFactor = 0.3333333333333333;
        private double learntsizeInc = 1.1;
        private boolean incremental = true;
        private boolean initialPhase = false;
        private boolean proofGeneration = false;
        private CNFMethod cnfMethod = CNFMethod.PG_ON_SOLVER;
        private boolean auxiliaryVariablesInModels = false;
        private boolean bbInitialUBCheckForRotatableLiterals = true;
        private boolean bbCheckForComplementModelLiterals = true;
        private boolean bbCheckForRotatableLiterals = true;

        private Builder() {
        }

        public Builder varDecay(double varDecay) {
            this.varDecay = varDecay;
            return this;
        }

        public Builder varInc(double varInc) {
            this.varInc = varInc;
            return this;
        }

        public Builder clMinimization(ClauseMinimization ccmin) {
            this.clauseMin = ccmin;
            return this;
        }

        public Builder restartFirst(int restartFirst) {
            this.restartFirst = restartFirst;
            return this;
        }

        public Builder restartInc(double restartInc) {
            this.restartInc = restartInc;
            return this;
        }

        public Builder clauseDecay(double clauseDecay) {
            this.clauseDecay = clauseDecay;
            return this;
        }

        public Builder removeSatisfied(boolean removeSatisfied) {
            this.removeSatisfied = removeSatisfied;
            return this;
        }

        public Builder lsFactor(double learntsizeFactor) {
            this.learntsizeFactor = learntsizeFactor;
            return this;
        }

        public Builder lsInc(double learntsizeInc) {
            this.learntsizeInc = learntsizeInc;
            return this;
        }

        public Builder incremental(boolean incremental) {
            this.incremental = incremental;
            return this;
        }

        public Builder initialPhase(boolean initialPhase) {
            this.initialPhase = initialPhase;
            return this;
        }

        public Builder proofGeneration(boolean proofGeneration) {
            this.proofGeneration = proofGeneration;
            return this;
        }

        public Builder cnfMethod(CNFMethod cnfMethod) {
            this.cnfMethod = cnfMethod;
            return this;
        }

        public Builder auxiliaryVariablesInModels(boolean auxiliaryVariablesInModels) {
            this.auxiliaryVariablesInModels = auxiliaryVariablesInModels;
            return this;
        }

        public Builder bbCheckForRotatableLiterals(boolean checkForRotatableLiterals) {
            this.bbCheckForRotatableLiterals = checkForRotatableLiterals;
            return this;
        }

        public Builder bbInitialUBCheckForRotatableLiterals(boolean initialUBCheckForRotatableLiterals) {
            this.bbInitialUBCheckForRotatableLiterals = initialUBCheckForRotatableLiterals;
            return this;
        }

        public Builder bbCheckForComplementModelLiterals(boolean checkForComplementModelLiterals) {
            this.bbCheckForComplementModelLiterals = checkForComplementModelLiterals;
            return this;
        }

        public MiniSatConfig build() {
            return new MiniSatConfig(this);
        }
    }

    public static enum CNFMethod {
        FACTORY_CNF,
        PG_ON_SOLVER,
        FULL_PG_ON_SOLVER;

    }

    public static enum ClauseMinimization {
        NONE,
        BASIC,
        DEEP;

    }
}

