/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.solvers.sat;

import org.logicng.collections.LNGBooleanVector;
import org.logicng.collections.LNGIntVector;
import org.logicng.collections.LNGVector;
import org.logicng.datastructures.Tristate;
import org.logicng.handlers.SATHandler;
import org.logicng.propositions.Proposition;
import org.logicng.solvers.datastructures.MSClause;
import org.logicng.solvers.datastructures.MSVariable;
import org.logicng.solvers.datastructures.MSWatcher;
import org.logicng.solvers.sat.MiniSatConfig;
import org.logicng.solvers.sat.MiniSatStyleSolver;

public class MiniSat2Solver
extends MiniSatStyleSolver {
    protected LNGIntVector unitClauses;

    public MiniSat2Solver() {
        this(MiniSatConfig.builder().build());
    }

    public MiniSat2Solver(MiniSatConfig config) {
        super(config);
        this.initializeMiniSAT();
    }

    protected void initializeMiniSAT() {
        this.unitClauses = new LNGIntVector();
        this.learntsizeAdjustConfl = 0.0;
        this.learntsizeAdjustCnt = 0;
        this.learntsizeAdjustStartConfl = 100;
        this.learntsizeAdjustInc = 1.5;
        this.maxLearnts = 0.0;
    }

    @Override
    public int newVar(boolean sign, boolean dvar) {
        int v = this.vars.size();
        MSVariable newVar = new MSVariable(sign);
        this.vars.push(newVar);
        this.watches.push(new LNGVector());
        this.watches.push(new LNGVector());
        this.seen.push(false);
        newVar.setDecision(dvar);
        this.insertVarOrder(v);
        return v;
    }

    @Override
    public boolean addClause(LNGIntVector ps, Proposition proposition) {
        int p;
        int i;
        assert (this.decisionLevel() == 0);
        if (this.config.proofGeneration) {
            LNGIntVector vec = new LNGIntVector(ps.size());
            for (i = 0; i < ps.size(); ++i) {
                vec.push((MiniSat2Solver.var(ps.get(i)) + 1) * (-2 * (MiniSat2Solver.sign(ps.get(i)) ? 1 : 0) + 1));
            }
            this.pgOriginalClauses.push(new MiniSatStyleSolver.ProofInformation(vec, proposition));
        }
        if (!this.ok) {
            return false;
        }
        ps.sort();
        boolean flag = false;
        LNGIntVector oc = null;
        if (this.config.proofGeneration) {
            oc = new LNGIntVector();
            p = -1;
            for (i = 0; i < ps.size(); ++i) {
                oc.push(ps.get(i));
                if (this.value(ps.get(i)) != Tristate.TRUE && ps.get(i) != MiniSat2Solver.not(p) && this.value(ps.get(i)) != Tristate.FALSE) continue;
                flag = true;
            }
        }
        int j = 0;
        p = -1;
        for (i = 0; i < ps.size(); ++i) {
            if (this.value(ps.get(i)) == Tristate.TRUE || ps.get(i) == MiniSat2Solver.not(p)) {
                return true;
            }
            if (this.value(ps.get(i)) == Tristate.FALSE || ps.get(i) == p) continue;
            p = ps.get(i);
            ps.set(j++, p);
        }
        ps.removeElements(i - j);
        if (flag) {
            LNGIntVector vec = new LNGIntVector(ps.size() + 1);
            vec.push(1);
            for (i = 0; i < ps.size(); ++i) {
                vec.push((MiniSat2Solver.var(ps.get(i)) + 1) * (-2 * (MiniSat2Solver.sign(ps.get(i)) ? 1 : 0) + 1));
            }
            this.pgProof.push(vec);
            vec = new LNGIntVector(oc.size() + 1);
            vec.push(-1);
            for (i = 0; i < oc.size(); ++i) {
                vec.push((MiniSat2Solver.var(oc.get(i)) + 1) * (-2 * (MiniSat2Solver.sign(oc.get(i)) ? 1 : 0) + 1));
            }
            this.pgProof.push(vec);
        }
        if (ps.empty()) {
            this.ok = false;
            return false;
        }
        if (ps.size() == 1) {
            this.uncheckedEnqueue(ps.get(0), null);
            boolean bl = this.ok = this.propagate() == null;
            if (this.incremental) {
                this.unitClauses.push(ps.get(0));
            }
            return this.ok;
        }
        MSClause c = new MSClause(ps, false);
        this.clauses.push(c);
        this.attachClause(c);
        return true;
    }

    @Override
    public Tristate solve(SATHandler handler) {
        this.handler = handler;
        if (this.handler != null) {
            this.handler.started();
        }
        this.model.clear();
        this.conflict.clear();
        if (!this.ok) {
            return Tristate.FALSE;
        }
        this.learntsizeAdjustConfl = this.learntsizeAdjustStartConfl;
        this.learntsizeAdjustCnt = (int)this.learntsizeAdjustConfl;
        this.maxLearnts = (double)this.clauses.size() * this.learntsizeFactor;
        Tristate status = Tristate.UNDEF;
        int currRestarts = 0;
        while (status == Tristate.UNDEF && !this.canceledByHandler) {
            double restBase = MiniSat2Solver.luby(this.restartInc, currRestarts);
            status = this.search((int)(restBase * (double)this.restartFirst));
            ++currRestarts;
        }
        if (this.config.proofGeneration && status == Tristate.FALSE) {
            this.pgProof.push(new LNGIntVector(1, 0));
        }
        if (status == Tristate.TRUE) {
            this.model = new LNGBooleanVector(this.vars.size());
            for (MSVariable v : this.vars) {
                this.model.push(v.assignment() == Tristate.TRUE);
            }
        } else if (status == Tristate.FALSE && this.conflict.empty()) {
            this.ok = false;
        }
        if (this.handler != null) {
            this.handler.finishedSolving();
        }
        this.cancelUntil(0);
        this.handler = null;
        this.canceledByHandler = false;
        return status;
    }

    @Override
    public void reset() {
        super.initialize();
        this.initializeMiniSAT();
    }

    @Override
    public int[] saveState() {
        if (!this.incremental) {
            throw new IllegalStateException("Cannot save a state when the incremental mode is deactivated");
        }
        int[] state = new int[7];
        state[0] = this.ok ? 1 : 0;
        state[1] = this.vars.size();
        state[2] = this.clauses.size();
        state[3] = this.learnts.size();
        state[4] = this.unitClauses.size();
        if (this.config.proofGeneration) {
            state[5] = this.pgOriginalClauses.size();
            state[6] = this.pgProof.size();
        }
        return state;
    }

    @Override
    public void loadState(int[] state) {
        int i;
        if (!this.incremental) {
            throw new IllegalStateException("Cannot load a state when the incremental mode is deactivated");
        }
        this.completeBacktrack();
        this.ok = state[0] == 1;
        int newVarsSize = Math.min(state[1], this.vars.size());
        for (i = this.vars.size() - 1; i >= newVarsSize; --i) {
            this.orderHeap.remove((Integer)this.name2idx.remove(this.idx2name.remove(i)));
        }
        this.vars.shrinkTo(newVarsSize);
        int newClausesSize = Math.min(state[2], this.clauses.size());
        for (i = this.clauses.size() - 1; i >= newClausesSize; --i) {
            this.simpleRemoveClause((MSClause)this.clauses.get(i));
        }
        this.clauses.shrinkTo(newClausesSize);
        int newLearntsSize = Math.min(state[3], this.learnts.size());
        for (i = this.learnts.size() - 1; i >= newLearntsSize; --i) {
            this.simpleRemoveClause((MSClause)this.learnts.get(i));
        }
        this.learnts.shrinkTo(newLearntsSize);
        this.watches.shrinkTo(newVarsSize * 2);
        this.unitClauses.shrinkTo(state[4]);
        for (i = 0; this.ok && i < this.unitClauses.size(); ++i) {
            this.uncheckedEnqueue(this.unitClauses.get(i), null);
            this.ok = this.propagate() == null;
        }
        if (this.config.proofGeneration) {
            int newPgOriginalSize = Math.min(state[5], this.pgOriginalClauses.size());
            this.pgOriginalClauses.shrinkTo(newPgOriginalSize);
            int newPgProofSize = Math.min(state[6], this.pgProof.size());
            this.pgProof.shrinkTo(newPgProofSize);
        }
    }

    @Override
    protected void uncheckedEnqueue(int lit, MSClause reason) {
        assert (this.value(lit) == Tristate.UNDEF);
        MSVariable var = this.v(lit);
        var.assign(Tristate.fromBool(!MiniSat2Solver.sign(lit)));
        var.setReason(reason);
        var.setLevel(this.decisionLevel());
        this.trail.push(lit);
    }

    @Override
    protected void attachClause(MSClause c) {
        assert (c.size() > 1);
        ((LNGVector)this.watches.get(MiniSat2Solver.not(c.get(0)))).push(new MSWatcher(c, c.get(1)));
        ((LNGVector)this.watches.get(MiniSat2Solver.not(c.get(1)))).push(new MSWatcher(c, c.get(0)));
        if (c.learnt()) {
            this.learntsLiterals += c.size();
        } else {
            this.clausesLiterals += c.size();
        }
    }

    @Override
    protected void detachClause(MSClause c) {
        assert (c.size() > 1);
        ((LNGVector)this.watches.get(MiniSat2Solver.not(c.get(0)))).remove(new MSWatcher(c, c.get(1)));
        ((LNGVector)this.watches.get(MiniSat2Solver.not(c.get(1)))).remove(new MSWatcher(c, c.get(0)));
        if (c.learnt()) {
            this.learntsLiterals -= c.size();
        } else {
            this.clausesLiterals -= c.size();
        }
    }

    @Override
    protected void removeClause(MSClause c) {
        if (this.config.proofGeneration) {
            LNGIntVector vec = new LNGIntVector(c.size());
            vec.push(-1);
            for (int i = 0; i < c.size(); ++i) {
                vec.push((MiniSat2Solver.var(c.get(i)) + 1) * (-2 * (MiniSat2Solver.sign(c.get(i)) ? 1 : 0) + 1));
            }
            this.pgProof.push(vec);
        }
        this.detachClause(c);
        if (this.locked(c)) {
            this.v(c.get(0)).setReason(null);
        }
    }

    @Override
    protected MSClause propagate() {
        MSClause confl = null;
        int numProps = 0;
        while (this.qhead < this.trail.size()) {
            int p = this.trail.get(this.qhead++);
            LNGVector ws = (LNGVector)this.watches.get(p);
            int iInd = 0;
            int jInd = 0;
            ++numProps;
            while (iInd < ws.size()) {
                MSWatcher i = (MSWatcher)ws.get(iInd);
                int blocker = i.blocker();
                if (this.value(blocker) == Tristate.TRUE) {
                    ws.set(jInd++, i);
                    ++iInd;
                    continue;
                }
                MSClause c = i.clause();
                int falseLit = MiniSat2Solver.not(p);
                if (c.get(0) == falseLit) {
                    c.set(0, c.get(1));
                    c.set(1, falseLit);
                }
                assert (c.get(1) == falseLit);
                ++iInd;
                int first = c.get(0);
                MSWatcher w = new MSWatcher(c, first);
                if (first != blocker && this.value(first) == Tristate.TRUE) {
                    ws.set(jInd++, w);
                    continue;
                }
                boolean foundWatch = false;
                for (int k = 2; k < c.size() && !foundWatch; ++k) {
                    if (this.value(c.get(k)) == Tristate.FALSE) continue;
                    c.set(1, c.get(k));
                    c.set(k, falseLit);
                    ((LNGVector)this.watches.get(MiniSat2Solver.not(c.get(1)))).push(w);
                    foundWatch = true;
                }
                if (foundWatch) continue;
                ws.set(jInd++, w);
                if (this.value(first) == Tristate.FALSE) {
                    confl = c;
                    this.qhead = this.trail.size();
                    while (iInd < ws.size()) {
                        ws.set(jInd++, ws.get(iInd++));
                    }
                    continue;
                }
                this.uncheckedEnqueue(first, c);
            }
            ws.removeElements(iInd - jInd);
        }
        this.simpDBProps -= numProps;
        return confl;
    }

    @Override
    protected boolean litRedundant(int p, int abstractLevels) {
        this.analyzeStack.clear();
        this.analyzeStack.push(p);
        int top = this.analyzeToClear.size();
        while (this.analyzeStack.size() > 0) {
            assert (this.v(this.analyzeStack.back()).reason() != null);
            MSClause c = this.v(this.analyzeStack.back()).reason();
            this.analyzeStack.pop();
            for (int i = 1; i < c.size(); ++i) {
                int q = c.get(i);
                if (this.seen.get(MiniSat2Solver.var(q)) || this.v(q).level() <= 0) continue;
                if (this.v(q).reason() != null && (this.abstractLevel(MiniSat2Solver.var(q)) & abstractLevels) != 0) {
                    this.seen.set(MiniSat2Solver.var(q), true);
                    this.analyzeStack.push(q);
                    this.analyzeToClear.push(q);
                    continue;
                }
                for (int j = top; j < this.analyzeToClear.size(); ++j) {
                    this.seen.set(MiniSat2Solver.var(this.analyzeToClear.get(j)), false);
                }
                this.analyzeToClear.removeElements(this.analyzeToClear.size() - top);
                return false;
            }
        }
        return true;
    }

    @Override
    protected void analyzeFinal(int p, LNGIntVector outConflict) {
        outConflict.clear();
        outConflict.push(p);
        if (this.decisionLevel() == 0) {
            return;
        }
        this.seen.set(MiniSat2Solver.var(p), true);
        for (int i = this.trail.size() - 1; i >= this.trailLim.get(0); --i) {
            int x = MiniSat2Solver.var(this.trail.get(i));
            if (!this.seen.get(x)) continue;
            MSVariable v = (MSVariable)this.vars.get(x);
            if (v.reason() == null) {
                assert (v.level() > 0);
                outConflict.push(MiniSat2Solver.not(this.trail.get(i)));
            } else {
                MSClause c = v.reason();
                for (int j = 1; j < c.size(); ++j) {
                    if (this.v(c.get(j)).level() <= 0) continue;
                    this.seen.set(MiniSat2Solver.var(c.get(j)), true);
                }
            }
            this.seen.set(x, false);
        }
        this.seen.set(MiniSat2Solver.var(p), false);
    }

    @Override
    protected void reduceDB() {
        int i;
        double extraLim = this.claInc / (double)this.learnts.size();
        this.learnts.manualSort(MSClause.minisatComparator);
        int j = 0;
        for (i = 0; i < this.learnts.size(); ++i) {
            MSClause c = (MSClause)this.learnts.get(i);
            if (c.size() > 2 && !this.locked(c) && (i < this.learnts.size() / 2 || c.activity() < extraLim)) {
                this.removeClause((MSClause)this.learnts.get(i));
                continue;
            }
            this.learnts.set(j++, this.learnts.get(i));
        }
        this.learnts.removeElements(i - j);
    }

    @Override
    protected void removeSatisfied(LNGVector<MSClause> cs) {
        int i;
        int j = 0;
        for (i = 0; i < cs.size(); ++i) {
            MSClause c = cs.get(i);
            if (this.satisfied(c)) {
                this.removeClause(cs.get(i));
                continue;
            }
            assert (this.value(c.get(0)) == Tristate.UNDEF && this.value(c.get(1)) == Tristate.UNDEF);
            if (!this.config.proofGeneration) {
                for (int k = 2; k < c.size(); ++k) {
                    if (this.value(c.get(k)) != Tristate.FALSE) continue;
                    c.set(k--, c.get(c.size() - 1));
                    c.pop();
                }
            }
            cs.set(j++, cs.get(i));
        }
        cs.removeElements(i - j);
    }

    @Override
    protected boolean satisfied(MSClause c) {
        for (int i = 0; i < c.size(); ++i) {
            if (this.value(c.get(i)) != Tristate.TRUE) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean simplify() {
        assert (this.decisionLevel() == 0);
        if (!this.ok || this.propagate() != null) {
            this.ok = false;
            return false;
        }
        if (this.nAssigns() == this.simpDBAssigns || this.simpDBProps > 0) {
            return true;
        }
        this.removeSatisfied(this.learnts);
        if (this.shouldRemoveSatsisfied) {
            this.removeSatisfied(this.clauses);
        }
        this.rebuildOrderHeap();
        this.simpDBAssigns = this.nAssigns();
        this.simpDBProps = this.clausesLiterals + this.learntsLiterals;
        return true;
    }

    protected Tristate search(int nofConflicts) {
        if (!this.ok) {
            return Tristate.FALSE;
        }
        int conflictC = 0;
        this.selectionOrderIdx = 0;
        while (true) {
            MSClause confl;
            if ((confl = this.propagate()) != null) {
                if (this.handler != null && !this.handler.detectedConflict()) {
                    this.canceledByHandler = true;
                    return Tristate.UNDEF;
                }
                ++conflictC;
                if (this.decisionLevel() == 0) {
                    return Tristate.FALSE;
                }
                LNGIntVector learntClause = new LNGIntVector();
                this.analyze(confl, learntClause);
                this.cancelUntil(this.analyzeBtLevel);
                if (this.analyzeBtLevel < this.selectionOrder.size()) {
                    this.selectionOrderIdx = this.analyzeBtLevel;
                }
                if (this.config.proofGeneration) {
                    LNGIntVector vec = new LNGIntVector(learntClause.size());
                    vec.push(1);
                    for (int i = 0; i < learntClause.size(); ++i) {
                        vec.push((MiniSat2Solver.var(learntClause.get(i)) + 1) * (-2 * (MiniSat2Solver.sign(learntClause.get(i)) ? 1 : 0) + 1));
                    }
                    this.pgProof.push(vec);
                }
                if (learntClause.size() == 1) {
                    this.uncheckedEnqueue(learntClause.get(0), null);
                    this.unitClauses.push(learntClause.get(0));
                } else {
                    MSClause cr = new MSClause(learntClause, true);
                    this.learnts.push(cr);
                    this.attachClause(cr);
                    if (!this.incremental) {
                        this.claBumpActivity(cr);
                    }
                    this.uncheckedEnqueue(learntClause.get(0), cr);
                }
                this.decayActivities();
                continue;
            }
            if (nofConflicts >= 0 && conflictC >= nofConflicts) {
                this.cancelUntil(0);
                return Tristate.UNDEF;
            }
            if (!this.incremental) {
                if (this.decisionLevel() == 0 && !this.simplify()) {
                    return Tristate.FALSE;
                }
                if ((double)(this.learnts.size() - this.nAssigns()) >= this.maxLearnts) {
                    this.reduceDB();
                }
            }
            int next = -1;
            while (this.decisionLevel() < this.assumptions.size()) {
                int p = this.assumptions.get(this.decisionLevel());
                if (this.value(p) == Tristate.TRUE) {
                    this.trailLim.push(this.trail.size());
                    continue;
                }
                if (this.value(p) == Tristate.FALSE) {
                    this.analyzeFinal(MiniSat2Solver.not(p), this.conflict);
                    return Tristate.FALSE;
                }
                next = p;
                break;
            }
            if (next == -1 && (next = this.pickBranchLit()) == -1) {
                return Tristate.TRUE;
            }
            this.trailLim.push(this.trail.size());
            this.uncheckedEnqueue(next, null);
        }
    }

    protected void analyze(MSClause conflictClause, LNGIntVector outLearnt) {
        MSClause c = conflictClause;
        int pathC = 0;
        int p = -1;
        outLearnt.push(-1);
        int index = this.trail.size() - 1;
        do {
            int j;
            assert (c != null);
            if (!this.incremental && c.learnt()) {
                this.claBumpActivity(c);
            }
            int n = j = p == -1 ? 0 : 1;
            while (j < c.size()) {
                int q = c.get(j);
                if (!this.seen.get(MiniSat2Solver.var(q)) && this.v(q).level() > 0) {
                    this.varBumpActivity(MiniSat2Solver.var(q));
                    this.seen.set(MiniSat2Solver.var(q), true);
                    if (this.v(q).level() >= this.decisionLevel()) {
                        ++pathC;
                    } else {
                        outLearnt.push(q);
                    }
                }
                ++j;
            }
            while (!this.seen.get(MiniSat2Solver.var(this.trail.get(index--)))) {
            }
            p = this.trail.get(index + 1);
            c = this.v(p).reason();
            this.seen.set(MiniSat2Solver.var(p), false);
        } while (--pathC > 0);
        outLearnt.set(0, MiniSat2Solver.not(p));
        this.simplifyClause(outLearnt);
    }

    protected void simplifyClause(LNGIntVector outLearnt) {
        int k;
        int j;
        int i;
        this.analyzeToClear = new LNGIntVector(outLearnt);
        if (this.ccminMode == MiniSatConfig.ClauseMinimization.DEEP) {
            int abstractLevel = 0;
            for (i = 1; i < outLearnt.size(); ++i) {
                abstractLevel |= this.abstractLevel(MiniSat2Solver.var(outLearnt.get(i)));
            }
            j = 1;
            for (i = 1; i < outLearnt.size(); ++i) {
                if (this.v(outLearnt.get(i)).reason() != null && this.litRedundant(outLearnt.get(i), abstractLevel)) continue;
                outLearnt.set(j++, outLearnt.get(i));
            }
        } else if (this.ccminMode == MiniSatConfig.ClauseMinimization.BASIC) {
            j = 1;
            block2: for (i = 1; i < outLearnt.size(); ++i) {
                if (this.v(outLearnt.get(i)).reason() == null) {
                    outLearnt.set(j++, outLearnt.get(i));
                    continue;
                }
                MSClause c = this.v(outLearnt.get(i)).reason();
                for (k = 1; k < c.size(); ++k) {
                    if (this.seen.get(MiniSat2Solver.var(c.get(k))) || this.v(c.get(k)).level() <= 0) continue;
                    outLearnt.set(j++, outLearnt.get(i));
                    continue block2;
                }
            }
        } else {
            i = j = outLearnt.size();
        }
        outLearnt.removeElements(i - j);
        this.analyzeBtLevel = 0;
        if (outLearnt.size() > 1) {
            int max = 1;
            for (k = 2; k < outLearnt.size(); ++k) {
                if (this.v(outLearnt.get(k)).level() <= this.v(outLearnt.get(max)).level()) continue;
                max = k;
            }
            int p = outLearnt.get(max);
            outLearnt.set(max, outLearnt.get(1));
            outLearnt.set(1, p);
            this.analyzeBtLevel = this.v(p).level();
        }
        for (int l = 0; l < this.analyzeToClear.size(); ++l) {
            this.seen.set(MiniSat2Solver.var(this.analyzeToClear.get(l)), false);
        }
    }

    protected void completeBacktrack() {
        for (int v = 0; v < this.vars.size(); ++v) {
            MSVariable var = (MSVariable)this.vars.get(v);
            var.assign(Tristate.UNDEF);
            var.setReason(null);
            if (this.orderHeap.inHeap(v) || !var.decision()) continue;
            this.orderHeap.insert(v);
        }
        this.trail.clear();
        this.trailLim.clear();
        this.qhead = 0;
    }

    protected void simpleRemoveClause(MSClause c) {
        ((LNGVector)this.watches.get(MiniSat2Solver.not(c.get(0)))).remove(new MSWatcher(c, c.get(1)));
        ((LNGVector)this.watches.get(MiniSat2Solver.not(c.get(1)))).remove(new MSWatcher(c, c.get(0)));
    }
}

