/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.solvers.sat;

import org.logicng.collections.LNGBooleanVector;
import org.logicng.collections.LNGIntVector;
import org.logicng.collections.LNGVector;
import org.logicng.datastructures.Tristate;
import org.logicng.handlers.SATHandler;
import org.logicng.propositions.Proposition;
import org.logicng.solvers.datastructures.MSClause;
import org.logicng.solvers.datastructures.MSVariable;
import org.logicng.solvers.datastructures.MSWatcher;
import org.logicng.solvers.sat.MiniSatConfig;
import org.logicng.solvers.sat.MiniSatStyleSolver;

public class MiniCard
extends MiniSatStyleSolver {
    protected static final int LIT_ERROR = -2;
    protected LNGIntVector unitClauses;

    public MiniCard() {
        this(MiniSatConfig.builder().build());
    }

    public MiniCard(MiniSatConfig config) {
        super(config);
        this.initializeMiniSAT();
    }

    protected void initializeMiniSAT() {
        this.unitClauses = new LNGIntVector();
        this.learntsizeAdjustConfl = 0.0;
        this.learntsizeAdjustCnt = 0;
        this.learntsizeAdjustStartConfl = 100;
        this.learntsizeAdjustInc = 1.5;
        this.maxLearnts = 0.0;
    }

    @Override
    public int newVar(boolean sign, boolean dvar) {
        int v = this.vars.size();
        MSVariable newVar = new MSVariable(sign);
        this.vars.push(newVar);
        this.watches.push(new LNGVector());
        this.watches.push(new LNGVector());
        this.seen.push(false);
        newVar.setDecision(dvar);
        this.insertVarOrder(v);
        return v;
    }

    @Override
    public boolean addClause(LNGIntVector ps, Proposition proposition) {
        int i;
        assert (this.decisionLevel() == 0);
        if (!this.ok) {
            return false;
        }
        ps.sort();
        int j = 0;
        int p = -1;
        for (i = 0; i < ps.size(); ++i) {
            if (this.value(ps.get(i)) == Tristate.TRUE || ps.get(i) == MiniCard.not(p)) {
                return true;
            }
            if (this.value(ps.get(i)) == Tristate.FALSE || ps.get(i) == p) continue;
            p = ps.get(i);
            ps.set(j++, p);
        }
        ps.removeElements(i - j);
        if (ps.empty()) {
            this.ok = false;
            return false;
        }
        if (ps.size() == 1) {
            this.uncheckedEnqueue(ps.get(0), null);
            boolean bl = this.ok = this.propagate() == null;
            if (this.incremental) {
                this.unitClauses.push(ps.get(0));
            }
            return this.ok;
        }
        MSClause c = new MSClause(ps, false);
        this.clauses.push(c);
        this.attachClause(c);
        return true;
    }

    @Override
    public Tristate solve(SATHandler handler) {
        this.handler = handler;
        if (this.handler != null) {
            this.handler.started();
        }
        this.model.clear();
        this.conflict.clear();
        if (!this.ok) {
            return Tristate.FALSE;
        }
        this.learntsizeAdjustConfl = this.learntsizeAdjustStartConfl;
        this.learntsizeAdjustCnt = (int)this.learntsizeAdjustConfl;
        this.maxLearnts = (double)this.clauses.size() * this.learntsizeFactor;
        Tristate status = Tristate.UNDEF;
        int currRestarts = 0;
        while (status == Tristate.UNDEF && !this.canceledByHandler) {
            double restBase = MiniCard.luby(this.restartInc, currRestarts);
            status = this.search((int)(restBase * (double)this.restartFirst));
            ++currRestarts;
        }
        if (status == Tristate.TRUE) {
            this.model = new LNGBooleanVector(this.vars.size());
            for (MSVariable v : this.vars) {
                this.model.push(v.assignment() == Tristate.TRUE);
            }
        } else if (status == Tristate.FALSE && this.conflict.empty()) {
            this.ok = false;
        }
        if (this.handler != null) {
            this.handler.finishedSolving();
        }
        this.cancelUntil(0);
        this.handler = null;
        this.canceledByHandler = false;
        return status;
    }

    @Override
    public void reset() {
        super.initialize();
        this.initializeMiniSAT();
    }

    @Override
    public int[] saveState() {
        if (!this.incremental) {
            throw new IllegalStateException("Cannot save a state when the incremental mode is deactivated");
        }
        int[] state = new int[]{this.ok ? 1 : 0, this.vars.size(), this.clauses.size(), this.learnts.size(), this.unitClauses.size()};
        return state;
    }

    @Override
    public void loadState(int[] state) {
        int i;
        if (!this.incremental) {
            throw new IllegalStateException("Cannot save a state when the incremental mode is deactivated");
        }
        this.completeBacktrack();
        this.ok = state[0] == 1;
        int newVarsSize = Math.min(state[1], this.vars.size());
        for (i = this.vars.size() - 1; i >= newVarsSize; --i) {
            this.orderHeap.remove((Integer)this.name2idx.remove(this.idx2name.remove(i)));
        }
        this.vars.shrinkTo(newVarsSize);
        int newClausesSize = Math.min(state[2], this.clauses.size());
        for (i = this.clauses.size() - 1; i >= newClausesSize; --i) {
            this.simpleRemoveClause((MSClause)this.clauses.get(i));
        }
        this.clauses.shrinkTo(newClausesSize);
        int newLearntsSize = Math.min(state[3], this.learnts.size());
        for (i = this.learnts.size() - 1; i >= newLearntsSize; --i) {
            this.simpleRemoveClause((MSClause)this.learnts.get(i));
        }
        this.learnts.shrinkTo(newLearntsSize);
        this.watches.shrinkTo(newVarsSize * 2);
        this.unitClauses.shrinkTo(state[4]);
        for (i = 0; this.ok && i < this.unitClauses.size(); ++i) {
            this.uncheckedEnqueue(this.unitClauses.get(i), null);
            this.ok = this.propagate() == null;
        }
    }

    @Override
    protected void uncheckedEnqueue(int lit, MSClause reason) {
        assert (this.value(lit) == Tristate.UNDEF);
        MSVariable var = this.v(lit);
        var.assign(Tristate.fromBool(!MiniCard.sign(lit)));
        var.setReason(reason);
        var.setLevel(this.decisionLevel());
        this.trail.push(lit);
    }

    @Override
    protected void attachClause(MSClause c) {
        if (c.isAtMost()) {
            for (int i = 0; i < c.atMostWatchers(); ++i) {
                int l = c.get(i);
                ((LNGVector)this.watches.get(l)).push(new MSWatcher(c, -1));
            }
            this.clausesLiterals += c.size();
        } else {
            assert (c.size() > 1);
            ((LNGVector)this.watches.get(MiniCard.not(c.get(0)))).push(new MSWatcher(c, c.get(1)));
            ((LNGVector)this.watches.get(MiniCard.not(c.get(1)))).push(new MSWatcher(c, c.get(0)));
            if (c.learnt()) {
                this.learntsLiterals += c.size();
            } else {
                this.clausesLiterals += c.size();
            }
        }
    }

    @Override
    protected void detachClause(MSClause c) {
        assert (!c.isAtMost());
        assert (c.size() > 1);
        ((LNGVector)this.watches.get(MiniCard.not(c.get(0)))).remove(new MSWatcher(c, c.get(1)));
        ((LNGVector)this.watches.get(MiniCard.not(c.get(1)))).remove(new MSWatcher(c, c.get(0)));
        if (c.learnt()) {
            this.learntsLiterals -= c.size();
        } else {
            this.clausesLiterals -= c.size();
        }
    }

    @Override
    protected void removeClause(MSClause c) {
        if (c.isAtMost()) {
            this.detachAtMost(c);
            for (int i = 0; i < c.atMostWatchers(); ++i) {
                if (this.value(c.get(i)) != Tristate.FALSE || this.v(c.get(i)).reason() == null || this.v(c.get(i)).reason() != c) continue;
                this.v(c.get(i)).setReason(null);
            }
        } else {
            this.detachClause(c);
            if (this.locked(c)) {
                this.v(c.get(0)).setReason(null);
            }
        }
    }

    @Override
    protected MSClause propagate() {
        MSClause confl = null;
        int numProps = 0;
        while (this.qhead < this.trail.size()) {
            int p = this.trail.get(this.qhead++);
            LNGVector ws = (LNGVector)this.watches.get(p);
            int iInd = 0;
            int jInd = 0;
            ++numProps;
            while (iInd < ws.size()) {
                MSWatcher i = (MSWatcher)ws.get(iInd);
                int blocker = i.blocker();
                if (blocker != -1 && this.value(blocker) == Tristate.TRUE) {
                    ws.set(jInd++, i);
                    ++iInd;
                    continue;
                }
                MSClause c = i.clause();
                if (c.isAtMost()) {
                    int newWatch = this.findNewWatch(c, p);
                    if (newWatch == -1) {
                        for (int k = 0; k < c.atMostWatchers(); ++k) {
                            if (c.get(k) == p || this.value(c.get(k)) == Tristate.FALSE) continue;
                            assert (this.value(c.get(k)) == Tristate.UNDEF || this.value(c.get(k)) == Tristate.FALSE);
                            this.uncheckedEnqueue(MiniCard.not(c.get(k)), c);
                        }
                        ws.set(jInd++, ws.get(iInd++));
                        continue;
                    }
                    if (newWatch == -2) {
                        confl = c;
                        this.qhead = this.trail.size();
                        while (iInd < ws.size()) {
                            ws.set(jInd++, ws.get(iInd++));
                        }
                        continue;
                    }
                    if (newWatch == p) {
                        ws.set(jInd++, ws.get(iInd++));
                        continue;
                    }
                    ++iInd;
                    MSWatcher w = new MSWatcher(c, -1);
                    ((LNGVector)this.watches.get(newWatch)).push(w);
                    continue;
                }
                int falseLit = MiniCard.not(p);
                if (c.get(0) == falseLit) {
                    c.set(0, c.get(1));
                    c.set(1, falseLit);
                }
                assert (c.get(1) == falseLit);
                ++iInd;
                int first = c.get(0);
                MSWatcher w = new MSWatcher(c, first);
                if (first != blocker && this.value(first) == Tristate.TRUE) {
                    ws.set(jInd++, w);
                    continue;
                }
                boolean foundWatch = false;
                for (int k = 2; k < c.size() && !foundWatch; ++k) {
                    if (this.value(c.get(k)) == Tristate.FALSE) continue;
                    c.set(1, c.get(k));
                    c.set(k, falseLit);
                    ((LNGVector)this.watches.get(MiniCard.not(c.get(1)))).push(w);
                    foundWatch = true;
                }
                if (foundWatch) continue;
                ws.set(jInd++, w);
                if (this.value(first) == Tristate.FALSE) {
                    confl = c;
                    this.qhead = this.trail.size();
                    while (iInd < ws.size()) {
                        ws.set(jInd++, ws.get(iInd++));
                    }
                    continue;
                }
                this.uncheckedEnqueue(first, c);
            }
            ws.removeElements(iInd - jInd);
        }
        this.simpDBProps -= numProps;
        return confl;
    }

    @Override
    protected boolean litRedundant(int p, int abstractLevels) {
        this.analyzeStack.clear();
        this.analyzeStack.push(p);
        int top = this.analyzeToClear.size();
        while (this.analyzeStack.size() > 0) {
            int q;
            int i;
            assert (this.v(this.analyzeStack.back()).reason() != null);
            MSClause c = this.v(this.analyzeStack.back()).reason();
            this.analyzeStack.pop();
            if (c.isAtMost()) {
                for (i = 0; i < c.size(); ++i) {
                    if (this.value(c.get(i)) != Tristate.TRUE || this.seen.get(MiniCard.var(q = MiniCard.not(c.get(i)))) || this.v(q).level() <= 0) continue;
                    if (this.v(q).reason() != null && (this.abstractLevel(MiniCard.var(q)) & abstractLevels) != 0) {
                        this.seen.set(MiniCard.var(q), true);
                        this.analyzeStack.push(q);
                        this.analyzeToClear.push(q);
                        continue;
                    }
                    for (int j = top; j < this.analyzeToClear.size(); ++j) {
                        this.seen.set(MiniCard.var(this.analyzeToClear.get(j)), false);
                    }
                    this.analyzeToClear.removeElements(this.analyzeToClear.size() - top);
                    return false;
                }
                continue;
            }
            for (i = 1; i < c.size(); ++i) {
                q = c.get(i);
                if (this.seen.get(MiniCard.var(q)) || this.v(q).level() <= 0) continue;
                if (this.v(q).reason() != null && (this.abstractLevel(MiniCard.var(q)) & abstractLevels) != 0) {
                    this.seen.set(MiniCard.var(q), true);
                    this.analyzeStack.push(q);
                    this.analyzeToClear.push(q);
                    continue;
                }
                for (int j = top; j < this.analyzeToClear.size(); ++j) {
                    this.seen.set(MiniCard.var(this.analyzeToClear.get(j)), false);
                }
                this.analyzeToClear.removeElements(this.analyzeToClear.size() - top);
                return false;
            }
        }
        return true;
    }

    @Override
    protected void analyzeFinal(int p, LNGIntVector outConflict) {
        outConflict.clear();
        outConflict.push(p);
        if (this.decisionLevel() == 0) {
            return;
        }
        this.seen.set(MiniCard.var(p), true);
        for (int i = this.trail.size() - 1; i >= this.trailLim.get(0); --i) {
            int x = MiniCard.var(this.trail.get(i));
            if (!this.seen.get(x)) continue;
            MSVariable v = (MSVariable)this.vars.get(x);
            if (v.reason() == null) {
                assert (v.level() > 0);
                outConflict.push(MiniCard.not(this.trail.get(i)));
            } else {
                int j;
                MSClause c = v.reason();
                if (!c.isAtMost()) {
                    for (j = 1; j < c.size(); ++j) {
                        if (this.v(c.get(j)).level() <= 0) continue;
                        this.seen.set(MiniCard.var(c.get(j)), true);
                    }
                } else {
                    for (j = 0; j < c.size(); ++j) {
                        if (this.value(c.get(j)) != Tristate.TRUE || this.v(c.get(j)).level() <= 0) continue;
                        this.seen.set(MiniCard.var(c.get(j)), true);
                    }
                }
            }
            this.seen.set(x, false);
        }
        this.seen.set(MiniCard.var(p), false);
    }

    @Override
    protected void reduceDB() {
        int i;
        double extraLim = this.claInc / (double)this.learnts.size();
        this.learnts.manualSort(MSClause.minisatComparator);
        int j = 0;
        for (i = 0; i < this.learnts.size(); ++i) {
            MSClause c = (MSClause)this.learnts.get(i);
            assert (!c.isAtMost());
            if (c.size() > 2 && !this.locked(c) && (i < this.learnts.size() / 2 || c.activity() < extraLim)) {
                this.removeClause((MSClause)this.learnts.get(i));
                continue;
            }
            this.learnts.set(j++, this.learnts.get(i));
        }
        this.learnts.removeElements(i - j);
    }

    @Override
    protected void removeSatisfied(LNGVector<MSClause> cs) {
        int i;
        int j = 0;
        for (i = 0; i < cs.size(); ++i) {
            MSClause c = cs.get(i);
            if (this.satisfied(c)) {
                this.removeClause(cs.get(i));
                continue;
            }
            cs.set(j++, cs.get(i));
        }
        cs.removeElements(i - j);
    }

    @Override
    protected boolean satisfied(MSClause c) {
        if (c.isAtMost()) {
            int numFalse = 0;
            for (int i = 0; i < c.size(); ++i) {
                if (this.value(c.get(i)) != Tristate.FALSE || ++numFalse < c.atMostWatchers() - 1) continue;
                return true;
            }
        } else {
            for (int i = 0; i < c.size(); ++i) {
                if (this.value(c.get(i)) != Tristate.TRUE) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean simplify() {
        assert (this.decisionLevel() == 0);
        if (!this.ok || this.propagate() != null) {
            this.ok = false;
            return false;
        }
        if (this.nAssigns() == this.simpDBAssigns || this.simpDBProps > 0) {
            return true;
        }
        this.removeSatisfied(this.learnts);
        if (this.shouldRemoveSatsisfied) {
            this.removeSatisfied(this.clauses);
        }
        this.rebuildOrderHeap();
        this.simpDBAssigns = this.nAssigns();
        this.simpDBProps = this.clausesLiterals + this.learntsLiterals;
        return true;
    }

    public boolean addAtMost(LNGIntVector ps, int rhs) {
        int i;
        int k = rhs;
        assert (this.decisionLevel() == 0);
        if (!this.ok) {
            return false;
        }
        ps.sort();
        int j = 0;
        int p = -1;
        for (i = 0; i < ps.size(); ++i) {
            if (this.value(ps.get(i)) == Tristate.TRUE) {
                --k;
                continue;
            }
            if (ps.get(i) == MiniCard.not(p)) {
                p = ps.get(i);
                --j;
                --k;
                continue;
            }
            if (this.value(ps.get(i)) == Tristate.FALSE || ps.get(i) == p) continue;
            p = ps.get(i);
            ps.set(j++, p);
        }
        ps.removeElements(i - j);
        if (k >= ps.size()) {
            return true;
        }
        if (k < 0) {
            this.ok = false;
            return false;
        }
        if (k == 0) {
            for (i = 0; i < ps.size(); ++i) {
                this.uncheckedEnqueue(MiniCard.not(ps.get(i)), null);
                if (!this.incremental) continue;
                this.unitClauses.push(MiniCard.not(ps.get(i)));
            }
            this.ok = this.propagate() == null;
            return this.ok;
        }
        MSClause cr = new MSClause(ps, false, true);
        cr.setAtMostWatchers(ps.size() - k + 1);
        this.clauses.push(cr);
        this.attachClause(cr);
        return true;
    }

    protected void detachAtMost(MSClause c) {
        for (int i = 0; i < c.atMostWatchers(); ++i) {
            ((LNGVector)this.watches.get(c.get(i))).remove(new MSWatcher(c, c.get(i)));
        }
        this.clausesLiterals -= c.size();
    }

    protected Tristate search(int nofConflicts) {
        if (!this.ok) {
            return Tristate.FALSE;
        }
        int conflictC = 0;
        this.selectionOrderIdx = 0;
        while (true) {
            MSClause confl;
            if ((confl = this.propagate()) != null) {
                if (this.handler != null && !this.handler.detectedConflict()) {
                    this.canceledByHandler = true;
                    return Tristate.UNDEF;
                }
                ++conflictC;
                if (this.decisionLevel() == 0) {
                    return Tristate.FALSE;
                }
                LNGIntVector learntClause = new LNGIntVector();
                this.analyze(confl, learntClause);
                this.cancelUntil(this.analyzeBtLevel);
                if (this.analyzeBtLevel < this.selectionOrder.size()) {
                    this.selectionOrderIdx = this.analyzeBtLevel;
                }
                if (learntClause.size() == 1) {
                    this.uncheckedEnqueue(learntClause.get(0), null);
                    this.unitClauses.push(learntClause.get(0));
                } else {
                    MSClause cr = new MSClause(learntClause, true);
                    this.learnts.push(cr);
                    this.attachClause(cr);
                    if (!this.incremental) {
                        this.claBumpActivity(cr);
                    }
                    this.uncheckedEnqueue(learntClause.get(0), cr);
                }
                this.decayActivities();
                continue;
            }
            if (nofConflicts >= 0 && conflictC >= nofConflicts) {
                this.cancelUntil(0);
                return Tristate.UNDEF;
            }
            if (!this.incremental) {
                if (this.decisionLevel() == 0 && !this.simplify()) {
                    return Tristate.FALSE;
                }
                if ((double)(this.learnts.size() - this.nAssigns()) >= this.maxLearnts) {
                    this.reduceDB();
                }
            }
            int next = -1;
            while (this.decisionLevel() < this.assumptions.size()) {
                int p = this.assumptions.get(this.decisionLevel());
                if (this.value(p) == Tristate.TRUE) {
                    this.trailLim.push(this.trail.size());
                    continue;
                }
                if (this.value(p) == Tristate.FALSE) {
                    this.analyzeFinal(MiniCard.not(p), this.conflict);
                    return Tristate.FALSE;
                }
                next = p;
                break;
            }
            if (next == -1 && (next = this.pickBranchLit()) == -1) {
                return Tristate.TRUE;
            }
            this.trailLim.push(this.trail.size());
            this.uncheckedEnqueue(next, null);
        }
    }

    protected int findNewWatch(MSClause c, int p) {
        assert (c.isAtMost());
        int newWatch = -2;
        int numFalse = 0;
        int numTrue = 0;
        int maxTrue = c.size() - c.atMostWatchers() + 1;
        for (int q = 0; q < c.atMostWatchers(); ++q) {
            Tristate val = this.value(c.get(q));
            if (val == Tristate.UNDEF) continue;
            if (val == Tristate.FALSE) {
                if (++numFalse < c.atMostWatchers() - 1) continue;
                return p;
            }
            assert (val == Tristate.TRUE);
            if (++numTrue > maxTrue) {
                return -2;
            }
            if (c.get(q) != p) continue;
            assert (newWatch == -2);
            for (int next = c.atMostWatchers(); next < c.size(); ++next) {
                if (this.value(c.get(next)) == Tristate.TRUE) continue;
                newWatch = c.get(next);
                c.set(next, c.get(q));
                c.set(q, newWatch);
                return newWatch;
            }
            newWatch = -1;
        }
        assert (newWatch == -1);
        if (numTrue > 1) {
            return -2;
        }
        return -1;
    }

    protected void analyze(MSClause conflictClause, LNGIntVector outLearnt) {
        MSClause c = conflictClause;
        int pathC = 0;
        int p = -1;
        outLearnt.push(-1);
        int index = this.trail.size() - 1;
        do {
            int q;
            int j;
            assert (c != null);
            if (c.isAtMost()) {
                for (j = 0; j < c.size(); ++j) {
                    if (this.value(c.get(j)) != Tristate.TRUE || this.seen.get(MiniCard.var(q = MiniCard.not(c.get(j)))) || this.v(q).level() <= 0) continue;
                    this.varBumpActivity(MiniCard.var(q));
                    this.seen.set(MiniCard.var(q), true);
                    if (this.v(q).level() >= this.decisionLevel()) {
                        ++pathC;
                        continue;
                    }
                    outLearnt.push(q);
                }
            } else {
                if (!this.incremental && c.learnt()) {
                    this.claBumpActivity(c);
                }
                int n = j = p == -1 ? 0 : 1;
                while (j < c.size()) {
                    q = c.get(j);
                    if (!this.seen.get(MiniCard.var(q)) && this.v(q).level() > 0) {
                        this.varBumpActivity(MiniCard.var(q));
                        this.seen.set(MiniCard.var(q), true);
                        if (this.v(q).level() >= this.decisionLevel()) {
                            ++pathC;
                        } else {
                            outLearnt.push(q);
                        }
                    }
                    ++j;
                }
            }
            while (!this.seen.get(MiniCard.var(this.trail.get(index--)))) {
            }
            p = this.trail.get(index + 1);
            c = this.v(p).reason();
            this.seen.set(MiniCard.var(p), false);
        } while (--pathC > 0);
        outLearnt.set(0, MiniCard.not(p));
        this.simplifyClause(outLearnt);
    }

    protected void simplifyClause(LNGIntVector outLearnt) {
        int k;
        int j;
        int i;
        this.analyzeToClear = new LNGIntVector(outLearnt);
        if (this.ccminMode == MiniSatConfig.ClauseMinimization.DEEP) {
            int abstractLevel = 0;
            for (i = 1; i < outLearnt.size(); ++i) {
                abstractLevel |= this.abstractLevel(MiniCard.var(outLearnt.get(i)));
            }
            j = 1;
            for (i = 1; i < outLearnt.size(); ++i) {
                if (this.v(outLearnt.get(i)).reason() != null && this.litRedundant(outLearnt.get(i), abstractLevel)) continue;
                outLearnt.set(j++, outLearnt.get(i));
            }
        } else if (this.ccminMode == MiniSatConfig.ClauseMinimization.BASIC) {
            j = 1;
            block2: for (i = 1; i < outLearnt.size(); ++i) {
                if (this.v(outLearnt.get(i)).reason() == null) {
                    outLearnt.set(j++, outLearnt.get(i));
                    continue;
                }
                MSClause c = this.v(outLearnt.get(i)).reason();
                assert (!c.isAtMost());
                for (k = 1; k < c.size(); ++k) {
                    if (this.seen.get(MiniCard.var(c.get(k))) || this.v(c.get(k)).level() <= 0) continue;
                    outLearnt.set(j++, outLearnt.get(i));
                    continue block2;
                }
            }
        } else {
            i = j = outLearnt.size();
        }
        outLearnt.removeElements(i - j);
        this.analyzeBtLevel = 0;
        if (outLearnt.size() > 1) {
            int max = 1;
            for (k = 2; k < outLearnt.size(); ++k) {
                if (this.v(outLearnt.get(k)).level() <= this.v(outLearnt.get(max)).level()) continue;
                max = k;
            }
            int p = outLearnt.get(max);
            outLearnt.set(max, outLearnt.get(1));
            outLearnt.set(1, p);
            this.analyzeBtLevel = this.v(p).level();
        }
        for (int l = 0; l < this.analyzeToClear.size(); ++l) {
            this.seen.set(MiniCard.var(this.analyzeToClear.get(l)), false);
        }
    }

    protected void completeBacktrack() {
        for (int v = 0; v < this.vars.size(); ++v) {
            MSVariable var = (MSVariable)this.vars.get(v);
            var.assign(Tristate.UNDEF);
            var.setReason(null);
            if (this.orderHeap.inHeap(v) || !var.decision()) continue;
            this.orderHeap.insert(v);
        }
        this.trail.clear();
        this.trailLim.clear();
        this.qhead = 0;
    }

    protected void simpleRemoveClause(MSClause c) {
        if (c.isAtMost()) {
            for (int i = 0; i < c.atMostWatchers(); ++i) {
                ((LNGVector)this.watches.get(c.get(i))).remove(new MSWatcher(c, c.get(i)));
            }
        } else {
            ((LNGVector)this.watches.get(MiniCard.not(c.get(0)))).remove(new MSWatcher(c, c.get(1)));
            ((LNGVector)this.watches.get(MiniCard.not(c.get(1)))).remove(new MSWatcher(c, c.get(0)));
        }
    }
}

