/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.solvers.sat;

import org.logicng.collections.LNGBooleanVector;
import org.logicng.collections.LNGIntVector;
import org.logicng.collections.LNGVector;
import org.logicng.datastructures.Tristate;
import org.logicng.handlers.SATHandler;
import org.logicng.propositions.Proposition;
import org.logicng.solvers.datastructures.LNGBoundedIntQueue;
import org.logicng.solvers.datastructures.LNGBoundedLongQueue;
import org.logicng.solvers.datastructures.MSClause;
import org.logicng.solvers.datastructures.MSVariable;
import org.logicng.solvers.datastructures.MSWatcher;
import org.logicng.solvers.sat.GlucoseConfig;
import org.logicng.solvers.sat.MiniSatConfig;
import org.logicng.solvers.sat.MiniSatStyleSolver;

public class GlucoseSyrup
extends MiniSatStyleSolver {
    protected static final int RATIO_REMOVE_CLAUSES = 2;
    protected static final int LB_BLOCKING_RESTART = 10000;
    protected final GlucoseConfig glucoseConfig;
    protected LNGVector<LNGVector<MSWatcher>> watchesBin;
    protected LNGIntVector permDiff;
    protected LNGIntVector lastDecisionLevel;
    protected LNGBoundedLongQueue lbdQueue;
    protected LNGBoundedIntQueue trailQueue;
    protected LNGBooleanVector assump;
    protected int myflag;
    protected long analyzeLBD;
    protected int analyzeSzWithoutSelectors;
    protected int nbclausesbeforereduce;
    protected int conflicts;
    protected int conflictsRestarts;
    protected double sumLBD;
    protected int curRestart;
    protected int lbLBDMinimizingClause;
    protected int lbLBDFrozenClause;
    protected int lbSizeMinimizingClause;
    protected int firstReduceDB;
    protected int specialIncReduceDB;
    protected int incReduceDB;
    protected double factorK;
    protected double factorR;
    protected int sizeLBDQueue;
    protected int sizeTrailQueue;
    protected boolean reduceOnSize;
    protected int reduceOnSizeSize;
    protected double maxVarDecay;

    GlucoseSyrup() {
        this(MiniSatConfig.builder().build(), GlucoseConfig.builder().build());
    }

    public GlucoseSyrup(MiniSatConfig config, GlucoseConfig glucoseConfig) {
        super(config);
        this.glucoseConfig = glucoseConfig;
        this.initializeGlucose();
    }

    protected void initializeGlucose() {
        this.initializeGlucoseConfig();
        this.watchesBin = new LNGVector();
        this.permDiff = new LNGIntVector();
        this.lastDecisionLevel = new LNGIntVector();
        this.lbdQueue = new LNGBoundedLongQueue();
        this.trailQueue = new LNGBoundedIntQueue();
        this.assump = new LNGBooleanVector();
        this.lbdQueue.initSize(this.sizeLBDQueue);
        this.trailQueue.initSize(this.sizeTrailQueue);
        this.myflag = 0;
        this.analyzeBtLevel = 0;
        this.analyzeLBD = 0L;
        this.analyzeSzWithoutSelectors = 0;
        this.nbclausesbeforereduce = this.firstReduceDB;
        this.conflicts = 0;
        this.conflictsRestarts = 0;
        this.sumLBD = 0.0;
        this.curRestart = 1;
    }

    protected void initializeGlucoseConfig() {
        this.lbLBDMinimizingClause = this.glucoseConfig.lbLBDMinimizingClause;
        this.lbLBDFrozenClause = this.glucoseConfig.lbLBDFrozenClause;
        this.lbSizeMinimizingClause = this.glucoseConfig.lbSizeMinimizingClause;
        this.firstReduceDB = this.glucoseConfig.firstReduceDB;
        this.specialIncReduceDB = this.glucoseConfig.specialIncReduceDB;
        this.incReduceDB = this.glucoseConfig.incReduceDB;
        this.factorK = this.glucoseConfig.factorK;
        this.factorR = this.glucoseConfig.factorR;
        this.sizeLBDQueue = this.glucoseConfig.sizeLBDQueue;
        this.sizeTrailQueue = this.glucoseConfig.sizeTrailQueue;
        this.reduceOnSize = this.glucoseConfig.reduceOnSize;
        this.reduceOnSizeSize = this.glucoseConfig.reduceOnSizeSize;
        this.maxVarDecay = this.glucoseConfig.maxVarDecay;
    }

    @Override
    public int newVar(boolean sign, boolean dvar) {
        int v = this.nVars();
        MSVariable newVar = new MSVariable(sign);
        this.watches.push(new LNGVector());
        this.watches.push(new LNGVector());
        this.watchesBin.push(new LNGVector());
        this.watchesBin.push(new LNGVector());
        this.vars.push(newVar);
        this.seen.push(false);
        this.permDiff.push(0);
        this.assump.push(false);
        newVar.setDecision(dvar);
        this.insertVarOrder(v);
        return v;
    }

    @Override
    public boolean addClause(LNGIntVector ps, Proposition proposition) {
        int p;
        int i;
        assert (this.decisionLevel() == 0);
        if (this.config.proofGeneration) {
            LNGIntVector vec = new LNGIntVector(ps.size());
            for (i = 0; i < ps.size(); ++i) {
                vec.push((GlucoseSyrup.var(ps.get(i)) + 1) * (-2 * (GlucoseSyrup.sign(ps.get(i)) ? 1 : 0) + 1));
            }
            this.pgOriginalClauses.push(new MiniSatStyleSolver.ProofInformation(vec, proposition));
        }
        if (!this.ok) {
            return false;
        }
        ps.sort();
        boolean flag = false;
        LNGIntVector oc = null;
        if (this.config.proofGeneration) {
            oc = new LNGIntVector();
            p = -1;
            for (i = 0; i < ps.size(); ++i) {
                oc.push(ps.get(i));
                if (this.value(ps.get(i)) != Tristate.TRUE && ps.get(i) != GlucoseSyrup.not(p) && this.value(ps.get(i)) != Tristate.FALSE) continue;
                flag = true;
            }
        }
        int j = 0;
        p = -1;
        for (i = 0; i < ps.size(); ++i) {
            if (this.value(ps.get(i)) == Tristate.TRUE || ps.get(i) == GlucoseSyrup.not(p)) {
                return true;
            }
            if (this.value(ps.get(i)) == Tristate.FALSE || ps.get(i) == p) continue;
            p = ps.get(i);
            ps.set(j++, p);
        }
        ps.removeElements(i - j);
        if (flag) {
            LNGIntVector vec = new LNGIntVector(ps.size() + 1);
            vec.push(1);
            for (i = 0; i < ps.size(); ++i) {
                vec.push((GlucoseSyrup.var(ps.get(i)) + 1) * (-2 * (GlucoseSyrup.sign(ps.get(i)) ? 1 : 0) + 1));
            }
            this.pgProof.push(vec);
            vec = new LNGIntVector(oc.size());
            vec.push(-1);
            for (i = 0; i < oc.size(); ++i) {
                vec.push((GlucoseSyrup.var(oc.get(i)) + 1) * (-2 * (GlucoseSyrup.sign(oc.get(i)) ? 1 : 0) + 1));
            }
            this.pgProof.push(vec);
        }
        if (ps.size() == 0) {
            this.ok = false;
            return false;
        }
        if (ps.size() == 1) {
            this.uncheckedEnqueue(ps.get(0), null);
            this.ok = this.propagate() == null;
            return this.ok;
        }
        MSClause c = new MSClause(ps, false);
        this.clauses.push(c);
        this.attachClause(c);
        return true;
    }

    @Override
    public Tristate solve(SATHandler handler) {
        if (this.config.incremental && this.config.proofGeneration) {
            throw new IllegalStateException("Cannot use incremental and proof generation at the same time");
        }
        this.handler = handler;
        if (this.handler != null) {
            this.handler.started();
        }
        this.model.clear();
        this.conflict.clear();
        if (!this.ok) {
            return Tristate.FALSE;
        }
        for (int i = 0; i < this.assumptions.size(); ++i) {
            this.assump.set(GlucoseSyrup.var(this.assumptions.get(i)), !GlucoseSyrup.sign(this.assumptions.get(i)));
        }
        Tristate status = Tristate.UNDEF;
        while (status == Tristate.UNDEF && !this.canceledByHandler) {
            status = this.search();
        }
        if (this.config.proofGeneration && this.assumptions.empty() && status == Tristate.FALSE) {
            this.pgProof.push(new LNGIntVector(1, 0));
        }
        if (status == Tristate.TRUE) {
            this.model = new LNGBooleanVector(this.vars.size());
            for (MSVariable v : this.vars) {
                this.model.push(v.assignment() == Tristate.TRUE);
            }
        } else if (status == Tristate.FALSE && this.conflict.size() == 0) {
            this.ok = false;
        }
        if (this.handler != null) {
            this.handler.finishedSolving();
        }
        this.cancelUntil(0);
        this.handler = null;
        this.canceledByHandler = false;
        for (int i = 0; i < this.assumptions.size(); ++i) {
            this.assump.set(GlucoseSyrup.var(this.assumptions.get(i)), false);
        }
        return status;
    }

    @Override
    public void reset() {
        super.initialize();
        this.initializeGlucose();
    }

    @Override
    public int[] saveState() {
        throw new UnsupportedOperationException("The Glucose solver does not support state loading/saving");
    }

    @Override
    public void loadState(int[] state) {
        throw new UnsupportedOperationException("The Glucose solver does not support state loading/saving");
    }

    @Override
    protected void uncheckedEnqueue(int lit, MSClause reason) {
        assert (this.value(lit) == Tristate.UNDEF);
        MSVariable var = this.v(lit);
        var.assign(Tristate.fromBool(!GlucoseSyrup.sign(lit)));
        var.setReason(reason);
        var.setLevel(this.decisionLevel());
        this.trail.push(lit);
    }

    @Override
    protected void attachClause(MSClause c) {
        assert (c.size() > 1);
        if (c.size() == 2) {
            this.watchesBin.get(GlucoseSyrup.not(c.get(0))).push(new MSWatcher(c, c.get(1)));
            this.watchesBin.get(GlucoseSyrup.not(c.get(1))).push(new MSWatcher(c, c.get(0)));
        } else {
            ((LNGVector)this.watches.get(GlucoseSyrup.not(c.get(0)))).push(new MSWatcher(c, c.get(1)));
            ((LNGVector)this.watches.get(GlucoseSyrup.not(c.get(1)))).push(new MSWatcher(c, c.get(0)));
        }
        if (c.learnt()) {
            this.learntsLiterals += c.size();
        } else {
            this.clausesLiterals += c.size();
        }
    }

    @Override
    protected void detachClause(MSClause c) {
        assert (c.size() > 1);
        if (c.size() == 2) {
            this.watchesBin.get(GlucoseSyrup.not(c.get(0))).remove(new MSWatcher(c, c.get(1)));
            this.watchesBin.get(GlucoseSyrup.not(c.get(1))).remove(new MSWatcher(c, c.get(0)));
        } else {
            ((LNGVector)this.watches.get(GlucoseSyrup.not(c.get(0)))).remove(new MSWatcher(c, c.get(1)));
            ((LNGVector)this.watches.get(GlucoseSyrup.not(c.get(1)))).remove(new MSWatcher(c, c.get(0)));
        }
        if (c.learnt()) {
            this.learntsLiterals -= c.size();
        } else {
            this.clausesLiterals -= c.size();
        }
    }

    @Override
    protected void removeClause(MSClause c) {
        if (this.config.proofGeneration) {
            LNGIntVector vec = new LNGIntVector(c.size());
            vec.push(-1);
            for (int i = 0; i < c.size(); ++i) {
                vec.push((GlucoseSyrup.var(c.get(i)) + 1) * (-2 * (GlucoseSyrup.sign(c.get(i)) ? 1 : 0) + 1));
            }
            this.pgProof.push(vec);
        }
        this.detachClause(c);
        if (this.locked(c)) {
            this.v(c.get(0)).setReason(null);
        }
    }

    @Override
    protected MSClause propagate() {
        MSClause confl = null;
        int numProps = 0;
        while (this.qhead < this.trail.size()) {
            int p = this.trail.get(this.qhead++);
            LNGVector ws = (LNGVector)this.watches.get(p);
            int iInd = 0;
            int jInd = 0;
            ++numProps;
            LNGVector<MSWatcher> wbin = this.watchesBin.get(p);
            for (int k = 0; k < wbin.size(); ++k) {
                int imp = wbin.get(k).blocker();
                if (this.value(imp) == Tristate.FALSE) {
                    return wbin.get(k).clause();
                }
                if (this.value(imp) != Tristate.UNDEF) continue;
                this.uncheckedEnqueue(imp, wbin.get(k).clause());
            }
            while (iInd < ws.size()) {
                MSWatcher i = (MSWatcher)ws.get(iInd);
                int blocker = i.blocker();
                if (this.value(blocker) == Tristate.TRUE) {
                    ws.set(jInd++, i);
                    ++iInd;
                    continue;
                }
                MSClause c = i.clause();
                assert (!c.oneWatched());
                int falseLit = GlucoseSyrup.not(p);
                if (c.get(0) == falseLit) {
                    c.set(0, c.get(1));
                    c.set(1, falseLit);
                }
                assert (c.get(1) == falseLit);
                ++iInd;
                int first = c.get(0);
                MSWatcher w = new MSWatcher(c, first);
                if (first != blocker && this.value(first) == Tristate.TRUE) {
                    ws.set(jInd++, w);
                    continue;
                }
                boolean foundWatch = false;
                if (this.incremental) {
                    int choosenPos = -1;
                    for (int k = 2; k < c.size(); ++k) {
                        if (this.value(c.get(k)) == Tristate.FALSE) continue;
                        if (this.decisionLevel() > this.assumptions.size()) {
                            choosenPos = k;
                            break;
                        }
                        choosenPos = k;
                        if (this.value(c.get(k)) == Tristate.TRUE || !this.isSelector(GlucoseSyrup.var(c.get(k)))) break;
                    }
                    if (choosenPos != -1) {
                        c.set(1, c.get(choosenPos));
                        c.set(choosenPos, falseLit);
                        ((LNGVector)this.watches.get(GlucoseSyrup.not(c.get(1)))).push(w);
                        foundWatch = true;
                    }
                } else {
                    for (int k = 2; k < c.size() && !foundWatch; ++k) {
                        if (this.value(c.get(k)) == Tristate.FALSE) continue;
                        c.set(1, c.get(k));
                        c.set(k, falseLit);
                        ((LNGVector)this.watches.get(GlucoseSyrup.not(c.get(1)))).push(w);
                        foundWatch = true;
                    }
                }
                if (foundWatch) continue;
                ws.set(jInd++, w);
                if (this.value(first) == Tristate.FALSE) {
                    confl = c;
                    this.qhead = this.trail.size();
                    while (iInd < ws.size()) {
                        ws.set(jInd++, ws.get(iInd++));
                    }
                    continue;
                }
                this.uncheckedEnqueue(first, c);
            }
            ws.removeElements(iInd - jInd);
        }
        this.simpDBProps -= numProps;
        return confl;
    }

    @Override
    protected boolean litRedundant(int p, int abstractLevels) {
        this.analyzeStack.clear();
        this.analyzeStack.push(p);
        int top = this.analyzeToClear.size();
        while (this.analyzeStack.size() > 0) {
            assert (this.v(this.analyzeStack.back()).reason() != null);
            MSClause c = this.v(this.analyzeStack.back()).reason();
            this.analyzeStack.pop();
            if (c.size() == 2 && this.value(c.get(0)) == Tristate.FALSE) {
                assert (this.value(c.get(1)) == Tristate.TRUE);
                int tmp = c.get(0);
                c.set(0, c.get(1));
                c.set(1, tmp);
            }
            for (int i = 1; i < c.size(); ++i) {
                int q = c.get(i);
                if (this.seen.get(GlucoseSyrup.var(q)) || this.v(q).level() <= 0) continue;
                if (this.v(q).reason() != null && (this.abstractLevel(GlucoseSyrup.var(q)) & abstractLevels) != 0) {
                    this.seen.set(GlucoseSyrup.var(q), true);
                    this.analyzeStack.push(q);
                    this.analyzeToClear.push(q);
                    continue;
                }
                for (int j = top; j < this.analyzeToClear.size(); ++j) {
                    this.seen.set(GlucoseSyrup.var(this.analyzeToClear.get(j)), false);
                }
                this.analyzeToClear.removeElements(this.analyzeToClear.size() - top);
                return false;
            }
        }
        return true;
    }

    @Override
    protected void analyzeFinal(int p, LNGIntVector outConflict) {
        outConflict.clear();
        outConflict.push(p);
        if (this.decisionLevel() == 0) {
            return;
        }
        this.seen.set(GlucoseSyrup.var(p), true);
        for (int i = this.trail.size() - 1; i >= this.trailLim.get(0); --i) {
            int x = GlucoseSyrup.var(this.trail.get(i));
            if (!this.seen.get(x)) continue;
            MSVariable v = (MSVariable)this.vars.get(x);
            if (v.reason() == null) {
                assert (v.level() > 0);
                outConflict.push(GlucoseSyrup.not(this.trail.get(i)));
            } else {
                int j;
                MSClause c = v.reason();
                int n = j = c.size() == 2 ? 0 : 1;
                while (j < c.size()) {
                    if (this.v(c.get(j)).level() > 0) {
                        this.seen.set(GlucoseSyrup.var(c.get(j)), true);
                    }
                    ++j;
                }
            }
            this.seen.set(x, false);
        }
        this.seen.set(GlucoseSyrup.var(p), false);
    }

    @Override
    protected void reduceDB() {
        int i;
        this.learnts.manualSort(MSClause.glucoseComparator);
        if (((MSClause)this.learnts.get(this.learnts.size() / 2)).lbd() <= 3L) {
            this.nbclausesbeforereduce += this.specialIncReduceDB;
        }
        if (((MSClause)this.learnts.back()).lbd() <= 5L) {
            this.nbclausesbeforereduce += this.specialIncReduceDB;
        }
        int limit = this.learnts.size() / 2;
        int j = 0;
        for (i = 0; i < this.learnts.size(); ++i) {
            MSClause c = (MSClause)this.learnts.get(i);
            if (c.lbd() > 2L && c.size() > 2 && c.canBeDel() && !this.locked(c) && i < limit) {
                this.removeClause((MSClause)this.learnts.get(i));
                continue;
            }
            if (!c.canBeDel()) {
                ++limit;
            }
            c.setCanBeDel(true);
            this.learnts.set(j++, this.learnts.get(i));
        }
        this.learnts.removeElements(i - j);
    }

    @Override
    protected void removeSatisfied(LNGVector<MSClause> cs) {
        int i;
        int j = 0;
        for (i = 0; i < cs.size(); ++i) {
            MSClause c = cs.get(i);
            if (this.satisfied(c)) {
                this.removeClause(cs.get(i));
                continue;
            }
            cs.set(j++, cs.get(i));
        }
        cs.removeElements(i - j);
    }

    @Override
    protected boolean satisfied(MSClause c) {
        if (this.incremental) {
            return this.value(c.get(0)) == Tristate.TRUE || this.value(c.get(1)) == Tristate.TRUE;
        }
        for (int i = 0; i < c.size(); ++i) {
            if (this.value(c.get(i)) != Tristate.TRUE) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean simplify() {
        assert (this.decisionLevel() == 0);
        if (!this.ok) {
            return false;
        }
        MSClause cr = this.propagate();
        if (cr != null) {
            this.ok = false;
            return false;
        }
        if (this.nAssigns() == this.simpDBAssigns || this.simpDBProps > 0) {
            return true;
        }
        this.removeSatisfied(this.learnts);
        if (this.shouldRemoveSatsisfied) {
            this.removeSatisfied(this.clauses);
        }
        this.rebuildOrderHeap();
        this.simpDBAssigns = this.nAssigns();
        this.simpDBProps = this.clausesLiterals + this.learntsLiterals;
        return true;
    }

    protected long computeLBD(LNGIntVector lits, int e) {
        int end = e;
        long nblevels = 0L;
        ++this.myflag;
        if (this.incremental) {
            if (end == -1) {
                end = lits.size();
            }
            long nbDone = 0L;
            for (int i = 0; i < lits.size() && nbDone < (long)end; ++i) {
                if (this.isSelector(GlucoseSyrup.var(lits.get(i)))) continue;
                ++nbDone;
                int l = this.v(lits.get(i)).level();
                if (this.permDiff.get(l) == this.myflag) continue;
                this.permDiff.set(l, this.myflag);
                ++nblevels;
            }
        } else {
            for (int i = 0; i < lits.size(); ++i) {
                int l = this.v(lits.get(i)).level();
                if (this.permDiff.get(l) == this.myflag) continue;
                this.permDiff.set(l, this.myflag);
                ++nblevels;
            }
        }
        if (!this.reduceOnSize) {
            return nblevels;
        }
        if (lits.size() < this.reduceOnSizeSize) {
            return lits.size();
        }
        return (long)lits.size() + nblevels;
    }

    protected long computeLBD(MSClause c) {
        long nblevels = 0L;
        ++this.myflag;
        if (this.incremental) {
            long nbDone = 0L;
            for (int i = 0; i < c.size() && nbDone < (long)c.sizeWithoutSelectors(); ++i) {
                if (this.isSelector(GlucoseSyrup.var(c.get(i)))) continue;
                ++nbDone;
                int l = this.v(c.get(i)).level();
                if (this.permDiff.get(l) == this.myflag) continue;
                this.permDiff.set(l, this.myflag);
                ++nblevels;
            }
        } else {
            for (int i = 0; i < c.size(); ++i) {
                int l = this.v(c.get(i)).level();
                if (this.permDiff.get(l) == this.myflag) continue;
                this.permDiff.set(l, this.myflag);
                ++nblevels;
            }
        }
        if (!this.reduceOnSize) {
            return nblevels;
        }
        if (c.size() < this.reduceOnSizeSize) {
            return c.size();
        }
        return (long)c.size() + nblevels;
    }

    protected boolean isSelector(int v) {
        return this.incremental && this.assump.get(v);
    }

    protected void minimisationWithBinaryResolution(LNGIntVector outLearnt) {
        long lbd = this.computeLBD(outLearnt, -1);
        int p = GlucoseSyrup.not(outLearnt.get(0));
        if (lbd <= (long)this.lbLBDMinimizingClause) {
            ++this.myflag;
            for (int i = 1; i < outLearnt.size(); ++i) {
                this.permDiff.set(GlucoseSyrup.var(outLearnt.get(i)), this.myflag);
            }
            int nb = 0;
            for (MSWatcher wbin : this.watchesBin.get(p)) {
                int imp = wbin.blocker();
                if (this.permDiff.get(GlucoseSyrup.var(imp)) != this.myflag || this.value(imp) != Tristate.TRUE) continue;
                ++nb;
                this.permDiff.set(GlucoseSyrup.var(imp), this.myflag - 1);
            }
            int l = outLearnt.size() - 1;
            if (nb > 0) {
                for (int i = 1; i < outLearnt.size() - nb; ++i) {
                    if (this.permDiff.get(GlucoseSyrup.var(outLearnt.get(i))) == this.myflag) continue;
                    p = outLearnt.get(l);
                    outLearnt.set(l, outLearnt.get(i));
                    outLearnt.set(i, p);
                    --l;
                    --i;
                }
                outLearnt.removeElements(nb);
            }
        }
    }

    protected Tristate search() {
        assert (this.ok);
        LNGIntVector learntClause = new LNGIntVector();
        LNGIntVector selectors = new LNGIntVector();
        boolean blocked = false;
        this.selectionOrderIdx = 0;
        while (true) {
            MSClause confl;
            if ((confl = this.propagate()) != null) {
                if (this.handler != null && !this.handler.detectedConflict()) {
                    this.canceledByHandler = true;
                    return Tristate.UNDEF;
                }
                ++this.conflicts;
                ++this.conflictsRestarts;
                if (this.conflicts % 5000 == 0 && this.varDecay < this.maxVarDecay) {
                    this.varDecay += 0.01;
                }
                if (this.decisionLevel() == 0) {
                    return Tristate.FALSE;
                }
                this.trailQueue.push(this.trail.size());
                if (this.conflictsRestarts > 10000 && this.lbdQueue.valid() && (double)this.trail.size() > this.factorR * (double)this.trailQueue.avg()) {
                    this.lbdQueue.fastClear();
                    if (!blocked) {
                        blocked = true;
                    }
                }
                learntClause.clear();
                selectors.clear();
                this.analyze(confl, learntClause, selectors);
                this.lbdQueue.push(this.analyzeLBD);
                this.sumLBD += (double)this.analyzeLBD;
                this.cancelUntil(this.analyzeBtLevel);
                if (this.analyzeBtLevel < this.selectionOrder.size()) {
                    this.selectionOrderIdx = this.analyzeBtLevel;
                }
                if (this.config.proofGeneration) {
                    LNGIntVector vec = new LNGIntVector(learntClause.size() + 1);
                    vec.push(1);
                    for (int i = 0; i < learntClause.size(); ++i) {
                        vec.push((GlucoseSyrup.var(learntClause.get(i)) + 1) * (-2 * (GlucoseSyrup.sign(learntClause.get(i)) ? 1 : 0) + 1));
                    }
                    this.pgProof.push(vec);
                }
                if (learntClause.size() == 1) {
                    this.uncheckedEnqueue(learntClause.get(0), null);
                } else {
                    MSClause cr = new MSClause(learntClause, true);
                    cr.setLBD(this.analyzeLBD);
                    cr.setOneWatched(false);
                    cr.setSizeWithoutSelectors(this.analyzeSzWithoutSelectors);
                    this.learnts.push(cr);
                    this.attachClause(cr);
                    this.claBumpActivity(cr);
                    this.uncheckedEnqueue(learntClause.get(0), cr);
                }
                this.varDecayActivity();
                this.claDecayActivity();
                continue;
            }
            if (this.lbdQueue.valid() && (double)this.lbdQueue.avg() * this.factorK > this.sumLBD / (double)this.conflictsRestarts) {
                this.lbdQueue.fastClear();
                int bt = 0;
                if (this.incremental) {
                    bt = Math.min(this.decisionLevel(), this.assumptions.size());
                }
                this.cancelUntil(bt);
                return Tristate.UNDEF;
            }
            if (this.decisionLevel() == 0 && !this.simplify()) {
                return Tristate.FALSE;
            }
            if (this.conflicts >= this.curRestart * this.nbclausesbeforereduce && this.learnts.size() > 0) {
                this.curRestart = this.conflicts / this.nbclausesbeforereduce + 1;
                this.reduceDB();
                this.nbclausesbeforereduce += this.incReduceDB;
            }
            int next = -1;
            while (this.decisionLevel() < this.assumptions.size()) {
                int p = this.assumptions.get(this.decisionLevel());
                if (this.value(p) == Tristate.TRUE) {
                    this.trailLim.push(this.trail.size());
                    continue;
                }
                if (this.value(p) == Tristate.FALSE) {
                    this.analyzeFinal(GlucoseSyrup.not(p), this.conflict);
                    return Tristate.FALSE;
                }
                next = p;
                break;
            }
            if (next == -1 && (next = this.pickBranchLit()) == -1) {
                return Tristate.TRUE;
            }
            this.trailLim.push(this.trail.size());
            this.uncheckedEnqueue(next, null);
        }
    }

    protected void analyze(MSClause conflictClause, LNGIntVector outLearnt, LNGIntVector selectors) {
        MSClause c = conflictClause;
        int pathC = 0;
        int p = -1;
        outLearnt.push(-1);
        int index = this.trail.size() - 1;
        do {
            int j;
            long nblevels;
            assert (c != null);
            if (p != -1 && c.size() == 2 && this.value(c.get(0)) == Tristate.FALSE) {
                assert (this.value(c.get(1)) == Tristate.TRUE);
                int tmp = c.get(0);
                c.set(0, c.get(1));
                c.set(1, tmp);
            }
            if (c.learnt()) {
                this.claBumpActivity(c);
            } else if (!c.seen()) {
                c.setSeen(true);
            }
            if (c.learnt() && c.lbd() > 2L && (nblevels = this.computeLBD(c)) + 1L < c.lbd()) {
                if (c.lbd() <= (long)this.lbLBDFrozenClause) {
                    c.setCanBeDel(false);
                }
                c.setLBD(nblevels);
            }
            int n = j = p == -1 ? 0 : 1;
            while (j < c.size()) {
                int q = c.get(j);
                if (!this.seen.get(GlucoseSyrup.var(q)) && this.v(q).level() != 0) {
                    if (!this.isSelector(GlucoseSyrup.var(q))) {
                        this.varBumpActivity(GlucoseSyrup.var(q));
                    }
                    this.seen.set(GlucoseSyrup.var(q), true);
                    if (this.v(q).level() >= this.decisionLevel()) {
                        ++pathC;
                        if (!this.isSelector(GlucoseSyrup.var(q)) && this.v(q).reason() != null && this.v(q).reason().learnt()) {
                            this.lastDecisionLevel.push(q);
                        }
                    } else if (this.isSelector(GlucoseSyrup.var(q))) {
                        assert (this.value(q) == Tristate.FALSE);
                        selectors.push(q);
                    } else {
                        outLearnt.push(q);
                    }
                }
                ++j;
            }
            while (!this.seen.get(GlucoseSyrup.var(this.trail.get(index--)))) {
            }
            p = this.trail.get(index + 1);
            c = this.v(p).reason();
            this.seen.set(GlucoseSyrup.var(p), false);
        } while (--pathC > 0);
        outLearnt.set(0, GlucoseSyrup.not(p));
        this.simplifyClause(outLearnt, selectors);
    }

    protected void simplifyClause(LNGIntVector outLearnt, LNGIntVector selectors) {
        int m;
        int k;
        int j;
        int i;
        for (i = 0; i < selectors.size(); ++i) {
            outLearnt.push(selectors.get(i));
        }
        this.analyzeToClear = new LNGIntVector(outLearnt);
        if (this.ccminMode == MiniSatConfig.ClauseMinimization.DEEP) {
            int abstractLevel = 0;
            for (i = 1; i < outLearnt.size(); ++i) {
                abstractLevel |= this.abstractLevel(GlucoseSyrup.var(outLearnt.get(i)));
            }
            j = 1;
            for (i = 1; i < outLearnt.size(); ++i) {
                if (this.v(outLearnt.get(i)).reason() != null && this.litRedundant(outLearnt.get(i), abstractLevel)) continue;
                outLearnt.set(j++, outLearnt.get(i));
            }
        } else if (this.ccminMode == MiniSatConfig.ClauseMinimization.BASIC) {
            j = 1;
            block3: for (i = 1; i < outLearnt.size(); ++i) {
                int k2;
                MSVariable v = this.v(outLearnt.get(i));
                if (v.reason() == null) {
                    outLearnt.set(j++, outLearnt.get(i));
                    continue;
                }
                MSClause c = this.v(outLearnt.get(i)).reason();
                int n = k2 = c.size() == 2 ? 0 : 1;
                while (k2 < c.size()) {
                    if (!this.seen.get(GlucoseSyrup.var(c.get(k2))) && this.v(c.get(k2)).level() > 0) {
                        outLearnt.set(j++, outLearnt.get(i));
                        continue block3;
                    }
                    ++k2;
                }
            }
        } else {
            i = j = outLearnt.size();
        }
        outLearnt.removeElements(i - j);
        if (!this.incremental && outLearnt.size() <= this.lbSizeMinimizingClause) {
            this.minimisationWithBinaryResolution(outLearnt);
        }
        this.analyzeBtLevel = 0;
        if (outLearnt.size() > 1) {
            int max = 1;
            for (int k3 = 2; k3 < outLearnt.size(); ++k3) {
                if (this.v(outLearnt.get(k3)).level() <= this.v(outLearnt.get(max)).level()) continue;
                max = k3;
            }
            int p = outLearnt.get(max);
            outLearnt.set(max, outLearnt.get(1));
            outLearnt.set(1, p);
            this.analyzeBtLevel = this.v(p).level();
        }
        this.analyzeSzWithoutSelectors = 0;
        if (this.incremental) {
            for (k = 0; k < outLearnt.size(); ++k) {
                if (!this.isSelector(GlucoseSyrup.var(outLearnt.get(k)))) {
                    ++this.analyzeSzWithoutSelectors;
                    continue;
                }
                if (k <= 0) {
                    continue;
                }
                break;
            }
        } else {
            this.analyzeSzWithoutSelectors = outLearnt.size();
        }
        this.analyzeLBD = this.computeLBD(outLearnt, outLearnt.size() - selectors.size());
        if (this.lastDecisionLevel.size() > 0) {
            for (k = 0; k < this.lastDecisionLevel.size(); ++k) {
                if (this.v(this.lastDecisionLevel.get(k)).reason().lbd() >= this.analyzeLBD) continue;
                this.varBumpActivity(GlucoseSyrup.var(this.lastDecisionLevel.get(k)));
            }
            this.lastDecisionLevel.clear();
        }
        for (m = 0; m < this.analyzeToClear.size(); ++m) {
            this.seen.set(GlucoseSyrup.var(this.analyzeToClear.get(m)), false);
        }
        for (m = 0; m < selectors.size(); ++m) {
            this.seen.set(GlucoseSyrup.var(selectors.get(m)), false);
        }
    }

    @Override
    protected boolean isRotatable(int lit) {
        if (!super.isRotatable(lit)) {
            return false;
        }
        for (MSWatcher watcher : this.watchesBin.get(GlucoseSyrup.not(lit))) {
            if (!this.isUnit(lit, watcher.clause())) continue;
            return false;
        }
        return true;
    }
}

