/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.solvers.sat;

import org.logicng.configurations.Configuration;
import org.logicng.configurations.ConfigurationType;

public final class GlucoseConfig
extends Configuration {
    final int lbLBDMinimizingClause;
    final int lbLBDFrozenClause;
    final int lbSizeMinimizingClause;
    final int firstReduceDB;
    final int specialIncReduceDB;
    final int incReduceDB;
    final double factorK;
    final double factorR;
    final int sizeLBDQueue;
    final int sizeTrailQueue;
    final boolean reduceOnSize;
    final int reduceOnSizeSize;
    final double maxVarDecay;

    private GlucoseConfig(Builder builder) {
        super(ConfigurationType.GLUCOSE);
        this.lbLBDMinimizingClause = builder.lbLBDMinimizingClause;
        this.lbLBDFrozenClause = builder.lbLBDFrozenClause;
        this.lbSizeMinimizingClause = builder.lbSizeMinimizingClause;
        this.firstReduceDB = builder.firstReduceDB;
        this.specialIncReduceDB = builder.specialIncReduceDB;
        this.incReduceDB = builder.incReduceDB;
        this.factorK = builder.factorK;
        this.factorR = builder.factorR;
        this.sizeLBDQueue = builder.sizeLBDQueue;
        this.sizeTrailQueue = builder.sizeTrailQueue;
        this.reduceOnSize = builder.reduceOnSize;
        this.reduceOnSizeSize = builder.reduceOnSizeSize;
        this.maxVarDecay = builder.maxVarDecay;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GlucoseConfig{").append(System.lineSeparator());
        sb.append("lbLBDMinimizingClause=").append(this.lbLBDMinimizingClause).append(System.lineSeparator());
        sb.append("lbLBDFrozenClause=").append(this.lbLBDFrozenClause).append(System.lineSeparator());
        sb.append("lbSizeMinimizingClause=").append(this.lbSizeMinimizingClause).append(System.lineSeparator());
        sb.append("firstReduceDB=").append(this.firstReduceDB).append(System.lineSeparator());
        sb.append("specialIncReduceDB=").append(this.specialIncReduceDB).append(System.lineSeparator());
        sb.append("incReduceDB=").append(this.incReduceDB).append(System.lineSeparator());
        sb.append("factorK=").append(this.factorK).append(System.lineSeparator());
        sb.append("factorR=").append(this.factorR).append(System.lineSeparator());
        sb.append("sizeLBDQueue=").append(this.sizeLBDQueue).append(System.lineSeparator());
        sb.append("sizeTrailQueue=").append(this.sizeTrailQueue).append(System.lineSeparator());
        sb.append("reduceOnSize=").append(this.reduceOnSize).append(System.lineSeparator());
        sb.append("reduceOnSizeSize=").append(this.reduceOnSizeSize).append(System.lineSeparator());
        sb.append("maxVarDecay=").append(this.maxVarDecay).append(System.lineSeparator());
        sb.append("}");
        return sb.toString();
    }

    public static class Builder {
        private int lbLBDMinimizingClause = 6;
        private int lbLBDFrozenClause = 30;
        private int lbSizeMinimizingClause = 30;
        private int firstReduceDB = 2000;
        private int specialIncReduceDB = 1000;
        private int incReduceDB = 300;
        private double factorK = 0.8;
        private double factorR = 1.4;
        private int sizeLBDQueue = 50;
        private int sizeTrailQueue = 5000;
        private boolean reduceOnSize = false;
        private int reduceOnSizeSize = 12;
        private double maxVarDecay = 0.95;

        private Builder() {
        }

        public Builder lbLBDMinimizingClause(int lbLBDMinimizingClause) {
            this.lbLBDMinimizingClause = lbLBDMinimizingClause;
            return this;
        }

        public Builder lbLBDFrozenClause(int lbLBDFrozenClause) {
            this.lbLBDFrozenClause = lbLBDFrozenClause;
            return this;
        }

        public Builder lbSizeMinimizingClause(int lbSizeMinimizingClause) {
            this.lbSizeMinimizingClause = lbSizeMinimizingClause;
            return this;
        }

        public Builder firstReduceDB(int firstReduceDB) {
            this.firstReduceDB = firstReduceDB;
            return this;
        }

        public Builder specialIncReduceDB(int specialIncReduceDB) {
            this.specialIncReduceDB = specialIncReduceDB;
            return this;
        }

        public Builder incReduceDB(int incReduceDB) {
            this.incReduceDB = incReduceDB;
            return this;
        }

        public Builder factorK(double factorK) {
            this.factorK = factorK;
            return this;
        }

        public Builder factorR(double factorR) {
            this.factorR = factorR;
            return this;
        }

        public Builder sizeLBDQueue(int sizeLBDQueue) {
            this.sizeLBDQueue = sizeLBDQueue;
            return this;
        }

        public Builder sizeTrailQueue(int sizeTrailQueue) {
            this.sizeTrailQueue = sizeTrailQueue;
            return this;
        }

        public Builder reduceOnSize(boolean reduceOnSize) {
            this.reduceOnSize = reduceOnSize;
            return this;
        }

        public Builder reduceOnSizeSize(int reduceOnSizeSize) {
            this.reduceOnSizeSize = reduceOnSizeSize;
            return this;
        }

        public Builder maxVarDecay(double maxVarDecay) {
            this.maxVarDecay = maxVarDecay;
            return this;
        }

        public GlucoseConfig build() {
            return new GlucoseConfig(this);
        }
    }
}

