/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.solvers.maxsat.encodings;

import org.logicng.collections.LNGIntVector;
import org.logicng.collections.LNGVector;
import org.logicng.solvers.maxsat.algorithms.MaxSAT;
import org.logicng.solvers.maxsat.algorithms.MaxSATConfig;
import org.logicng.solvers.maxsat.encodings.Encoding;
import org.logicng.solvers.sat.MiniSatStyleSolver;

public class Totalizer
extends Encoding {
    protected final LNGVector<LNGIntVector> totalizerIterativeLeft;
    protected final LNGVector<LNGIntVector> totalizerIterativeRight;
    protected final LNGVector<LNGIntVector> totalizerIterativeOutput;
    protected final LNGIntVector totalizerIterativeRhs;
    protected final int blocking;
    protected final LNGIntVector cardinalityOutlits;
    protected LNGIntVector cardinalityInlits;
    protected MaxSATConfig.IncrementalStrategy incrementalStrategy;
    protected int currentCardinalityRhs = -1;
    protected boolean joinMode = false;

    Totalizer(MaxSATConfig.IncrementalStrategy strategy) {
        this.blocking = -1;
        this.incrementalStrategy = strategy;
        this.totalizerIterativeLeft = new LNGVector();
        this.totalizerIterativeRight = new LNGVector();
        this.totalizerIterativeOutput = new LNGVector();
        this.totalizerIterativeRhs = new LNGIntVector();
        this.cardinalityInlits = new LNGIntVector();
        this.cardinalityOutlits = new LNGIntVector();
    }

    public void update(MiniSatStyleSolver s, int rhs) {
        LNGIntVector assumptions = new LNGIntVector();
        this.update(s, rhs, assumptions);
    }

    boolean hasCreatedEncoding() {
        return this.hasEncoding;
    }

    public void setIncremental(MaxSATConfig.IncrementalStrategy incremental) {
        this.incrementalStrategy = incremental;
    }

    public MaxSATConfig.IncrementalStrategy incremental() {
        return this.incrementalStrategy;
    }

    void join(MiniSatStyleSolver s, LNGIntVector lits, int rhs) {
        assert (this.incrementalStrategy == MaxSATConfig.IncrementalStrategy.ITERATIVE);
        LNGIntVector leftCardinalityOutlits = new LNGIntVector(this.cardinalityOutlits);
        int oldCardinality = this.currentCardinalityRhs;
        if (lits.size() > 1) {
            this.build(s, lits, Math.min(rhs, lits.size()));
        } else {
            assert (lits.size() == 1);
            this.cardinalityOutlits.clear();
            this.cardinalityOutlits.push(lits.get(0));
        }
        LNGIntVector rightCardinalityOutlits = new LNGIntVector(this.cardinalityOutlits);
        this.cardinalityOutlits.clear();
        for (int i = 0; i < leftCardinalityOutlits.size() + rightCardinalityOutlits.size(); ++i) {
            int p = MiniSatStyleSolver.mkLit(s.nVars(), false);
            MaxSAT.newSATVariable(s);
            this.cardinalityOutlits.push(p);
        }
        this.currentCardinalityRhs = rhs;
        this.adder(s, leftCardinalityOutlits, rightCardinalityOutlits, this.cardinalityOutlits);
        this.currentCardinalityRhs = oldCardinality;
    }

    public void update(MiniSatStyleSolver s, int rhs, LNGIntVector assumptions) {
        assert (this.hasEncoding);
        switch (this.incrementalStrategy) {
            case NONE: {
                for (int i = rhs; i < this.cardinalityOutlits.size(); ++i) {
                    this.addUnitClause(s, MiniSatStyleSolver.not(this.cardinalityOutlits.get(i)));
                }
                break;
            }
            case ITERATIVE: {
                this.incremental(s, rhs);
                assumptions.clear();
                for (int i = rhs; i < this.cardinalityOutlits.size(); ++i) {
                    assumptions.push(MiniSatStyleSolver.not(this.cardinalityOutlits.get(i)));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknown incremental strategy: " + (Object)((Object)this.incrementalStrategy));
            }
        }
    }

    public void build(MiniSatStyleSolver s, LNGIntVector lits, int rhs) {
        this.cardinalityOutlits.clear();
        this.hasEncoding = false;
        if (rhs == 0) {
            for (int i = 0; i < lits.size(); ++i) {
                this.addUnitClause(s, MiniSatStyleSolver.not(lits.get(i)));
            }
            return;
        }
        assert (rhs >= 1 && rhs <= lits.size());
        if (this.incrementalStrategy == MaxSATConfig.IncrementalStrategy.NONE && rhs == lits.size()) {
            return;
        }
        if (rhs == lits.size() && !this.joinMode) {
            return;
        }
        for (int i = 0; i < lits.size(); ++i) {
            int p = MiniSatStyleSolver.mkLit(s.nVars(), false);
            MaxSAT.newSATVariable(s);
            this.cardinalityOutlits.push(p);
        }
        this.cardinalityInlits = new LNGIntVector(lits);
        this.currentCardinalityRhs = rhs;
        this.toCNF(s, this.cardinalityOutlits);
        assert (this.cardinalityInlits.size() == 0);
        if (!this.joinMode) {
            this.joinMode = true;
        }
        this.hasEncoding = true;
    }

    protected void toCNF(MiniSatStyleSolver s, LNGIntVector lits) {
        LNGIntVector left = new LNGIntVector();
        LNGIntVector right = new LNGIntVector();
        assert (lits.size() > 1);
        int split = lits.size() / 2;
        for (int i = 0; i < lits.size(); ++i) {
            int p;
            if (i < split) {
                if (split == 1) {
                    assert (this.cardinalityInlits.size() > 0);
                    left.push(this.cardinalityInlits.back());
                    this.cardinalityInlits.pop();
                    continue;
                }
                p = MiniSatStyleSolver.mkLit(s.nVars(), false);
                MaxSAT.newSATVariable(s);
                left.push(p);
                continue;
            }
            if (lits.size() - split == 1) {
                assert (this.cardinalityInlits.size() > 0);
                right.push(this.cardinalityInlits.back());
                this.cardinalityInlits.pop();
                continue;
            }
            p = MiniSatStyleSolver.mkLit(s.nVars(), false);
            MaxSAT.newSATVariable(s);
            right.push(p);
        }
        this.adder(s, left, right, lits);
        if (left.size() > 1) {
            this.toCNF(s, left);
        }
        if (right.size() > 1) {
            this.toCNF(s, right);
        }
    }

    protected void adder(MiniSatStyleSolver s, LNGIntVector left, LNGIntVector right, LNGIntVector output) {
        assert (output.size() == left.size() + right.size());
        if (this.incrementalStrategy == MaxSATConfig.IncrementalStrategy.ITERATIVE) {
            this.totalizerIterativeLeft.push(new LNGIntVector(left));
            this.totalizerIterativeRight.push(new LNGIntVector(right));
            this.totalizerIterativeOutput.push(new LNGIntVector(output));
            this.totalizerIterativeRhs.push(this.currentCardinalityRhs);
        }
        for (int i = 0; i <= left.size(); ++i) {
            for (int j = 0; j <= right.size(); ++j) {
                if (i == 0 && j == 0 || i + j > this.currentCardinalityRhs + 1) continue;
                if (i == 0) {
                    this.addBinaryClause(s, MiniSatStyleSolver.not(right.get(j - 1)), output.get(j - 1), this.blocking);
                    continue;
                }
                if (j == 0) {
                    this.addBinaryClause(s, MiniSatStyleSolver.not(left.get(i - 1)), output.get(i - 1), this.blocking);
                    continue;
                }
                this.addTernaryClause(s, MiniSatStyleSolver.not(left.get(i - 1)), MiniSatStyleSolver.not(right.get(j - 1)), output.get(i + j - 1), this.blocking);
            }
        }
    }

    protected void incremental(MiniSatStyleSolver s, int rhs) {
        for (int z = 0; z < this.totalizerIterativeRhs.size(); ++z) {
            for (int i = 0; i <= this.totalizerIterativeLeft.get(z).size(); ++i) {
                for (int j = 0; j <= this.totalizerIterativeRight.get(z).size(); ++j) {
                    if (i == 0 && j == 0 || i + j > rhs + 1 || i + j <= this.totalizerIterativeRhs.get(z) + 1) continue;
                    if (i == 0) {
                        this.addBinaryClause(s, MiniSatStyleSolver.not(this.totalizerIterativeRight.get(z).get(j - 1)), this.totalizerIterativeOutput.get(z).get(j - 1));
                        continue;
                    }
                    if (j == 0) {
                        this.addBinaryClause(s, MiniSatStyleSolver.not(this.totalizerIterativeLeft.get(z).get(i - 1)), this.totalizerIterativeOutput.get(z).get(i - 1));
                        continue;
                    }
                    this.addTernaryClause(s, MiniSatStyleSolver.not(this.totalizerIterativeLeft.get(z).get(i - 1)), MiniSatStyleSolver.not(this.totalizerIterativeRight.get(z).get(j - 1)), this.totalizerIterativeOutput.get(z).get(i + j - 1));
                }
            }
            this.totalizerIterativeRhs.set(z, rhs);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

