/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.solvers.maxsat.encodings;

import org.logicng.collections.LNGIntVector;
import org.logicng.collections.LNGVector;
import org.logicng.solvers.maxsat.algorithms.MaxSAT;
import org.logicng.solvers.maxsat.encodings.Encoding;
import org.logicng.solvers.sat.MiniSatStyleSolver;

public class SequentialWeightCounter
extends Encoding {
    protected final LNGIntVector pbOutlits = new LNGIntVector();
    protected final LNGIntVector unitLits = new LNGIntVector();
    protected final LNGIntVector unitCoeffs = new LNGIntVector();
    protected int currentPbRhs = -1;
    protected int currentLitBlocking = -1;
    protected LNGVector<LNGIntVector> seqAuxiliaryInc = new LNGVector();
    protected LNGIntVector litsInc = new LNGIntVector();
    protected LNGIntVector coeffsInc = new LNGIntVector();

    SequentialWeightCounter() {
    }

    void updateAssumptions(LNGIntVector assumptions) {
        assumptions.push(MiniSatStyleSolver.not(this.currentLitBlocking));
        for (int i = 0; i < this.unitLits.size(); ++i) {
            assumptions.push(MiniSatStyleSolver.not(this.unitLits.get(i)));
        }
    }

    boolean hasCreatedEncoding() {
        return this.hasEncoding;
    }

    public void encode(MiniSatStyleSolver s, LNGIntVector lits, LNGIntVector coeffs, int rhs) {
        int i;
        if (rhs == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Overflow in the encoding.");
        }
        this.hasEncoding = false;
        LNGIntVector simpLits = new LNGIntVector(lits);
        LNGIntVector simpCoeffs = new LNGIntVector(coeffs);
        lits.clear();
        coeffs.clear();
        for (int i2 = 0; i2 < simpLits.size(); ++i2) {
            if (simpCoeffs.get(i2) <= rhs) {
                lits.push(simpLits.get(i2));
                coeffs.push(simpCoeffs.get(i2));
                continue;
            }
            this.addUnitClause(s, MiniSatStyleSolver.not(simpLits.get(i2)));
        }
        if (lits.size() == 1) {
            this.addUnitClause(s, MiniSatStyleSolver.not(lits.get(0)));
            return;
        }
        if (lits.size() == 0) {
            return;
        }
        int n = lits.size();
        LNGIntVector[] seqAuxiliary = new LNGIntVector[n + 1];
        for (i = 0; i < n + 1; ++i) {
            seqAuxiliary[i] = new LNGIntVector();
            seqAuxiliary[i].growTo(rhs + 1, -1);
        }
        for (i = 1; i <= n; ++i) {
            for (int j = 1; j <= rhs; ++j) {
                seqAuxiliary[i].set(j, MiniSatStyleSolver.mkLit(s.nVars(), false));
                MaxSAT.newSATVariable(s);
            }
        }
        for (i = 1; i <= rhs; ++i) {
            this.pbOutlits.push(seqAuxiliary[n].get(i));
        }
        for (i = 1; i <= n; ++i) {
            int wi = coeffs.get(i - 1);
            assert (wi <= rhs);
            for (int j = 1; j <= rhs; ++j) {
                if (i >= 2 && i <= n && j <= rhs) {
                    this.addBinaryClause(s, MiniSatStyleSolver.not(seqAuxiliary[i - 1].get(j)), seqAuxiliary[i].get(j));
                }
                if (i <= n && j <= wi) {
                    this.addBinaryClause(s, MiniSatStyleSolver.not(lits.get(i - 1)), seqAuxiliary[i].get(j));
                }
                if (i < 2 || i > n || j > rhs - wi) continue;
                this.addTernaryClause(s, MiniSatStyleSolver.not(seqAuxiliary[i - 1].get(j)), MiniSatStyleSolver.not(lits.get(i - 1)), seqAuxiliary[i].get(j + wi));
            }
            if (i < 2) continue;
            this.addBinaryClause(s, MiniSatStyleSolver.not(seqAuxiliary[i - 1].get(rhs + 1 - wi)), MiniSatStyleSolver.not(lits.get(i - 1)));
        }
        this.currentPbRhs = rhs;
        this.hasEncoding = true;
    }

    public void encode(MiniSatStyleSolver s, LNGIntVector lits, LNGIntVector coeffs, int rhs, LNGIntVector assumptions, int size) {
        int i;
        int i2;
        int i3;
        if (rhs == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Overflow in the encoding.");
        }
        this.hasEncoding = false;
        LNGIntVector simpLits = new LNGIntVector(lits);
        LNGIntVector simpCoeffs = new LNGIntVector(coeffs);
        lits.clear();
        coeffs.clear();
        LNGIntVector simpUnitLits = new LNGIntVector(this.unitLits);
        LNGIntVector simpUnitCoeffs = new LNGIntVector(this.unitCoeffs);
        this.unitLits.clear();
        this.unitCoeffs.clear();
        for (i3 = 0; i3 < simpUnitLits.size(); ++i3) {
            if (simpUnitCoeffs.get(i3) <= rhs) {
                lits.push(simpUnitLits.get(i3));
                coeffs.push(simpUnitCoeffs.get(i3));
                continue;
            }
            this.unitLits.push(simpUnitLits.get(i3));
            this.unitCoeffs.push(simpUnitCoeffs.get(i3));
        }
        for (i3 = 0; i3 < simpLits.size(); ++i3) {
            if (simpCoeffs.get(i3) <= rhs) {
                lits.push(simpLits.get(i3));
                coeffs.push(simpCoeffs.get(i3));
                continue;
            }
            this.unitLits.push(simpLits.get(i3));
            this.unitCoeffs.push(simpCoeffs.get(i3));
        }
        if (lits.size() == 1) {
            for (i3 = 0; i3 < this.unitLits.size(); ++i3) {
                assumptions.push(MiniSatStyleSolver.not(this.unitLits.get(i3)));
            }
            this.unitLits.push(lits.get(0));
            this.unitCoeffs.push(coeffs.get(0));
            return;
        }
        if (lits.size() == 0) {
            for (i3 = 0; i3 < this.unitLits.size(); ++i3) {
                assumptions.push(MiniSatStyleSolver.not(this.unitLits.get(i3)));
            }
            return;
        }
        int n = lits.size();
        this.seqAuxiliaryInc = new LNGVector(size + 1);
        for (i2 = 0; i2 <= n; ++i2) {
            this.seqAuxiliaryInc.set(i2, new LNGIntVector());
            this.seqAuxiliaryInc.get(i2).growTo(rhs + 1, -1);
        }
        for (i2 = 1; i2 <= n; ++i2) {
            for (int j = 1; j <= rhs; ++j) {
                this.seqAuxiliaryInc.get(i2).set(j, MiniSatStyleSolver.mkLit(s.nVars(), false));
                MaxSAT.newSATVariable(s);
            }
        }
        int blocking = MiniSatStyleSolver.mkLit(s.nVars(), false);
        MaxSAT.newSATVariable(s);
        this.currentLitBlocking = blocking;
        assumptions.push(MiniSatStyleSolver.not(blocking));
        for (i = 1; i <= n; ++i) {
            int wi = coeffs.get(i - 1);
            assert (rhs >= wi);
            for (int j = 1; j <= rhs; ++j) {
                if (i >= 2 && i <= n && j <= rhs) {
                    this.addBinaryClause(s, MiniSatStyleSolver.not(this.seqAuxiliaryInc.get(i - 1).get(j)), this.seqAuxiliaryInc.get(i).get(j));
                }
                if (i <= n && j <= wi) {
                    this.addBinaryClause(s, MiniSatStyleSolver.not(lits.get(i - 1)), this.seqAuxiliaryInc.get(i).get(j));
                }
                if (i < 2 || i > n || j > rhs - wi) continue;
                this.addTernaryClause(s, MiniSatStyleSolver.not(this.seqAuxiliaryInc.get(i - 1).get(j)), MiniSatStyleSolver.not(lits.get(i - 1)), this.seqAuxiliaryInc.get(i).get(j + wi));
            }
            if (i < 2) continue;
            this.addBinaryClause(s, MiniSatStyleSolver.not(this.seqAuxiliaryInc.get(i - 1).get(rhs + 1 - wi)), MiniSatStyleSolver.not(lits.get(i - 1)), blocking);
        }
        for (i = 0; i < this.unitLits.size(); ++i) {
            assumptions.push(MiniSatStyleSolver.not(this.unitLits.get(i)));
        }
        this.currentPbRhs = rhs;
        this.hasEncoding = true;
        this.litsInc = new LNGIntVector(lits);
        this.coeffsInc = new LNGIntVector(coeffs);
    }

    public void update(MiniSatStyleSolver s, int rhs) {
        assert (this.currentPbRhs != -1);
        for (int i = rhs; i < this.currentPbRhs; ++i) {
            this.addUnitClause(s, MiniSatStyleSolver.not(this.pbOutlits.get(i)));
        }
        this.currentPbRhs = rhs;
    }

    public void updateInc(MiniSatStyleSolver s, int rhs) {
        int j;
        int i;
        if (this.currentLitBlocking != -1) {
            this.addUnitClause(s, this.currentLitBlocking);
        }
        int n = this.litsInc.size();
        int offset = this.currentPbRhs + 1;
        assert (this.currentPbRhs < rhs);
        for (i = 1; i <= n; ++i) {
            for (j = offset; j <= rhs; ++j) {
                this.seqAuxiliaryInc.get(i).push(-1);
            }
        }
        for (i = 1; i <= n; ++i) {
            for (j = offset; j <= rhs; ++j) {
                assert (this.seqAuxiliaryInc.get(i).size() > j);
                this.seqAuxiliaryInc.get(i).set(j, MiniSatStyleSolver.mkLit(s.nVars(), false));
                MaxSAT.newSATVariable(s);
            }
        }
        for (i = 1; i < this.litsInc.size(); ++i) {
            assert (this.seqAuxiliaryInc.get(i).size() == rhs + 1);
        }
        this.currentLitBlocking = MiniSatStyleSolver.mkLit(s.nVars(), false);
        MaxSAT.newSATVariable(s);
        for (i = 1; i <= n; ++i) {
            int wi = this.coeffsInc.get(i - 1);
            assert (wi > 0);
            assert (rhs >= wi);
            for (int j2 = 1; j2 <= rhs; ++j2) {
                if (i >= 2 && i <= n && j2 <= rhs && j2 >= offset) {
                    assert (this.seqAuxiliaryInc.get(i).size() > j2);
                    this.addBinaryClause(s, MiniSatStyleSolver.not(this.seqAuxiliaryInc.get(i - 1).get(j2)), this.seqAuxiliaryInc.get(i).get(j2));
                }
                if (i < 2 || i > n || j2 > rhs - wi || j2 < offset - wi) continue;
                this.addTernaryClause(s, MiniSatStyleSolver.not(this.seqAuxiliaryInc.get(i - 1).get(j2)), MiniSatStyleSolver.not(this.litsInc.get(i - 1)), this.seqAuxiliaryInc.get(i).get(j2 + wi));
            }
            if (i < 2) continue;
            assert (this.seqAuxiliaryInc.get(i - 1).size() > rhs + 1 - wi);
            assert (rhs + 1 - wi > 0);
            assert (i - 1 < this.litsInc.size());
            this.addBinaryClause(s, MiniSatStyleSolver.not(this.seqAuxiliaryInc.get(i - 1).get(rhs + 1 - wi)), MiniSatStyleSolver.not(this.litsInc.get(i - 1)), this.currentLitBlocking);
        }
        this.currentPbRhs = rhs;
    }

    void join(MiniSatStyleSolver s, LNGIntVector lits, LNGIntVector coeffs) {
        int i;
        int i2;
        assert (this.currentLitBlocking != -1);
        int rhs = this.currentPbRhs;
        if (rhs == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Overflow in the encoding.");
        }
        LNGIntVector simpUnitLits = new LNGIntVector(this.unitLits);
        LNGIntVector simpUnitCoeffs = new LNGIntVector(this.unitCoeffs);
        this.unitLits.clear();
        this.unitCoeffs.clear();
        int lhsJoin = this.litsInc.size();
        for (i2 = 0; i2 < simpUnitLits.size(); ++i2) {
            if (simpUnitCoeffs.get(i2) <= rhs) {
                this.litsInc.push(simpUnitLits.get(i2));
                this.coeffsInc.push(simpUnitCoeffs.get(i2));
                continue;
            }
            this.unitLits.push(simpUnitLits.get(i2));
            this.unitCoeffs.push(simpUnitCoeffs.get(i2));
        }
        for (i2 = 0; i2 < lits.size(); ++i2) {
            if (coeffs.get(i2) <= rhs) {
                this.litsInc.push(lits.get(i2));
                this.coeffsInc.push(coeffs.get(i2));
                continue;
            }
            this.unitLits.push(lits.get(i2));
            this.unitCoeffs.push(coeffs.get(i2));
        }
        if (this.litsInc.size() == lhsJoin) {
            return;
        }
        int n = this.litsInc.size();
        assert (this.seqAuxiliaryInc.get(lhsJoin).size() > 0);
        for (i = lhsJoin + 1; i <= n; ++i) {
            this.seqAuxiliaryInc.set(i, new LNGIntVector());
            this.seqAuxiliaryInc.get(i).growTo(rhs + 1, -1);
        }
        for (i = lhsJoin + 1; i <= n; ++i) {
            for (int j = 1; j <= rhs; ++j) {
                this.seqAuxiliaryInc.get(i).set(j, MiniSatStyleSolver.mkLit(s.nVars(), false));
                MaxSAT.newSATVariable(s);
            }
        }
        for (i = 1; i <= n; ++i) {
            assert (this.seqAuxiliaryInc.get(i).size() == rhs + 1);
        }
        for (i = lhsJoin; i <= n; ++i) {
            int wi = this.coeffsInc.get(i - 1);
            assert (wi > 0);
            assert (wi <= rhs);
            for (int j = 1; j <= rhs; ++j) {
                assert (this.seqAuxiliaryInc.get(i).size() > j);
                assert (this.seqAuxiliaryInc.get(i - 1).size() > j);
                this.addBinaryClause(s, MiniSatStyleSolver.not(this.seqAuxiliaryInc.get(i - 1).get(j)), this.seqAuxiliaryInc.get(i).get(j));
                if (j <= wi) {
                    assert (this.seqAuxiliaryInc.get(i).size() > j);
                    assert (i - 1 < this.litsInc.size() && i - 1 >= 0);
                    this.addBinaryClause(s, MiniSatStyleSolver.not(this.litsInc.get(i - 1)), this.seqAuxiliaryInc.get(i).get(j));
                }
                if (j > rhs - wi) continue;
                this.addTernaryClause(s, MiniSatStyleSolver.not(this.seqAuxiliaryInc.get(i - 1).get(j)), MiniSatStyleSolver.not(this.litsInc.get(i - 1)), this.seqAuxiliaryInc.get(i).get(j + wi));
            }
            if (i <= lhsJoin) continue;
            assert (rhs + 1 - wi >= 0);
            assert (this.seqAuxiliaryInc.get(i - 1).size() > rhs + 1 - wi);
            assert (i - 1 < this.litsInc.size());
            this.addBinaryClause(s, MiniSatStyleSolver.not(this.seqAuxiliaryInc.get(i - 1).get(rhs + 1 - wi)), MiniSatStyleSolver.not(this.litsInc.get(i - 1)), this.currentLitBlocking);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

