/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.solvers.maxsat.encodings;

import org.logicng.collections.LNGIntVector;
import org.logicng.solvers.maxsat.algorithms.MaxSAT;
import org.logicng.solvers.maxsat.encodings.Encoding;
import org.logicng.solvers.sat.MiniSatStyleSolver;

public class ModularTotalizer
extends Encoding {
    protected static final int LIT_ERROR = -2;
    protected final int h0;
    protected final LNGIntVector cardinalityUpoutlits;
    protected final LNGIntVector cardinalityLwoutlits;
    protected int modulo = -1;
    protected LNGIntVector cardinalityInlits = new LNGIntVector();
    protected int currentCardinalityRhs = -1;

    ModularTotalizer() {
        this.h0 = -1;
        this.cardinalityUpoutlits = new LNGIntVector();
        this.cardinalityLwoutlits = new LNGIntVector();
    }

    void setModulo(int m) {
        this.modulo = m;
    }

    boolean hasCreatedEncoding() {
        return this.hasEncoding;
    }

    public void encode(MiniSatStyleSolver s, LNGIntVector lits, int rhs) {
        int p;
        int i;
        assert (lits.size() > 0);
        this.hasEncoding = false;
        this.cardinalityUpoutlits.clear();
        this.cardinalityLwoutlits.clear();
        if (rhs == 0) {
            for (int i2 = 0; i2 < lits.size(); ++i2) {
                this.addUnitClause(s, MiniSatStyleSolver.not(lits.get(i2)));
            }
            return;
        }
        assert (rhs >= 1 && rhs <= lits.size());
        if (rhs == lits.size()) {
            return;
        }
        this.hasEncoding = true;
        int mod = (int)Math.ceil(Math.sqrt((double)rhs + 1.0));
        if (this.modulo == -1) {
            this.modulo = mod;
        } else {
            mod = this.modulo;
        }
        for (i = 0; i < lits.size() / mod; ++i) {
            p = MiniSatStyleSolver.mkLit(s.nVars(), false);
            MaxSAT.newSATVariable(s);
            this.cardinalityUpoutlits.push(p);
        }
        for (i = 0; i < mod - 1; ++i) {
            p = MiniSatStyleSolver.mkLit(s.nVars(), false);
            MaxSAT.newSATVariable(s);
            this.cardinalityLwoutlits.push(p);
        }
        this.cardinalityInlits = new LNGIntVector(lits);
        this.currentCardinalityRhs = rhs + 1;
        if (this.cardinalityUpoutlits.size() == 0) {
            this.cardinalityUpoutlits.push(this.h0);
        }
        this.toCNF(s, mod, this.cardinalityUpoutlits, this.cardinalityLwoutlits, lits.size());
        assert (this.cardinalityInlits.size() == 0);
        this.update(s, rhs);
    }

    public void update(MiniSatStyleSolver s, int rhs) {
        assert (this.currentCardinalityRhs != -1);
        assert (this.hasEncoding);
        this.encodeOutput(s, rhs);
        this.currentCardinalityRhs = rhs + 1;
    }

    protected void encodeOutput(MiniSatStyleSolver s, int rhs) {
        int i;
        assert (this.hasEncoding);
        assert (this.cardinalityUpoutlits.size() != 0 || this.cardinalityLwoutlits.size() != 0);
        int mod = this.modulo;
        int ulimit = (rhs + 1) / mod;
        int llimit = rhs + 1 - ulimit * mod;
        assert (ulimit <= this.cardinalityUpoutlits.size());
        assert (llimit <= this.cardinalityLwoutlits.size());
        for (i = ulimit; i < this.cardinalityUpoutlits.size(); ++i) {
            this.addUnitClause(s, MiniSatStyleSolver.not(this.cardinalityUpoutlits.get(i)));
        }
        if (ulimit != 0 && llimit != 0) {
            for (i = llimit - 1; i < this.cardinalityLwoutlits.size(); ++i) {
                this.addBinaryClause(s, MiniSatStyleSolver.not(this.cardinalityUpoutlits.get(ulimit - 1)), MiniSatStyleSolver.not(this.cardinalityLwoutlits.get(i)));
            }
        } else if (ulimit == 0) {
            assert (llimit != 0);
            for (i = llimit - 1; i < this.cardinalityLwoutlits.size(); ++i) {
                this.addUnitClause(s, MiniSatStyleSolver.not(this.cardinalityLwoutlits.get(i)));
            }
        } else {
            this.addUnitClause(s, MiniSatStyleSolver.not(this.cardinalityUpoutlits.get(ulimit - 1)));
        }
    }

    protected void toCNF(MiniSatStyleSolver s, int mod, LNGIntVector ublits, LNGIntVector lwlits, int rhs) {
        int p;
        int i;
        int limit;
        int p2;
        int i2;
        LNGIntVector lupper = new LNGIntVector();
        LNGIntVector llower = new LNGIntVector();
        LNGIntVector rupper = new LNGIntVector();
        LNGIntVector rlower = new LNGIntVector();
        assert (rhs > 1);
        int split = rhs / 2;
        int left = 1;
        int right = 1;
        if (split == 1) {
            assert (this.cardinalityInlits.size() > 0);
            lupper.push(this.h0);
            llower.push(this.cardinalityInlits.back());
            this.cardinalityInlits.pop();
        } else {
            left = split / mod;
            for (i2 = 0; i2 < left; ++i2) {
                p2 = MiniSatStyleSolver.mkLit(s.nVars(), false);
                MaxSAT.newSATVariable(s);
                lupper.push(p2);
            }
            limit = mod - 1;
            if (left % mod == 0 && split < mod - 1) {
                limit = split;
            }
            for (i = 0; i < limit; ++i) {
                p = MiniSatStyleSolver.mkLit(s.nVars(), false);
                MaxSAT.newSATVariable(s);
                llower.push(p);
            }
        }
        if (rhs - split == 1) {
            assert (this.cardinalityInlits.size() > 0);
            rupper.push(this.h0);
            rlower.push(this.cardinalityInlits.back());
            this.cardinalityInlits.pop();
        } else {
            right = (rhs - split) / mod;
            for (i2 = 0; i2 < right; ++i2) {
                p2 = MiniSatStyleSolver.mkLit(s.nVars(), false);
                MaxSAT.newSATVariable(s);
                rupper.push(p2);
            }
            limit = mod - 1;
            if (right % mod == 0 && rhs - split < mod - 1) {
                limit = rhs - split;
            }
            for (i = 0; i < limit; ++i) {
                p = MiniSatStyleSolver.mkLit(s.nVars(), false);
                MaxSAT.newSATVariable(s);
                rlower.push(p);
            }
        }
        if (lupper.size() == 0) {
            lupper.push(this.h0);
        }
        if (rupper.size() == 0) {
            rupper.push(this.h0);
        }
        this.adder(s, mod, ublits, lwlits, rupper, rlower, lupper, llower);
        if (left * mod + split - left * mod > 1) {
            this.toCNF(s, mod, lupper, llower, left * mod + split - left * mod);
        }
        if (right * mod + (rhs - split) - right * mod > 1) {
            this.toCNF(s, mod, rupper, rlower, right * mod + (rhs - split) - right * mod);
        }
    }

    protected void adder(MiniSatStyleSolver s, int mod, LNGIntVector upper, LNGIntVector lower, LNGIntVector lupper, LNGIntVector llower, LNGIntVector rupper, LNGIntVector rlower) {
        int j;
        int i;
        assert (upper.size() != 0);
        assert (lower.size() >= llower.size() && lower.size() >= rlower.size());
        int carry = -1;
        if (upper.get(0) != this.h0) {
            carry = MiniSatStyleSolver.mkLit(s.nVars(), false);
            MaxSAT.newSATVariable(s);
        }
        for (i = 0; i <= llower.size(); ++i) {
            for (j = 0; j <= rlower.size(); ++j) {
                if (i + j > this.currentCardinalityRhs + 1 && this.currentCardinalityRhs + 1 < this.modulo) continue;
                if (i + j < mod) {
                    if (i == 0 && j != 0) {
                        if (upper.get(0) != this.h0) {
                            this.addTernaryClause(s, MiniSatStyleSolver.not(rlower.get(j - 1)), lower.get(i + j - 1), carry);
                            continue;
                        }
                        this.addBinaryClause(s, MiniSatStyleSolver.not(rlower.get(j - 1)), lower.get(i + j - 1));
                        continue;
                    }
                    if (j == 0 && i != 0) {
                        if (upper.get(0) != this.h0) {
                            this.addTernaryClause(s, MiniSatStyleSolver.not(llower.get(i - 1)), lower.get(i + j - 1), carry);
                            continue;
                        }
                        this.addBinaryClause(s, MiniSatStyleSolver.not(llower.get(i - 1)), lower.get(i + j - 1));
                        continue;
                    }
                    if (i == 0) continue;
                    if (upper.get(0) != this.h0) {
                        this.addQuaternaryClause(s, MiniSatStyleSolver.not(llower.get(i - 1)), MiniSatStyleSolver.not(rlower.get(j - 1)), lower.get(i + j - 1), carry);
                        continue;
                    }
                    assert (i + j - 1 < lower.size());
                    this.addTernaryClause(s, MiniSatStyleSolver.not(llower.get(i - 1)), MiniSatStyleSolver.not(rlower.get(j - 1)), lower.get(i + j - 1));
                    continue;
                }
                if (i + j > mod) {
                    assert (i + j > 0);
                    this.addTernaryClause(s, MiniSatStyleSolver.not(llower.get(i - 1)), MiniSatStyleSolver.not(rlower.get(j - 1)), lower.get((i + j) % mod - 1));
                    continue;
                }
                assert (i + j == mod);
                assert (carry != -1);
                this.addTernaryClause(s, MiniSatStyleSolver.not(llower.get(i - 1)), MiniSatStyleSolver.not(rlower.get(j - 1)), carry);
            }
        }
        if (upper.get(0) != this.h0) {
            for (i = 0; i <= lupper.size(); ++i) {
                for (j = 0; j <= rupper.size(); ++j) {
                    LNGIntVector clause;
                    int a = -2;
                    int b = -2;
                    int c = -2;
                    int d = -2;
                    int closeMod = this.currentCardinalityRhs / mod;
                    if (this.currentCardinalityRhs % mod != 0) {
                        ++closeMod;
                    }
                    if (mod * (i + j) > closeMod * mod) continue;
                    if (i != 0) {
                        a = lupper.get(i - 1);
                    }
                    if (j != 0) {
                        b = rupper.get(j - 1);
                    }
                    if (i + j != 0 && i + j - 1 < upper.size()) {
                        c = upper.get(i + j - 1);
                    }
                    if (i + j < upper.size()) {
                        d = upper.get(i + j);
                    }
                    if (c != -1 && c != -2) {
                        clause = new LNGIntVector();
                        if (a != -1 && a != -2) {
                            clause.push(MiniSatStyleSolver.not(a));
                        }
                        if (b != -1 && b != -2) {
                            clause.push(MiniSatStyleSolver.not(b));
                        }
                        clause.push(c);
                        if (clause.size() > 1) {
                            s.addClause(clause, null);
                        }
                    }
                    clause = new LNGIntVector();
                    clause.push(MiniSatStyleSolver.not(carry));
                    if (a != -1 && a != -2) {
                        clause.push(MiniSatStyleSolver.not(a));
                    }
                    if (b != -1 && b != -2) {
                        clause.push(MiniSatStyleSolver.not(b));
                    }
                    if (d != -2 && d != -1) {
                        clause.push(d);
                    }
                    if (clause.size() <= 1) continue;
                    s.addClause(clause, null);
                }
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

