/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.solvers.maxsat.encodings;

import org.logicng.collections.LNGIntVector;
import org.logicng.solvers.maxsat.algorithms.MaxSAT;
import org.logicng.solvers.maxsat.encodings.Encoding;
import org.logicng.solvers.sat.MiniSatStyleSolver;

public class Ladder
extends Encoding {
    public void encode(MiniSatStyleSolver s, LNGIntVector lits) {
        assert (lits.size() != 0);
        if (lits.size() == 1) {
            this.addUnitClause(s, lits.get(0));
        } else {
            int i;
            LNGIntVector seqAuxiliary = new LNGIntVector();
            for (i = 0; i < lits.size() - 1; ++i) {
                seqAuxiliary.push(MiniSatStyleSolver.mkLit(s.nVars(), false));
                MaxSAT.newSATVariable(s);
            }
            for (i = 0; i < lits.size(); ++i) {
                if (i == 0) {
                    this.addBinaryClause(s, lits.get(i), MiniSatStyleSolver.not(seqAuxiliary.get(i)));
                    this.addBinaryClause(s, MiniSatStyleSolver.not(lits.get(i)), seqAuxiliary.get(i));
                    continue;
                }
                if (i == lits.size() - 1) {
                    this.addBinaryClause(s, lits.get(i), seqAuxiliary.get(i - 1));
                    this.addBinaryClause(s, MiniSatStyleSolver.not(lits.get(i)), MiniSatStyleSolver.not(seqAuxiliary.get(i - 1)));
                    continue;
                }
                this.addBinaryClause(s, MiniSatStyleSolver.not(seqAuxiliary.get(i - 1)), seqAuxiliary.get(i));
                this.addTernaryClause(s, lits.get(i), MiniSatStyleSolver.not(seqAuxiliary.get(i)), seqAuxiliary.get(i - 1));
                this.addBinaryClause(s, MiniSatStyleSolver.not(lits.get(i)), seqAuxiliary.get(i));
                this.addBinaryClause(s, MiniSatStyleSolver.not(lits.get(i)), MiniSatStyleSolver.not(seqAuxiliary.get(i - 1)));
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

