/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.solvers.maxsat.encodings;

import org.logicng.collections.LNGIntVector;
import org.logicng.solvers.sat.MiniSatStyleSolver;

public abstract class Encoding {
    protected final LNGIntVector clause = new LNGIntVector();
    boolean hasEncoding;

    Encoding() {
    }

    void addUnitClause(MiniSatStyleSolver s, int a) {
        this.addUnitClause(s, a, -1);
    }

    private void addUnitClause(MiniSatStyleSolver s, int a, int blocking) {
        assert (this.clause.size() == 0);
        assert (a != -1);
        assert (MiniSatStyleSolver.var(a) < s.nVars());
        this.clause.push(a);
        if (blocking != -1) {
            this.clause.push(blocking);
        }
        s.addClause(this.clause, null);
        this.clause.clear();
    }

    void addBinaryClause(MiniSatStyleSolver s, int a, int b) {
        this.addBinaryClause(s, a, b, -1);
    }

    void addBinaryClause(MiniSatStyleSolver s, int a, int b, int blocking) {
        assert (this.clause.size() == 0);
        assert (a != -1 && b != -1);
        assert (MiniSatStyleSolver.var(a) < s.nVars() && MiniSatStyleSolver.var(b) < s.nVars());
        this.clause.push(a);
        this.clause.push(b);
        if (blocking != -1) {
            this.clause.push(blocking);
        }
        s.addClause(this.clause, null);
        this.clause.clear();
    }

    void addTernaryClause(MiniSatStyleSolver s, int a, int b, int c) {
        this.addTernaryClause(s, a, b, c, -1);
    }

    void addTernaryClause(MiniSatStyleSolver s, int a, int b, int c, int blocking) {
        assert (this.clause.size() == 0);
        assert (a != -1 && b != -1 && c != -1);
        assert (MiniSatStyleSolver.var(a) < s.nVars() && MiniSatStyleSolver.var(b) < s.nVars() && MiniSatStyleSolver.var(c) < s.nVars());
        this.clause.push(a);
        this.clause.push(b);
        this.clause.push(c);
        if (blocking != -1) {
            this.clause.push(blocking);
        }
        s.addClause(this.clause, null);
        this.clause.clear();
    }

    void addQuaternaryClause(MiniSatStyleSolver s, int a, int b, int c, int d) {
        this.addQuaternaryClause(s, a, b, c, d, -1);
    }

    private void addQuaternaryClause(MiniSatStyleSolver s, int a, int b, int c, int d, int blocking) {
        assert (this.clause.size() == 0);
        assert (a != -1 && b != -1 && c != -1 && d != -1);
        assert (MiniSatStyleSolver.var(a) < s.nVars() && MiniSatStyleSolver.var(b) < s.nVars() && MiniSatStyleSolver.var(c) < s.nVars() && MiniSatStyleSolver.var(d) < s.nVars());
        this.clause.push(a);
        this.clause.push(b);
        this.clause.push(c);
        this.clause.push(d);
        if (blocking != -1) {
            this.clause.push(blocking);
        }
        s.addClause(this.clause, null);
        this.clause.clear();
    }
}

