/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.solvers.maxsat.encodings;

import org.logicng.collections.LNGIntVector;
import org.logicng.solvers.maxsat.algorithms.MaxSATConfig;
import org.logicng.solvers.maxsat.encodings.Ladder;
import org.logicng.solvers.maxsat.encodings.ModularTotalizer;
import org.logicng.solvers.maxsat.encodings.SequentialWeightCounter;
import org.logicng.solvers.maxsat.encodings.Totalizer;
import org.logicng.solvers.sat.MiniSatStyleSolver;

public class Encoder {
    protected final MaxSATConfig.CardinalityEncoding cardinalityEncoding;
    protected final Ladder ladder;
    protected final ModularTotalizer mtotalizer;
    protected final Totalizer totalizer;
    protected final SequentialWeightCounter swc;
    protected MaxSATConfig.IncrementalStrategy incrementalStrategy;
    protected MaxSATConfig.PBEncoding pbEncoding;
    protected MaxSATConfig.AMOEncoding amoEncoding;

    public Encoder(MaxSATConfig.CardinalityEncoding cardinality) {
        this(MaxSATConfig.IncrementalStrategy.NONE, cardinality, MaxSATConfig.AMOEncoding.LADDER, MaxSATConfig.PBEncoding.SWC);
    }

    protected Encoder(MaxSATConfig.IncrementalStrategy incremental, MaxSATConfig.CardinalityEncoding cardinality, MaxSATConfig.AMOEncoding amo, MaxSATConfig.PBEncoding pb) {
        this.incrementalStrategy = incremental;
        this.cardinalityEncoding = cardinality;
        this.amoEncoding = amo;
        this.pbEncoding = pb;
        this.ladder = new Ladder();
        this.totalizer = new Totalizer(incremental);
        this.mtotalizer = new ModularTotalizer();
        this.swc = new SequentialWeightCounter();
    }

    public MaxSATConfig.CardinalityEncoding cardEncoding() {
        return this.cardinalityEncoding;
    }

    public void setPBEncoding(MaxSATConfig.PBEncoding enc) {
        this.pbEncoding = enc;
    }

    public void setAMOEncoding(MaxSATConfig.AMOEncoding enc) {
        this.amoEncoding = enc;
    }

    public void setModulo(int m) {
        this.mtotalizer.setModulo(m);
    }

    public void setIncremental(MaxSATConfig.IncrementalStrategy incremental) {
        this.incrementalStrategy = incremental;
        this.totalizer.setIncremental(incremental);
    }

    public void encodeAMO(MiniSatStyleSolver s, LNGIntVector lits) {
        switch (this.amoEncoding) {
            case LADDER: {
                this.ladder.encode(s, lits);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown AMO encoding: " + (Object)((Object)this.amoEncoding));
            }
        }
    }

    public void encodeCardinality(MiniSatStyleSolver s, LNGIntVector lits, int rhs) {
        switch (this.cardinalityEncoding) {
            case TOTALIZER: {
                this.totalizer.build(s, lits, rhs);
                if (!this.totalizer.hasCreatedEncoding()) break;
                this.totalizer.update(s, rhs);
                break;
            }
            case MTOTALIZER: {
                this.mtotalizer.encode(s, lits, rhs);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown cardinality encoding: " + (Object)((Object)this.cardinalityEncoding));
            }
        }
    }

    public void updateCardinality(MiniSatStyleSolver s, int rhs) {
        switch (this.cardinalityEncoding) {
            case TOTALIZER: {
                this.totalizer.update(s, rhs);
                break;
            }
            case MTOTALIZER: {
                this.mtotalizer.update(s, rhs);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown cardinality encoding: " + (Object)((Object)this.cardinalityEncoding));
            }
        }
    }

    public void buildCardinality(MiniSatStyleSolver s, LNGIntVector lits, int rhs) {
        assert (this.incrementalStrategy != MaxSATConfig.IncrementalStrategy.NONE);
        switch (this.cardinalityEncoding) {
            case TOTALIZER: {
                this.totalizer.build(s, lits, rhs);
                break;
            }
            default: {
                throw new IllegalStateException("Cardinality encoding does not support incrementality: " + (Object)((Object)this.incrementalStrategy));
            }
        }
    }

    public void incUpdateCardinality(MiniSatStyleSolver s, LNGIntVector join, LNGIntVector lits, int rhs, LNGIntVector assumptions) {
        assert (this.incrementalStrategy == MaxSATConfig.IncrementalStrategy.ITERATIVE);
        switch (this.cardinalityEncoding) {
            case TOTALIZER: {
                if (join.size() > 0) {
                    this.totalizer.join(s, join, rhs);
                }
                assert (lits.size() > 0);
                this.totalizer.update(s, rhs, assumptions);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cardinality encoding does not support incrementality: " + (Object)((Object)this.incrementalStrategy));
            }
        }
    }

    public void encodePB(MiniSatStyleSolver s, LNGIntVector lits, LNGIntVector coeffs, int rhs) {
        switch (this.pbEncoding) {
            case SWC: {
                this.swc.encode(s, lits, coeffs, rhs);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown pseudo-Boolean encoding: " + (Object)((Object)this.pbEncoding));
            }
        }
    }

    public void updatePB(MiniSatStyleSolver s, int rhs) {
        switch (this.pbEncoding) {
            case SWC: {
                this.swc.update(s, rhs);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown pseudo-Boolean encoding: " + (Object)((Object)this.pbEncoding));
            }
        }
    }

    public void incEncodePB(MiniSatStyleSolver s, LNGIntVector lits, LNGIntVector coeffs, int rhs, LNGIntVector assumptions, int size) {
        assert (this.incrementalStrategy == MaxSATConfig.IncrementalStrategy.ITERATIVE);
        switch (this.pbEncoding) {
            case SWC: {
                this.swc.encode(s, lits, coeffs, rhs, assumptions, size);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown pseudo-Boolean encoding: " + (Object)((Object)this.pbEncoding));
            }
        }
    }

    public void incUpdatePB(MiniSatStyleSolver s, LNGIntVector lits, LNGIntVector coeffs, int rhs) {
        assert (this.incrementalStrategy == MaxSATConfig.IncrementalStrategy.ITERATIVE);
        switch (this.pbEncoding) {
            case SWC: {
                this.swc.updateInc(s, rhs);
                this.swc.join(s, lits, coeffs);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown pseudo-Boolean encoding: " + (Object)((Object)this.pbEncoding));
            }
        }
    }

    public void incUpdatePBAssumptions(LNGIntVector assumptions) {
        assert (this.incrementalStrategy == MaxSATConfig.IncrementalStrategy.ITERATIVE);
        switch (this.pbEncoding) {
            case SWC: {
                this.swc.updateAssumptions(assumptions);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown pseudo-Boolean encoding: " + (Object)((Object)this.pbEncoding));
            }
        }
    }

    public boolean hasCardEncoding() {
        switch (this.cardinalityEncoding) {
            case TOTALIZER: {
                return this.totalizer.hasCreatedEncoding();
            }
            case MTOTALIZER: {
                return this.mtotalizer.hasCreatedEncoding();
            }
        }
        throw new IllegalStateException("Unknown cardinality encoding: " + (Object)((Object)this.cardinalityEncoding));
    }

    public boolean hasPBEncoding() {
        return this.pbEncoding == MaxSATConfig.PBEncoding.SWC && this.swc.hasCreatedEncoding();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

