/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.solvers.maxsat.algorithms;

import java.io.PrintStream;
import java.util.SortedMap;
import java.util.TreeMap;
import org.logicng.collections.LNGBooleanVector;
import org.logicng.collections.LNGIntVector;
import org.logicng.collections.LNGVector;
import org.logicng.datastructures.Tristate;
import org.logicng.solvers.datastructures.MSHardClause;
import org.logicng.solvers.datastructures.MSSoftClause;
import org.logicng.solvers.maxsat.algorithms.MaxSAT;
import org.logicng.solvers.maxsat.algorithms.MaxSATConfig;
import org.logicng.solvers.maxsat.encodings.Encoder;
import org.logicng.solvers.sat.MiniSatStyleSolver;

public class WMSU3
extends MaxSAT {
    final boolean bmoStrategy;
    protected final Encoder encoder;
    protected final MaxSATConfig.IncrementalStrategy incrementalStrategy;
    protected final LNGIntVector assumptions;
    protected final LNGIntVector objFunction;
    protected final LNGIntVector coeffs;
    protected final SortedMap<Integer, Integer> coreMapping;
    protected final LNGBooleanVector activeSoft;
    protected final PrintStream output;
    boolean isBmo;
    protected MiniSatStyleSolver solver = null;

    public WMSU3() {
        this(MaxSATConfig.builder().incremental(MaxSATConfig.IncrementalStrategy.ITERATIVE).build());
    }

    public WMSU3(MaxSATConfig config) {
        super(config);
        this.verbosity = config.verbosity;
        this.incrementalStrategy = config.incrementalStrategy;
        this.encoder = new Encoder(config.cardinalityEncoding);
        this.encoder.setPBEncoding(config.pbEncoding);
        this.bmoStrategy = config.bmo;
        this.isBmo = false;
        this.assumptions = new LNGIntVector();
        this.objFunction = new LNGIntVector();
        this.coeffs = new LNGIntVector();
        this.coreMapping = new TreeMap<Integer, Integer>();
        this.activeSoft = new LNGBooleanVector();
        this.output = config.output;
    }

    protected static boolean subsetSum(LNGIntVector set, int sum) {
        int i;
        int n = set.size();
        boolean[][] subset = new boolean[sum + 1][];
        for (i = 0; i <= sum; ++i) {
            subset[i] = new boolean[n + 1];
        }
        for (i = 0; i <= n; ++i) {
            subset[0][i] = true;
        }
        for (i = 1; i <= sum; ++i) {
            subset[i][0] = false;
        }
        for (i = 1; i <= sum; ++i) {
            for (int j = 1; j <= n; ++j) {
                subset[i][j] = subset[i][j - 1];
                if (i < set.get(j - 1)) continue;
                subset[i][j] = subset[i][j] || subset[i - set.get(j - 1)][j - 1];
            }
        }
        return subset[sum][n];
    }

    @Override
    public MaxSAT.MaxSATResult search() {
        if (this.problemType == MaxSAT.ProblemType.UNWEIGHTED) {
            throw new IllegalStateException("Error: Currently algorithm WMSU3 does not support unweighted MaxSAT instances.");
        }
        if (this.bmoStrategy) {
            this.isBmo = this.isBMO(true);
        }
        if (!this.isBmo) {
            this.currentWeight = 1;
        }
        switch (this.incrementalStrategy) {
            case NONE: {
                return this.none();
            }
            case ITERATIVE: {
                if (this.isBmo) {
                    if (this.encoder.cardEncoding() != MaxSATConfig.CardinalityEncoding.TOTALIZER) {
                        throw new IllegalStateException("Error: Currently iterative encoding in WMSU3 only supports the Totalizer encoding.");
                    }
                    return this.iterativeBmo();
                }
                return this.iterative();
            }
        }
        throw new IllegalArgumentException("Unknown incremental strategy: " + (Object)((Object)this.incrementalStrategy));
    }

    protected MaxSAT.MaxSATResult iterative() {
        this.nbInitialVariables = this.nVars();
        this.initRelaxation();
        this.solver = this.rebuildSolver();
        this.encoder.setIncremental(MaxSATConfig.IncrementalStrategy.ITERATIVE);
        this.activeSoft.growTo(this.nSoft(), false);
        for (int i = 0; i < this.nSoft(); ++i) {
            this.coreMapping.put(((MSSoftClause)this.softClauses.get(i)).assumptionVar(), i);
        }
        this.assumptions.clear();
        LNGIntVector fullObjFunction = new LNGIntVector();
        LNGIntVector fullCoeffsFunction = new LNGIntVector();
        block1: while (true) {
            int i;
            Tristate res = WMSU3.searchSATSolver(this.solver, this.satHandler(), this.assumptions);
            this.satSolverFinished();
            if (res == Tristate.UNDEF) {
                return MaxSAT.MaxSATResult.UNDEF;
            }
            if (res == Tristate.TRUE) {
                ++this.nbSatisfiable;
                int newCost = this.computeCostModel(this.solver.model(), Integer.MAX_VALUE);
                if (newCost < this.ubCost || this.nbSatisfiable == 1) {
                    this.saveModel(this.solver.model());
                    if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                        this.output.println("o " + newCost);
                    }
                    this.ubCost = newCost;
                }
                if (this.ubCost == 0 || this.lbCost == this.ubCost || this.currentWeight == 1 && this.nbSatisfiable > 1) {
                    assert (this.lbCost == this.ubCost);
                    assert (this.nbSatisfiable > 0);
                    return MaxSAT.MaxSATResult.OPTIMUM;
                }
                if (!this.foundUpperBound(this.ubCost, null)) {
                    return MaxSAT.MaxSATResult.UNDEF;
                }
                int i2 = 0;
                while (true) {
                    if (i2 >= this.nSoft()) continue block1;
                    if (((MSSoftClause)this.softClauses.get(i2)).weight() >= this.currentWeight && !this.activeSoft.get(i2)) {
                        this.assumptions.push(MiniSatStyleSolver.not(((MSSoftClause)this.softClauses.get(i2)).assumptionVar()));
                    }
                    ++i2;
                }
            }
            ++this.nbCores;
            if (this.nbSatisfiable == 0) {
                return MaxSAT.MaxSATResult.UNSATISFIABLE;
            }
            if (this.lbCost == this.ubCost) {
                assert (this.nbSatisfiable > 0);
                if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                    this.output.println("c LB = UB");
                }
                return MaxSAT.MaxSATResult.OPTIMUM;
            }
            if (!this.foundLowerBound(this.lbCost, null)) {
                return MaxSAT.MaxSATResult.UNDEF;
            }
            this.sumSizeCores += (long)this.solver.conflict().size();
            this.objFunction.clear();
            this.coeffs.clear();
            this.assumptions.clear();
            for (i = 0; i < this.solver.conflict().size(); ++i) {
                int indexSoft;
                if (!this.coreMapping.containsKey(this.solver.conflict().get(i)) || this.activeSoft.get(indexSoft = ((Integer)this.coreMapping.get(this.solver.conflict().get(i))).intValue())) continue;
                this.activeSoft.set(indexSoft, true);
                this.objFunction.push(((MSSoftClause)this.softClauses.get(indexSoft)).relaxationVars().get(0));
                this.coeffs.push(((MSSoftClause)this.softClauses.get(indexSoft)).weight());
            }
            for (i = 0; i < this.nSoft(); ++i) {
                if (this.activeSoft.get(i) || ((MSSoftClause)this.softClauses.get(i)).weight() < this.currentWeight) continue;
                this.assumptions.push(MiniSatStyleSolver.not(((MSSoftClause)this.softClauses.get(i)).assumptionVar()));
            }
            for (i = 0; i < this.coeffs.size(); ++i) {
                fullCoeffsFunction.push(this.coeffs.get(i));
                fullObjFunction.push(this.objFunction.get(i));
            }
            if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                this.output.println(String.format("c Relaxed soft clauses %d / %d", fullCoeffsFunction.size(), this.nSoft()));
            }
            ++this.lbCost;
            while (!WMSU3.subsetSum(fullCoeffsFunction, this.lbCost)) {
                ++this.lbCost;
            }
            if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                this.output.println("c LB : " + this.lbCost);
            }
            if (!this.encoder.hasPBEncoding()) {
                this.encoder.incEncodePB(this.solver, this.objFunction, this.coeffs, this.lbCost, this.assumptions, this.nSoft());
                continue;
            }
            this.encoder.incUpdatePB(this.solver, this.objFunction, this.coeffs, this.lbCost);
            this.encoder.incUpdatePBAssumptions(this.assumptions);
        }
    }

    protected MaxSAT.MaxSATResult none() {
        int i;
        this.nbInitialVariables = this.nVars();
        this.initRelaxation();
        this.solver = this.rebuildSolver();
        this.encoder.setIncremental(MaxSATConfig.IncrementalStrategy.NONE);
        this.activeSoft.growTo(this.nSoft(), false);
        for (i = 0; i < this.nSoft(); ++i) {
            this.coreMapping.put(((MSSoftClause)this.softClauses.get(i)).assumptionVar(), i);
        }
        this.assumptions.clear();
        block1: while (true) {
            Tristate res = WMSU3.searchSATSolver(this.solver, this.satHandler(), this.assumptions);
            this.satSolverFinished();
            if (res == Tristate.UNDEF) {
                return MaxSAT.MaxSATResult.UNDEF;
            }
            if (res == Tristate.TRUE) {
                ++this.nbSatisfiable;
                int newCost = this.computeCostModel(this.solver.model(), Integer.MAX_VALUE);
                if (newCost < this.ubCost || this.nbSatisfiable == 1) {
                    this.saveModel(this.solver.model());
                    if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                        this.output.println("o " + newCost);
                    }
                    this.ubCost = newCost;
                }
                if (this.ubCost == 0 || this.lbCost == this.ubCost || this.currentWeight == 1 && this.nbSatisfiable > 1) {
                    assert (this.nbSatisfiable > 0);
                    return MaxSAT.MaxSATResult.OPTIMUM;
                }
                if (!this.foundUpperBound(this.ubCost, null)) {
                    return MaxSAT.MaxSATResult.UNDEF;
                }
                int i2 = 0;
                while (true) {
                    if (i2 >= this.nSoft()) continue block1;
                    if (((MSSoftClause)this.softClauses.get(i2)).weight() >= this.currentWeight && !this.activeSoft.get(i2)) {
                        this.assumptions.push(MiniSatStyleSolver.not(((MSSoftClause)this.softClauses.get(i2)).assumptionVar()));
                    }
                    ++i2;
                }
            }
            ++this.nbCores;
            if (this.nbSatisfiable == 0) {
                return MaxSAT.MaxSATResult.UNSATISFIABLE;
            }
            if (this.lbCost == this.ubCost) {
                assert (this.nbSatisfiable > 0);
                if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                    this.output.println("c LB = UB");
                }
                return MaxSAT.MaxSATResult.OPTIMUM;
            }
            if (!this.foundLowerBound(this.lbCost, null)) {
                return MaxSAT.MaxSATResult.UNDEF;
            }
            this.sumSizeCores += (long)this.solver.conflict().size();
            for (i = 0; i < this.solver.conflict().size(); ++i) {
                int indexSoft = (Integer)this.coreMapping.get(this.solver.conflict().get(i));
                assert (!this.activeSoft.get(indexSoft));
                this.activeSoft.set(indexSoft, true);
            }
            this.objFunction.clear();
            this.coeffs.clear();
            this.assumptions.clear();
            for (i = 0; i < this.nSoft(); ++i) {
                if (this.activeSoft.get(i)) {
                    this.objFunction.push(((MSSoftClause)this.softClauses.get(i)).relaxationVars().get(0));
                    this.coeffs.push(((MSSoftClause)this.softClauses.get(i)).weight());
                    continue;
                }
                if (((MSSoftClause)this.softClauses.get(i)).weight() < this.currentWeight) continue;
                this.assumptions.push(MiniSatStyleSolver.not(((MSSoftClause)this.softClauses.get(i)).assumptionVar()));
            }
            if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                this.output.println(String.format("c Relaxed soft clauses %d / %d", this.objFunction.size(), this.nSoft()));
            }
            this.solver = this.rebuildSolver();
            ++this.lbCost;
            while (!WMSU3.subsetSum(this.coeffs, this.lbCost)) {
                ++this.lbCost;
            }
            if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                this.output.println("c LB : " + this.lbCost);
            }
            this.encoder.encodePB(this.solver, this.objFunction, this.coeffs, this.lbCost);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected MaxSAT.MaxSATResult iterativeBmo() {
        if (!WMSU3.$assertionsDisabled && !this.isBmo) {
            throw new AssertionError();
        }
        this.nbInitialVariables = this.nVars();
        this.initRelaxation();
        this.solver = this.rebuildSolver();
        this.encoder.setIncremental(MaxSATConfig.IncrementalStrategy.ITERATIVE);
        joinObjFunction = new LNGIntVector();
        encodingAssumptions = new LNGIntVector();
        joinCoeffs = new LNGIntVector();
        this.activeSoft.growTo(this.nSoft(), false);
        for (i = 0; i < this.nSoft(); ++i) {
            this.coreMapping.put(((MSSoftClause)this.softClauses.get(i)).assumptionVar(), i);
        }
        minWeight = 0;
        posWeight = 0;
        localCost = 0;
        functions = new LNGVector<LNGIntVector>();
        weights = new LNGIntVector();
        bmoEncodings = new LNGVector<Encoder>();
        firstEncoding = new LNGBooleanVector();
        functions.push(new LNGIntVector());
        weights.push(0);
        if (!WMSU3.$assertionsDisabled && this.objFunction.size() != 0) {
            throw new AssertionError();
        }
        e = new Encoder(MaxSATConfig.CardinalityEncoding.TOTALIZER);
        e.setIncremental(MaxSATConfig.IncrementalStrategy.ITERATIVE);
        bmoEncodings.push(e);
        firstEncoding.push(true);
        block1: while (true) {
            res = WMSU3.searchSATSolver(this.solver, this.satHandler(), this.assumptions);
            this.satSolverFinished();
            if (res == Tristate.UNDEF) {
                return MaxSAT.MaxSATResult.UNDEF;
            }
            if (res == Tristate.TRUE) {
                ++this.nbSatisfiable;
                newCost = this.computeCostModel(this.solver.model(), 0x7FFFFFFF);
                if (newCost < this.ubCost || this.nbSatisfiable == 1) {
                    this.saveModel(this.solver.model());
                    if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                        this.output.println("o " + newCost);
                    }
                    this.ubCost = newCost;
                }
                if (this.nbSatisfiable == 1) {
                    if (this.ubCost == 0) {
                        return MaxSAT.MaxSATResult.OPTIMUM;
                    }
                    if (!this.foundUpperBound(this.ubCost, null)) {
                        return MaxSAT.MaxSATResult.UNDEF;
                    }
                    if (!WMSU3.$assertionsDisabled && this.orderWeights.size() <= 0) {
                        throw new AssertionError();
                    }
                    if (!WMSU3.$assertionsDisabled && this.orderWeights.get(0) <= 1) {
                        throw new AssertionError();
                    }
                    minWeight = this.orderWeights.get(this.orderWeights.size() - 1);
                    this.currentWeight = this.orderWeights.get(0);
                    i = 0;
                    while (true) {
                        if (i >= this.nSoft()) continue block1;
                        if (((MSSoftClause)this.softClauses.get(i)).weight() >= this.currentWeight) {
                            this.assumptions.push(MiniSatStyleSolver.not(((MSSoftClause)this.softClauses.get(i)).assumptionVar()));
                        }
                        ++i;
                    }
                }
                if (this.currentWeight == 1 || this.currentWeight == minWeight) {
                    return MaxSAT.MaxSATResult.OPTIMUM;
                }
                if (!this.foundUpperBound(this.ubCost, null)) {
                    return MaxSAT.MaxSATResult.UNDEF;
                }
                this.assumptions.clear();
                previousWeight = this.currentWeight;
                if (!WMSU3.$assertionsDisabled && ++posWeight >= this.orderWeights.size()) {
                    throw new AssertionError();
                }
                this.currentWeight = this.orderWeights.get(posWeight);
                if (this.objFunction.size() > 0) {
                    functions.set(functions.size() - 1, new LNGIntVector(this.objFunction));
                }
                functions.push(new LNGIntVector());
                weights.push(0);
                localCost = 0;
                e = new Encoder(MaxSATConfig.CardinalityEncoding.TOTALIZER);
                e.setIncremental(MaxSATConfig.IncrementalStrategy.ITERATIVE);
                bmoEncodings.push(e);
                firstEncoding.push(true);
                for (i = 0; i < encodingAssumptions.size(); ++i) {
                    this.solver.addClause(encodingAssumptions.get(i), null);
                }
                encodingAssumptions.clear();
                i = 0;
                while (true) {
                    if (i >= this.nSoft()) continue block1;
                    if (!this.activeSoft.get(i) && previousWeight == ((MSSoftClause)this.softClauses.get(i)).weight()) {
                        this.solver.addClause(MiniSatStyleSolver.not(((MSSoftClause)this.softClauses.get(i)).assumptionVar()), null);
                    }
                    if (this.currentWeight == ((MSSoftClause)this.softClauses.get(i)).weight()) {
                        this.assumptions.push(MiniSatStyleSolver.not(((MSSoftClause)this.softClauses.get(i)).assumptionVar()));
                    }
                    if (this.activeSoft.get(i)) {
                        if (!WMSU3.$assertionsDisabled && ((MSSoftClause)this.softClauses.get(i)).weight() != previousWeight) {
                            throw new AssertionError();
                        }
                        this.activeSoft.set(i, false);
                    }
                    ++i;
                }
            }
            ++localCost;
            this.lbCost += this.currentWeight;
            ++this.nbCores;
            if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                this.output.println("c LB : " + this.lbCost);
            }
            if (this.nbSatisfiable == 0) {
                return MaxSAT.MaxSATResult.UNSATISFIABLE;
            }
            if (this.lbCost == this.ubCost) {
                if (!WMSU3.$assertionsDisabled && this.nbSatisfiable <= 0) {
                    throw new AssertionError();
                }
                if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                    this.output.println("c LB = UB");
                }
                return MaxSAT.MaxSATResult.OPTIMUM;
            }
            if (!this.foundLowerBound(this.lbCost, null)) {
                return MaxSAT.MaxSATResult.UNDEF;
            }
            this.sumSizeCores += (long)this.solver.conflict().size();
            joinObjFunction.clear();
            joinCoeffs.clear();
            for (i = 0; i < this.solver.conflict().size(); ++i) {
                if (!this.coreMapping.containsKey(this.solver.conflict().get(i)) || this.activeSoft.get((Integer)this.coreMapping.get(this.solver.conflict().get(i)))) continue;
                if (!WMSU3.$assertionsDisabled && ((MSSoftClause)this.softClauses.get((Integer)this.coreMapping.get(this.solver.conflict().get(i)))).weight() != this.currentWeight) {
                    throw new AssertionError();
                }
                this.activeSoft.set((Integer)this.coreMapping.get(this.solver.conflict().get(i)), true);
                joinObjFunction.push(((MSSoftClause)this.softClauses.get((Integer)this.coreMapping.get(this.solver.conflict().get(i)))).relaxationVars().get(0));
                joinCoeffs.push(((MSSoftClause)this.softClauses.get((Integer)this.coreMapping.get(this.solver.conflict().get(i)))).weight());
            }
            this.objFunction.clear();
            this.coeffs.clear();
            this.assumptions.clear();
            for (i = 0; i < this.nSoft(); ++i) {
                if (this.activeSoft.get(i)) {
                    if (!WMSU3.$assertionsDisabled && ((MSSoftClause)this.softClauses.get(i)).weight() != this.currentWeight) {
                        throw new AssertionError();
                    }
                    this.objFunction.push(((MSSoftClause)this.softClauses.get(i)).relaxationVars().get(0));
                    this.coeffs.push(((MSSoftClause)this.softClauses.get(i)).weight());
                    continue;
                }
                if (this.currentWeight != ((MSSoftClause)this.softClauses.get(i)).weight()) continue;
                this.assumptions.push(MiniSatStyleSolver.not(((MSSoftClause)this.softClauses.get(i)).assumptionVar()));
            }
            if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                this.output.println(String.format("c Relaxed soft clauses %d / %d", new Object[]{this.objFunction.size(), this.nSoft()}));
            }
            if (!WMSU3.$assertionsDisabled && posWeight >= functions.size()) {
                throw new AssertionError();
            }
            functions.set(posWeight, new LNGIntVector(this.objFunction));
            weights.set(posWeight, localCost);
            if (firstEncoding.get(posWeight)) {
                if (weights.get(posWeight) != this.objFunction.size()) {
                    ((Encoder)bmoEncodings.get(posWeight)).buildCardinality(this.solver, this.objFunction, weights.get(posWeight));
                    joinObjFunction.clear();
                    ((Encoder)bmoEncodings.get(posWeight)).incUpdateCardinality(this.solver, joinObjFunction, this.objFunction, weights.get(posWeight), encodingAssumptions);
                    firstEncoding.set(posWeight, false);
                }
            } else {
                ((Encoder)bmoEncodings.get(posWeight)).incUpdateCardinality(this.solver, joinObjFunction, this.objFunction, weights.get(posWeight), encodingAssumptions);
            }
            i = 0;
            while (true) {
                if (i < encodingAssumptions.size()) ** break;
                continue block1;
                this.assumptions.push(encodingAssumptions.get(i));
                ++i;
            }
            break;
        }
    }

    protected MiniSatStyleSolver rebuildSolver() {
        int i;
        MiniSatStyleSolver s = this.newSATSolver();
        for (i = 0; i < this.nVars(); ++i) {
            WMSU3.newSATVariable(s);
        }
        for (i = 0; i < this.nHard(); ++i) {
            s.addClause(((MSHardClause)this.hardClauses.get(i)).clause(), null);
        }
        for (int i2 = 0; i2 < this.nSoft(); ++i2) {
            LNGIntVector clause = new LNGIntVector(((MSSoftClause)this.softClauses.get(i2)).clause());
            for (int j = 0; j < ((MSSoftClause)this.softClauses.get(i2)).relaxationVars().size(); ++j) {
                clause.push(((MSSoftClause)this.softClauses.get(i2)).relaxationVars().get(j));
            }
            s.addClause(clause, null);
        }
        return s;
    }

    protected void initRelaxation() {
        for (int i = 0; i < this.nbSoft; ++i) {
            int l = this.newLiteral(false);
            ((MSSoftClause)this.softClauses.get(i)).relaxationVars().push(l);
            ((MSSoftClause)this.softClauses.get(i)).setAssumptionVar(l);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

