/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.solvers.maxsat.algorithms;

import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.logicng.collections.LNGIntVector;
import org.logicng.collections.LNGVector;
import org.logicng.datastructures.Tristate;
import org.logicng.solvers.datastructures.MSHardClause;
import org.logicng.solvers.datastructures.MSSoftClause;
import org.logicng.solvers.maxsat.algorithms.MaxSAT;
import org.logicng.solvers.maxsat.algorithms.MaxSATConfig;
import org.logicng.solvers.sat.MiniSatStyleSolver;
import org.logicng.util.Pair;

public class WBO
extends MaxSAT {
    protected final PrintStream output;
    protected MiniSatStyleSolver solver = null;
    protected int nbCurrentSoft;
    protected MaxSATConfig.WeightStrategy weightStrategy;
    protected SortedMap<Integer, Integer> coreMapping;
    protected LNGIntVector assumptions;
    protected boolean symmetryStrategy;
    protected LNGIntVector indexSoftCore;
    protected LNGVector<LNGIntVector> softMapping;
    protected LNGVector<LNGIntVector> relaxationMapping;
    protected Set<Pair<Integer, Integer>> duplicatedSymmetryClauses;
    protected int symmetryBreakingLimit;

    public WBO() {
        this(MaxSATConfig.builder().build());
    }

    public WBO(MaxSATConfig config) {
        super(config);
        this.verbosity = config.verbosity;
        this.nbCurrentSoft = 0;
        this.weightStrategy = config.weightStrategy;
        this.symmetryStrategy = config.symmetry;
        this.symmetryBreakingLimit = config.limit;
        this.coreMapping = new TreeMap<Integer, Integer>();
        this.assumptions = new LNGIntVector();
        this.indexSoftCore = new LNGIntVector();
        this.softMapping = new LNGVector();
        this.relaxationMapping = new LNGVector();
        this.duplicatedSymmetryClauses = new HashSet<Pair<Integer, Integer>>();
        this.output = config.output;
    }

    @Override
    public MaxSAT.MaxSATResult search() {
        this.nbInitialVariables = this.nVars();
        if (this.currentWeight == 1) {
            this.problemType = MaxSAT.ProblemType.UNWEIGHTED;
            this.weightStrategy = MaxSATConfig.WeightStrategy.NONE;
        }
        if (this.symmetryStrategy) {
            this.initSymmetry();
        }
        if (this.problemType == MaxSAT.ProblemType.UNWEIGHTED || this.weightStrategy == MaxSATConfig.WeightStrategy.NONE) {
            return this.normalSearch();
        }
        if (this.weightStrategy == MaxSATConfig.WeightStrategy.NORMAL || this.weightStrategy == MaxSATConfig.WeightStrategy.DIVERSIFY) {
            return this.weightSearch();
        }
        throw new IllegalArgumentException("Unknown problem type.");
    }

    protected MiniSatStyleSolver rebuildWeightSolver(MaxSATConfig.WeightStrategy strategy) {
        int i;
        assert (strategy == MaxSATConfig.WeightStrategy.NORMAL || strategy == MaxSATConfig.WeightStrategy.DIVERSIFY);
        MiniSatStyleSolver s = this.newSATSolver();
        for (i = 0; i < this.nVars(); ++i) {
            WBO.newSATVariable(s);
        }
        for (i = 0; i < this.nHard(); ++i) {
            s.addClause(((MSHardClause)this.hardClauses.get(i)).clause(), null);
        }
        if (this.symmetryStrategy) {
            this.symmetryBreaking();
        }
        LNGIntVector clause = new LNGIntVector();
        this.nbCurrentSoft = 0;
        for (int i2 = 0; i2 < this.nSoft(); ++i2) {
            if (((MSSoftClause)this.softClauses.get(i2)).weight() < this.currentWeight) continue;
            ++this.nbCurrentSoft;
            clause.clear();
            clause = new LNGIntVector(((MSSoftClause)this.softClauses.get(i2)).clause());
            for (int j = 0; j < ((MSSoftClause)this.softClauses.get(i2)).relaxationVars().size(); ++j) {
                clause.push(((MSSoftClause)this.softClauses.get(i2)).relaxationVars().get(j));
            }
            clause.push(((MSSoftClause)this.softClauses.get(i2)).assumptionVar());
            s.addClause(clause, null);
        }
        return s;
    }

    MiniSatStyleSolver rebuildSolver() {
        int i;
        assert (this.weightStrategy == MaxSATConfig.WeightStrategy.NONE);
        MiniSatStyleSolver s = this.newSATSolver();
        for (i = 0; i < this.nVars(); ++i) {
            WBO.newSATVariable(s);
        }
        for (i = 0; i < this.nHard(); ++i) {
            s.addClause(((MSHardClause)this.hardClauses.get(i)).clause(), null);
        }
        if (this.symmetryStrategy) {
            this.symmetryBreaking();
        }
        for (int i2 = 0; i2 < this.nSoft(); ++i2) {
            LNGIntVector clause = new LNGIntVector(((MSSoftClause)this.softClauses.get(i2)).clause());
            for (int j = 0; j < ((MSSoftClause)this.softClauses.get(i2)).relaxationVars().size(); ++j) {
                clause.push(((MSSoftClause)this.softClauses.get(i2)).relaxationVars().get(j));
            }
            clause.push(((MSSoftClause)this.softClauses.get(i2)).assumptionVar());
            s.addClause(clause, null);
        }
        return s;
    }

    protected MiniSatStyleSolver rebuildHardSolver() {
        int i;
        MiniSatStyleSolver s = this.newSATSolver();
        for (i = 0; i < this.nVars(); ++i) {
            WBO.newSATVariable(s);
        }
        for (i = 0; i < this.nHard(); ++i) {
            s.addClause(((MSHardClause)this.hardClauses.get(i)).clause(), null);
        }
        return s;
    }

    void updateCurrentWeight(MaxSATConfig.WeightStrategy strategy) {
        assert (strategy == MaxSATConfig.WeightStrategy.NORMAL || strategy == MaxSATConfig.WeightStrategy.DIVERSIFY);
        if (strategy == MaxSATConfig.WeightStrategy.NORMAL) {
            this.currentWeight = this.findNextWeight(this.currentWeight);
        } else if (strategy == MaxSATConfig.WeightStrategy.DIVERSIFY) {
            this.currentWeight = this.findNextWeightDiversity(this.currentWeight);
        }
    }

    protected int findNextWeight(int weight) {
        int nextWeight = 1;
        for (int i = 0; i < this.nSoft(); ++i) {
            if (((MSSoftClause)this.softClauses.get(i)).weight() <= nextWeight || ((MSSoftClause)this.softClauses.get(i)).weight() >= weight) continue;
            nextWeight = ((MSSoftClause)this.softClauses.get(i)).weight();
        }
        return nextWeight;
    }

    protected int findNextWeightDiversity(int weight) {
        assert (this.weightStrategy == MaxSATConfig.WeightStrategy.DIVERSIFY);
        assert (this.nbSatisfiable > 0);
        int nextWeight = weight;
        TreeSet<Integer> nbWeights = new TreeSet<Integer>();
        double alpha = 1.25;
        boolean findNext = false;
        while (true) {
            if (this.nbSatisfiable > 1 || findNext) {
                nextWeight = this.findNextWeight(nextWeight);
            }
            int nbClauses = 0;
            nbWeights.clear();
            for (int i = 0; i < this.nSoft(); ++i) {
                if (((MSSoftClause)this.softClauses.get(i)).weight() < nextWeight) continue;
                ++nbClauses;
                nbWeights.add(((MSSoftClause)this.softClauses.get(i)).weight());
            }
            if ((double)nbClauses / (double)nbWeights.size() > 1.25 || nbClauses == this.nSoft()) break;
            if (this.nbSatisfiable != 1 || findNext) continue;
            findNext = true;
        }
        return nextWeight;
    }

    protected void encodeEO(LNGIntVector lits) {
        assert (lits.size() != 0);
        LNGIntVector clause = new LNGIntVector();
        if (lits.size() == 1) {
            clause.push(lits.get(0));
            this.addHardClause(clause);
        } else {
            int i;
            LNGIntVector auxVariables = new LNGIntVector();
            for (i = 0; i < lits.size() - 1; ++i) {
                auxVariables.push(this.newLiteral(false));
            }
            for (i = 0; i < lits.size(); ++i) {
                if (i == 0) {
                    clause.clear();
                    clause.push(lits.get(i));
                    clause.push(MiniSatStyleSolver.not(auxVariables.get(i)));
                    this.addHardClause(clause);
                    clause.clear();
                    clause.push(MiniSatStyleSolver.not(lits.get(i)));
                    clause.push(auxVariables.get(i));
                    this.addHardClause(clause);
                    continue;
                }
                if (i == lits.size() - 1) {
                    clause.clear();
                    clause.push(lits.get(i));
                    clause.push(auxVariables.get(i - 1));
                    this.addHardClause(clause);
                    clause.clear();
                    clause.push(MiniSatStyleSolver.not(lits.get(i)));
                    clause.push(MiniSatStyleSolver.not(auxVariables.get(i - 1)));
                    this.addHardClause(clause);
                    continue;
                }
                clause.clear();
                clause.push(MiniSatStyleSolver.not(auxVariables.get(i - 1)));
                clause.push(auxVariables.get(i));
                this.addHardClause(clause);
                clause.clear();
                clause.push(lits.get(i));
                clause.push(MiniSatStyleSolver.not(auxVariables.get(i)));
                clause.push(auxVariables.get(i - 1));
                this.addHardClause(clause);
                clause.clear();
                clause.push(MiniSatStyleSolver.not(lits.get(i)));
                clause.push(auxVariables.get(i));
                this.addHardClause(clause);
                clause.clear();
                clause.push(MiniSatStyleSolver.not(lits.get(i)));
                clause.push(MiniSatStyleSolver.not(auxVariables.get(i - 1)));
                this.addHardClause(clause);
            }
        }
    }

    protected void relaxCore(LNGIntVector conflict, int weightCore, LNGIntVector assumps) {
        assert (conflict.size() > 0);
        assert (weightCore > 0);
        LNGIntVector lits = new LNGIntVector();
        for (int i = 0; i < conflict.size(); ++i) {
            int indexSoft = (Integer)this.coreMapping.get(conflict.get(i));
            if (((MSSoftClause)this.softClauses.get(indexSoft)).weight() == weightCore) {
                int p = this.newLiteral(false);
                ((MSSoftClause)this.softClauses.get(indexSoft)).relaxationVars().push(p);
                lits.push(p);
                if (!this.symmetryStrategy) continue;
                this.symmetryLog(indexSoft);
                continue;
            }
            assert (((MSSoftClause)this.softClauses.get(indexSoft)).weight() - weightCore > 0);
            ((MSSoftClause)this.softClauses.get(indexSoft)).setWeight(((MSSoftClause)this.softClauses.get(indexSoft)).weight() - weightCore);
            LNGIntVector clause = new LNGIntVector(((MSSoftClause)this.softClauses.get(indexSoft)).clause());
            LNGIntVector vars = new LNGIntVector(((MSSoftClause)this.softClauses.get(indexSoft)).relaxationVars());
            int p = this.newLiteral(false);
            vars.push(p);
            lits.push(p);
            this.addSoftClause(weightCore, clause, vars);
            int l = this.newLiteral(false);
            ((MSSoftClause)this.softClauses.get(this.nSoft() - 1)).setAssumptionVar(l);
            this.coreMapping.put(l, this.nSoft() - 1);
            assumps.push(MiniSatStyleSolver.not(l));
            if (!this.symmetryStrategy) continue;
            this.symmetryLog(this.nSoft() - 1);
        }
        this.encodeEO(lits);
        this.sumSizeCores += (long)conflict.size();
    }

    int computeCostCore(LNGIntVector conflict) {
        assert (conflict.size() != 0);
        if (this.problemType == MaxSAT.ProblemType.UNWEIGHTED) {
            return 1;
        }
        int coreCost = Integer.MAX_VALUE;
        for (int i = 0; i < conflict.size(); ++i) {
            int indexSoft = (Integer)this.coreMapping.get(conflict.get(i));
            if (((MSSoftClause)this.softClauses.get(indexSoft)).weight() >= coreCost) continue;
            coreCost = ((MSSoftClause)this.softClauses.get(indexSoft)).weight();
        }
        return coreCost;
    }

    void initSymmetry() {
        for (int i = 0; i < this.nSoft(); ++i) {
            this.softMapping.push(new LNGIntVector());
            this.relaxationMapping.push(new LNGIntVector());
        }
    }

    void symmetryLog(int p) {
        if (this.nbSymmetryClauses < this.symmetryBreakingLimit) {
            while (this.softMapping.size() <= p) {
                this.softMapping.push(new LNGIntVector());
                this.relaxationMapping.push(new LNGIntVector());
            }
            this.softMapping.get(p).push(this.nbCores);
            this.relaxationMapping.get(p).push(((MSSoftClause)this.softClauses.get(p)).relaxationVars().back());
            if (this.softMapping.get(p).size() > 1) {
                this.indexSoftCore.push(p);
            }
        }
    }

    protected void symmetryBreaking() {
        if (this.indexSoftCore.size() != 0 && this.nbSymmetryClauses < this.symmetryBreakingLimit) {
            LNGIntVector[] coreIntersection = new LNGIntVector[this.nbCores];
            LNGIntVector[] coreIntersectionCurrent = new LNGIntVector[this.nbCores];
            for (int i = 0; i < this.nbCores; ++i) {
                coreIntersection[i] = new LNGIntVector();
                coreIntersectionCurrent[i] = new LNGIntVector();
            }
            LNGIntVector coreList = new LNGIntVector();
            for (int i = 0; i < this.indexSoftCore.size(); ++i) {
                int core;
                int j;
                int p = this.indexSoftCore.get(i);
                LNGIntVector addCores = new LNGIntVector();
                for (j = 0; j < this.softMapping.get(p).size() - 1; ++j) {
                    core = this.softMapping.get(p).get(j);
                    addCores.push(core);
                    if (coreIntersection[core].size() == 0) {
                        coreList.push(core);
                    }
                    assert (j < this.relaxationMapping.get(p).size());
                    assert (MiniSatStyleSolver.var(this.relaxationMapping.get(p).get(j)) > this.nbInitialVariables);
                    coreIntersection[core].push(this.relaxationMapping.get(p).get(j));
                }
                for (j = 0; j < addCores.size(); ++j) {
                    core = addCores.get(j);
                    int b = this.softMapping.get(p).size() - 1;
                    assert (b < this.relaxationMapping.get(p).size());
                    assert (MiniSatStyleSolver.var(this.relaxationMapping.get(p).get(b)) > this.nbInitialVariables);
                    coreIntersectionCurrent[core].push(this.relaxationMapping.get(p).get(b));
                }
                for (int k = 0; k < coreList.size(); ++k) {
                    for (int m = 0; m < coreIntersection[coreList.get(k)].size(); ++m) {
                        for (int j2 = m + 1; j2 < coreIntersectionCurrent[coreList.get(k)].size(); ++j2) {
                            LNGIntVector clause = new LNGIntVector();
                            clause.push(MiniSatStyleSolver.not(coreIntersection[coreList.get(k)].get(m)));
                            clause.push(MiniSatStyleSolver.not(coreIntersectionCurrent[coreList.get(k)].get(j2)));
                            Pair<Integer, Integer> symClause = new Pair<Integer, Integer>(MiniSatStyleSolver.var(coreIntersection[coreList.get(k)].get(m)), MiniSatStyleSolver.var(coreIntersectionCurrent[coreList.get(k)].get(j2)));
                            if (MiniSatStyleSolver.var(coreIntersection[coreList.get(k)].get(m)) > MiniSatStyleSolver.var(coreIntersectionCurrent[coreList.get(k)].get(j2))) {
                                symClause = new Pair<Integer, Integer>(MiniSatStyleSolver.var(coreIntersectionCurrent[coreList.get(k)].get(j2)), MiniSatStyleSolver.var(coreIntersection[coreList.get(k)].get(m)));
                            }
                            if (this.duplicatedSymmetryClauses.contains(symClause)) continue;
                            this.duplicatedSymmetryClauses.add(symClause);
                            this.addHardClause(clause);
                            ++this.nbSymmetryClauses;
                            if (this.symmetryBreakingLimit == this.nbSymmetryClauses) break;
                        }
                        if (this.symmetryBreakingLimit == this.nbSymmetryClauses) break;
                    }
                    if (this.symmetryBreakingLimit == this.nbSymmetryClauses) break;
                }
                if (this.symmetryBreakingLimit == this.nbSymmetryClauses) break;
            }
        }
        this.indexSoftCore.clear();
    }

    Tristate unsatSearch() {
        assert (this.assumptions.size() == 0);
        this.solver = this.rebuildHardSolver();
        Tristate res = WBO.searchSATSolver(this.solver, this.satHandler(), this.assumptions);
        this.satSolverFinished();
        if (res == Tristate.FALSE) {
            ++this.nbCores;
        } else if (res == Tristate.TRUE) {
            ++this.nbSatisfiable;
            int cost = this.computeCostModel(this.solver.model(), Integer.MAX_VALUE);
            assert (cost <= this.ubCost);
            this.ubCost = cost;
            this.saveModel(this.solver.model());
            if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                this.output.println("o " + this.ubCost);
            }
        }
        this.solver = null;
        return res;
    }

    protected MaxSAT.MaxSATResult weightSearch() {
        assert (this.weightStrategy == MaxSATConfig.WeightStrategy.NORMAL || this.weightStrategy == MaxSATConfig.WeightStrategy.DIVERSIFY);
        Tristate unsatResult = this.unsatSearch();
        if (unsatResult == Tristate.UNDEF) {
            return MaxSAT.MaxSATResult.UNDEF;
        }
        if (unsatResult == Tristate.FALSE) {
            return MaxSAT.MaxSATResult.UNSATISFIABLE;
        }
        this.initAssumptions(this.assumptions);
        this.updateCurrentWeight(this.weightStrategy);
        this.solver = this.rebuildWeightSolver(this.weightStrategy);
        while (true) {
            Tristate res = WBO.searchSATSolver(this.solver, this.satHandler(), this.assumptions);
            this.satSolverFinished();
            if (res == Tristate.UNDEF) {
                return MaxSAT.MaxSATResult.UNDEF;
            }
            if (res == Tristate.FALSE) {
                ++this.nbCores;
                assert (this.solver.conflict().size() > 0);
                int coreCost = this.computeCostCore(this.solver.conflict());
                this.lbCost += coreCost;
                if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                    this.output.println(String.format("c LB : %d CS : %d W : %d", this.lbCost, this.solver.conflict().size(), coreCost));
                }
                if (!this.foundLowerBound(this.lbCost, null)) {
                    return MaxSAT.MaxSATResult.UNDEF;
                }
                this.relaxCore(this.solver.conflict(), coreCost, this.assumptions);
                this.solver = this.rebuildWeightSolver(this.weightStrategy);
                continue;
            }
            ++this.nbSatisfiable;
            if (this.nbCurrentSoft == this.nSoft()) {
                assert (this.computeCostModel(this.solver.model(), Integer.MAX_VALUE) == this.lbCost);
                if (this.lbCost == this.ubCost && this.verbosity != MaxSATConfig.Verbosity.NONE) {
                    this.output.println("c LB = UB");
                }
                if (this.lbCost < this.ubCost) {
                    this.ubCost = this.lbCost;
                    this.saveModel(this.solver.model());
                    if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                        this.output.println("o " + this.lbCost);
                    }
                }
                return MaxSAT.MaxSATResult.OPTIMUM;
            }
            this.updateCurrentWeight(this.weightStrategy);
            int cost = this.computeCostModel(this.solver.model(), Integer.MAX_VALUE);
            if (cost < this.ubCost) {
                this.ubCost = cost;
                this.saveModel(this.solver.model());
                if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                    this.output.println("o " + this.ubCost);
                }
            }
            if (this.lbCost == this.ubCost) {
                if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                    this.output.println("c LB = UB");
                }
                return MaxSAT.MaxSATResult.OPTIMUM;
            }
            if (!this.foundUpperBound(this.ubCost, null)) {
                return MaxSAT.MaxSATResult.UNDEF;
            }
            this.solver = this.rebuildWeightSolver(this.weightStrategy);
        }
    }

    protected MaxSAT.MaxSATResult normalSearch() {
        Tristate unsatResult = this.unsatSearch();
        if (unsatResult == Tristate.UNDEF) {
            return MaxSAT.MaxSATResult.UNDEF;
        }
        if (unsatResult == Tristate.FALSE) {
            return MaxSAT.MaxSATResult.UNSATISFIABLE;
        }
        this.initAssumptions(this.assumptions);
        this.solver = this.rebuildSolver();
        while (true) {
            Tristate res = WBO.searchSATSolver(this.solver, this.satHandler(), this.assumptions);
            this.satSolverFinished();
            if (res == Tristate.UNDEF) {
                return MaxSAT.MaxSATResult.UNDEF;
            }
            if (res != Tristate.FALSE) break;
            ++this.nbCores;
            assert (this.solver.conflict().size() > 0);
            int coreCost = this.computeCostCore(this.solver.conflict());
            this.lbCost += coreCost;
            if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                this.output.println(String.format("c LB : %d CS : %d W : %d", this.lbCost, this.solver.conflict().size(), coreCost));
            }
            if (this.lbCost == this.ubCost) {
                if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                    this.output.println("c LB = UB");
                }
                return MaxSAT.MaxSATResult.OPTIMUM;
            }
            if (!this.foundLowerBound(this.lbCost, null)) {
                return MaxSAT.MaxSATResult.UNDEF;
            }
            this.relaxCore(this.solver.conflict(), coreCost, this.assumptions);
            this.solver = this.rebuildSolver();
        }
        ++this.nbSatisfiable;
        this.ubCost = this.computeCostModel(this.solver.model(), Integer.MAX_VALUE);
        assert (this.lbCost == this.ubCost);
        if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
            this.output.println("o " + this.lbCost);
        }
        this.saveModel(this.solver.model());
        return MaxSAT.MaxSATResult.OPTIMUM;
    }

    void initAssumptions(LNGIntVector assumps) {
        for (int i = 0; i < this.nbSoft; ++i) {
            int l = this.newLiteral(false);
            ((MSSoftClause)this.softClauses.get(i)).setAssumptionVar(l);
            this.coreMapping.put(l, i);
            assumps.push(MiniSatStyleSolver.not(l));
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

