/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.solvers.maxsat.algorithms;

import java.io.PrintStream;
import org.logicng.configurations.Configuration;
import org.logicng.configurations.ConfigurationType;

public final class MaxSATConfig
extends Configuration {
    final IncrementalStrategy incrementalStrategy;
    final AMOEncoding amoEncoding;
    final PBEncoding pbEncoding;
    final CardinalityEncoding cardinalityEncoding;
    final WeightStrategy weightStrategy;
    final SolverType solverType;
    final Verbosity verbosity;
    final PrintStream output;
    final boolean symmetry;
    final int limit;
    final boolean bmo;

    private MaxSATConfig(Builder builder) {
        super(ConfigurationType.MAXSAT);
        this.incrementalStrategy = builder.incrementalStrategy;
        this.amoEncoding = builder.amoEncoding;
        this.pbEncoding = builder.pbEncoding;
        this.cardinalityEncoding = builder.cardinalityEncoding;
        this.weightStrategy = builder.weightStrategy;
        this.solverType = builder.solverType;
        this.verbosity = builder.verbosity;
        this.output = builder.output;
        this.symmetry = builder.symmetry;
        this.limit = builder.limit;
        this.bmo = builder.bmo;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MaxSATConfig{").append(System.lineSeparator());
        sb.append("incrementalStrategy=").append((Object)this.incrementalStrategy).append(System.lineSeparator());
        sb.append("pbEncoding=").append((Object)this.amoEncoding).append(System.lineSeparator());
        sb.append("pbEncoding=").append((Object)this.pbEncoding).append(System.lineSeparator());
        sb.append("cardinalityEncoding=").append((Object)this.cardinalityEncoding).append(System.lineSeparator());
        sb.append("weightStrategy=").append((Object)this.weightStrategy).append(System.lineSeparator());
        sb.append("solverType=").append((Object)this.solverType).append(System.lineSeparator());
        sb.append("verbosity=").append((Object)this.verbosity).append(System.lineSeparator());
        sb.append("symmetry=").append(this.symmetry).append(System.lineSeparator());
        sb.append("limit=").append(this.limit).append(System.lineSeparator());
        sb.append("bmo=").append(this.bmo).append(System.lineSeparator());
        sb.append("}");
        return sb.toString();
    }

    public static class Builder {
        private final AMOEncoding amoEncoding;
        private final PBEncoding pbEncoding;
        private IncrementalStrategy incrementalStrategy = IncrementalStrategy.NONE;
        private CardinalityEncoding cardinalityEncoding = CardinalityEncoding.TOTALIZER;
        private WeightStrategy weightStrategy = WeightStrategy.NONE;
        private SolverType solverType = SolverType.GLUCOSE;
        private Verbosity verbosity = Verbosity.NONE;
        private PrintStream output = System.out;
        private boolean symmetry = true;
        private int limit = Integer.MAX_VALUE;
        private boolean bmo = true;

        private Builder() {
            this.amoEncoding = AMOEncoding.LADDER;
            this.pbEncoding = PBEncoding.SWC;
        }

        public Builder incremental(IncrementalStrategy inc) {
            this.incrementalStrategy = inc;
            return this;
        }

        public Builder cardinality(CardinalityEncoding card) {
            this.cardinalityEncoding = card;
            return this;
        }

        public Builder weight(WeightStrategy weight) {
            this.weightStrategy = weight;
            return this;
        }

        public Builder solver(SolverType solver) {
            this.solverType = solver;
            return this;
        }

        public Builder symmetry(boolean symm) {
            this.symmetry = symm;
            return this;
        }

        public Builder limit(int lim) {
            this.limit = lim;
            return this;
        }

        public Builder bmo(boolean bmo) {
            this.bmo = bmo;
            return this;
        }

        public Builder verbosity(Verbosity verb) {
            this.verbosity = verb;
            return this;
        }

        public Builder output(PrintStream output) {
            this.output = output;
            return this;
        }

        public MaxSATConfig build() {
            return new MaxSATConfig(this);
        }
    }

    public static enum Verbosity {
        NONE,
        SOME;

    }

    public static enum WeightStrategy {
        NONE,
        NORMAL,
        DIVERSIFY;

    }

    public static enum CardinalityEncoding {
        TOTALIZER,
        MTOTALIZER;

    }

    public static enum PBEncoding {
        SWC;

    }

    public static enum AMOEncoding {
        LADDER;

    }

    public static enum IncrementalStrategy {
        NONE,
        ITERATIVE;

    }

    public static enum SolverType {
        MINISAT,
        GLUCOSE;

    }
}

