/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.solvers.maxsat.algorithms;

import java.util.Iterator;
import java.util.Locale;
import java.util.TreeMap;
import java.util.TreeSet;
import org.logicng.collections.LNGBooleanVector;
import org.logicng.collections.LNGIntVector;
import org.logicng.collections.LNGVector;
import org.logicng.datastructures.Assignment;
import org.logicng.datastructures.Tristate;
import org.logicng.handlers.MaxSATHandler;
import org.logicng.handlers.SATHandler;
import org.logicng.solvers.datastructures.MSHardClause;
import org.logicng.solvers.datastructures.MSSoftClause;
import org.logicng.solvers.maxsat.algorithms.MaxSATConfig;
import org.logicng.solvers.sat.GlucoseConfig;
import org.logicng.solvers.sat.GlucoseSyrup;
import org.logicng.solvers.sat.MiniSat2Solver;
import org.logicng.solvers.sat.MiniSatConfig;
import org.logicng.solvers.sat.MiniSatStyleSolver;

public abstract class MaxSAT {
    protected final LNGBooleanVector model;
    final LNGVector<MSSoftClause> softClauses;
    final LNGVector<MSHardClause> hardClauses = new LNGVector();
    final LNGIntVector orderWeights;
    final MaxSATConfig.SolverType solverType;
    protected MaxSATConfig.Verbosity verbosity;
    protected MaxSATHandler handler;
    int hardWeight = 0;
    ProblemType problemType;
    int nbVars = 0;
    int nbSoft = 0;
    int nbHard = 0;
    int nbInitialVariables = 0;
    int nbCores = 0;
    int nbSymmetryClauses = 0;
    long sumSizeCores = 0L;
    int nbSatisfiable = 0;
    int ubCost = 0;
    int lbCost = 0;
    int currentWeight = 1;

    protected MaxSAT(MaxSATConfig config) {
        this.softClauses = new LNGVector();
        this.hardWeight = Integer.MAX_VALUE;
        this.problemType = ProblemType.UNWEIGHTED;
        this.model = new LNGBooleanVector();
        this.orderWeights = new LNGIntVector();
        this.solverType = config.solverType;
        this.handler = null;
    }

    public static void newSATVariable(MiniSatStyleSolver s) {
        s.newVar(true, true);
    }

    public static Tristate searchSATSolver(MiniSatStyleSolver s, SATHandler satHandler, LNGIntVector assumptions) {
        return s.solve(satHandler, assumptions);
    }

    public static Tristate searchSATSolver(MiniSatStyleSolver s, SATHandler satHandler) {
        return s.solve(satHandler);
    }

    public final MaxSATResult search(MaxSATHandler handler) {
        this.handler = handler;
        if (handler != null) {
            handler.started();
        }
        MaxSATResult result = this.search();
        if (handler != null) {
            handler.finishedSolving();
        }
        this.handler = null;
        return result;
    }

    public abstract MaxSATResult search();

    public int nVars() {
        return this.nbVars;
    }

    public int nSoft() {
        return this.nbSoft;
    }

    public int nHard() {
        return this.nbHard;
    }

    public void newVar() {
        ++this.nbVars;
    }

    public void addHardClause(LNGIntVector lits) {
        this.hardClauses.push(new MSHardClause(lits));
        ++this.nbHard;
    }

    public void addSoftClause(int weight, LNGIntVector lits) {
        LNGIntVector rVars = new LNGIntVector();
        this.softClauses.push(new MSSoftClause(lits, weight, -1, rVars));
        ++this.nbSoft;
    }

    public void addSoftClause(int weight, LNGIntVector lits, LNGIntVector vars) {
        this.softClauses.push(new MSSoftClause(lits, weight, -1, vars));
        ++this.nbSoft;
    }

    public int newLiteral(boolean sign) {
        int p = MiniSatStyleSolver.mkLit(this.nVars(), sign);
        this.newVar();
        return p;
    }

    public void setProblemType(ProblemType type) {
        this.problemType = type;
    }

    public void updateSumWeights(int weight) {
        if (weight != this.hardWeight) {
            this.ubCost += weight;
        }
    }

    public void setCurrentWeight(int weight) {
        if (weight > this.currentWeight && weight != this.hardWeight) {
            this.currentWeight = weight;
        }
    }

    public int currentWeight() {
        return this.currentWeight;
    }

    public MiniSatStyleSolver newSATSolver() {
        switch (this.solverType) {
            case GLUCOSE: {
                return new GlucoseSyrup(MiniSatConfig.builder().incremental(true).build(), GlucoseConfig.builder().build());
            }
            case MINISAT: {
                return new MiniSat2Solver(MiniSatConfig.builder().incremental(false).build());
            }
        }
        throw new IllegalStateException("Unknown solver type: " + (Object)((Object)this.solverType));
    }

    public void saveModel(LNGBooleanVector currentModel) {
        assert (this.nbInitialVariables != 0);
        assert (currentModel.size() != 0);
        this.model.clear();
        for (int i = 0; i < this.nbInitialVariables; ++i) {
            this.model.push(currentModel.get(i));
        }
    }

    public int computeCostModel(LNGBooleanVector currentModel, int weight) {
        assert (currentModel.size() != 0);
        int currentCost = 0;
        for (int i = 0; i < this.nSoft(); ++i) {
            boolean unsatisfied = true;
            for (int j = 0; j < this.softClauses.get(i).clause().size(); ++j) {
                if (weight != Integer.MAX_VALUE && this.softClauses.get(i).weight() != weight) {
                    unsatisfied = false;
                    continue;
                }
                assert (MiniSatStyleSolver.var(this.softClauses.get(i).clause().get(j)) < currentModel.size());
                if ((!MiniSatStyleSolver.sign(this.softClauses.get(i).clause().get(j)) || currentModel.get(MiniSatStyleSolver.var(this.softClauses.get(i).clause().get(j)))) && (MiniSatStyleSolver.sign(this.softClauses.get(i).clause().get(j)) || !currentModel.get(MiniSatStyleSolver.var(this.softClauses.get(i).clause().get(j))))) continue;
                unsatisfied = false;
                break;
            }
            if (!unsatisfied) continue;
            currentCost += this.softClauses.get(i).weight();
        }
        return currentCost;
    }

    public boolean isBMO(boolean cache) {
        int i;
        assert (this.orderWeights.size() == 0);
        boolean bmo = true;
        TreeSet<Integer> partitionWeights = new TreeSet<Integer>();
        TreeMap<Integer, Integer> nbPartitionWeights = new TreeMap<Integer, Integer>();
        for (int i2 = 0; i2 < this.nSoft(); ++i2) {
            int weight = this.softClauses.get(i2).weight();
            partitionWeights.add(weight);
            nbPartitionWeights.merge(weight, 1, Integer::sum);
        }
        Iterator i2 = partitionWeights.iterator();
        while (i2.hasNext()) {
            int i3 = (Integer)i2.next();
            this.orderWeights.push(i3);
        }
        this.orderWeights.sortReverse();
        long totalWeights = 0L;
        for (i = 0; i < this.orderWeights.size(); ++i) {
            totalWeights += (long)(this.orderWeights.get(i) * (Integer)nbPartitionWeights.get(this.orderWeights.get(i)));
        }
        for (i = 0; i < this.orderWeights.size(); ++i) {
            if ((long)this.orderWeights.get(i) >= (totalWeights -= (long)(this.orderWeights.get(i) * (Integer)nbPartitionWeights.get(this.orderWeights.get(i))))) continue;
            bmo = false;
            break;
        }
        if (!cache) {
            this.orderWeights.clear();
        }
        return bmo;
    }

    public Stats stats() {
        return new Stats();
    }

    public int result() {
        return this.ubCost;
    }

    public LNGBooleanVector model() {
        return this.model;
    }

    SATHandler satHandler() {
        return this.handler == null ? null : this.handler.satHandler();
    }

    boolean foundLowerBound(int lowerBound, Assignment model) {
        return this.handler == null || this.handler.foundLowerBound(lowerBound, model);
    }

    boolean foundUpperBound(int upperBound, Assignment model) {
        return this.handler == null || this.handler.foundUpperBound(upperBound, model);
    }

    boolean satSolverFinished() {
        return this.handler == null || this.handler.satSolverFinished();
    }

    public class Stats {
        protected final int ubC;
        protected final int nbS;
        protected final int nbC;
        protected final double avgCS;
        protected final int nbSC;

        protected Stats() {
            this.ubC = MaxSAT.this.model.size() == 0 ? -1 : MaxSAT.this.ubCost;
            this.nbS = MaxSAT.this.nbSatisfiable;
            this.nbC = MaxSAT.this.nbCores;
            this.avgCS = MaxSAT.this.nbCores != 0 ? (double)MaxSAT.this.sumSizeCores / (double)MaxSAT.this.nbCores : 0.0;
            this.nbSC = MaxSAT.this.nbSymmetryClauses;
        }

        public int bestSolution() {
            return this.ubC;
        }

        public int satCalls() {
            return this.nbS;
        }

        public int unsatCalls() {
            return this.nbC;
        }

        public double averageCoreSize() {
            return this.avgCS;
        }

        public int symmetryClauses() {
            return this.nbSC;
        }

        public String toString() {
            return String.format(Locale.ENGLISH, "MaxSAT.Stats{best solution=%d, #sat calls=%d, #unsat calls=%d, average core size=%.2f, #symmetry clauses=%d}", this.ubC, this.nbS, this.nbC, this.avgCS, this.nbSC);
        }
    }

    public static enum MaxSATResult {
        UNSATISFIABLE,
        OPTIMUM,
        UNDEF;

    }

    public static enum ProblemType {
        UNWEIGHTED,
        WEIGHTED;

    }
}

