/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.solvers.maxsat.algorithms;

import java.io.PrintStream;
import java.util.SortedMap;
import java.util.TreeMap;
import org.logicng.collections.LNGBooleanVector;
import org.logicng.collections.LNGIntVector;
import org.logicng.datastructures.Tristate;
import org.logicng.solvers.datastructures.MSHardClause;
import org.logicng.solvers.datastructures.MSSoftClause;
import org.logicng.solvers.maxsat.algorithms.MaxSAT;
import org.logicng.solvers.maxsat.algorithms.MaxSATConfig;
import org.logicng.solvers.maxsat.encodings.Encoder;
import org.logicng.solvers.sat.MiniSatStyleSolver;

public class MSU3
extends MaxSAT {
    protected final Encoder encoder;
    protected final MaxSATConfig.IncrementalStrategy incrementalStrategy;
    protected final LNGIntVector objFunction;
    protected final SortedMap<Integer, Integer> coreMapping;
    protected final LNGBooleanVector activeSoft;
    protected final PrintStream output;
    protected MiniSatStyleSolver solver = null;

    public MSU3() {
        this(MaxSATConfig.builder().build());
    }

    public MSU3(MaxSATConfig config) {
        super(config);
        this.verbosity = config.verbosity;
        this.incrementalStrategy = config.incrementalStrategy;
        this.encoder = new Encoder(config.cardinalityEncoding);
        this.objFunction = new LNGIntVector();
        this.coreMapping = new TreeMap<Integer, Integer>();
        this.activeSoft = new LNGBooleanVector();
        this.output = config.output;
    }

    @Override
    public MaxSAT.MaxSATResult search() {
        if (this.problemType == MaxSAT.ProblemType.WEIGHTED) {
            throw new IllegalStateException("Error: Currently algorithm MSU3 does not support weighted MaxSAT instances.");
        }
        switch (this.incrementalStrategy) {
            case NONE: {
                return this.none();
            }
            case ITERATIVE: {
                if (this.encoder.cardEncoding() != MaxSATConfig.CardinalityEncoding.TOTALIZER) {
                    throw new IllegalStateException("Error: Currently iterative encoding in MSU3 only supports the Totalizer encoding.");
                }
                return this.iterative();
            }
        }
        throw new IllegalArgumentException("Unknown incremental strategy: " + (Object)((Object)this.incrementalStrategy));
    }

    protected MaxSAT.MaxSATResult none() {
        int i;
        this.nbInitialVariables = this.nVars();
        this.initRelaxation();
        this.solver = this.rebuildSolver();
        LNGIntVector assumptions = new LNGIntVector();
        LNGIntVector currentObjFunction = new LNGIntVector();
        this.encoder.setIncremental(MaxSATConfig.IncrementalStrategy.NONE);
        this.activeSoft.growTo(this.nSoft(), false);
        for (i = 0; i < this.nSoft(); ++i) {
            this.coreMapping.put(((MSSoftClause)this.softClauses.get(i)).assumptionVar(), i);
        }
        block1: while (true) {
            Tristate res = MSU3.searchSATSolver(this.solver, this.satHandler(), assumptions);
            this.satSolverFinished();
            if (res == Tristate.UNDEF) {
                return MaxSAT.MaxSATResult.UNDEF;
            }
            if (res == Tristate.TRUE) {
                ++this.nbSatisfiable;
                int newCost = this.computeCostModel(this.solver.model(), Integer.MAX_VALUE);
                this.saveModel(this.solver.model());
                if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                    this.output.println("o " + newCost);
                }
                this.ubCost = newCost;
                if (this.nbSatisfiable == 1) {
                    if (!this.foundUpperBound(this.ubCost, null)) {
                        return MaxSAT.MaxSATResult.UNDEF;
                    }
                    int i2 = 0;
                    while (true) {
                        if (i2 >= this.objFunction.size()) continue block1;
                        assumptions.push(MiniSatStyleSolver.not(this.objFunction.get(i2)));
                        ++i2;
                    }
                }
                return MaxSAT.MaxSATResult.OPTIMUM;
            }
            ++this.lbCost;
            ++this.nbCores;
            if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                this.output.println("c LB : " + this.lbCost);
            }
            if (this.nbSatisfiable == 0) {
                return MaxSAT.MaxSATResult.UNSATISFIABLE;
            }
            if (this.lbCost == this.ubCost) {
                assert (this.nbSatisfiable > 0);
                if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                    this.output.println("c LB = UB");
                }
                return MaxSAT.MaxSATResult.OPTIMUM;
            }
            if (!this.foundLowerBound(this.lbCost, null)) {
                return MaxSAT.MaxSATResult.UNDEF;
            }
            this.sumSizeCores += (long)this.solver.conflict().size();
            for (i = 0; i < this.solver.conflict().size(); ++i) {
                assert (!this.activeSoft.get((Integer)this.coreMapping.get(this.solver.conflict().get(i))));
                this.activeSoft.set((Integer)this.coreMapping.get(this.solver.conflict().get(i)), true);
            }
            currentObjFunction.clear();
            assumptions.clear();
            for (i = 0; i < this.nSoft(); ++i) {
                if (this.activeSoft.get(i)) {
                    currentObjFunction.push(((MSSoftClause)this.softClauses.get(i)).relaxationVars().get(0));
                    continue;
                }
                assumptions.push(MiniSatStyleSolver.not(((MSSoftClause)this.softClauses.get(i)).assumptionVar()));
            }
            if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                this.output.println(String.format("c Relaxed soft clauses %d / %d", currentObjFunction.size(), this.objFunction.size()));
            }
            this.solver = this.rebuildSolver();
            this.encoder.encodeCardinality(this.solver, currentObjFunction, this.lbCost);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected MaxSAT.MaxSATResult iterative() {
        if (this.encoder.cardEncoding() != MaxSATConfig.CardinalityEncoding.TOTALIZER) {
            throw new IllegalStateException("Error: Currently algorithm MSU3 with iterative encoding only  supports the totalizer encoding.");
        }
        this.nbInitialVariables = this.nVars();
        this.initRelaxation();
        this.solver = this.rebuildSolver();
        assumptions = new LNGIntVector();
        joinObjFunction = new LNGIntVector();
        currentObjFunction = new LNGIntVector();
        encodingAssumptions = new LNGIntVector();
        this.encoder.setIncremental(MaxSATConfig.IncrementalStrategy.ITERATIVE);
        this.activeSoft.growTo(this.nSoft(), false);
        for (i = 0; i < this.nSoft(); ++i) {
            this.coreMapping.put(((MSSoftClause)this.softClauses.get(i)).assumptionVar(), i);
        }
        block1: while (true) {
            res = MSU3.searchSATSolver(this.solver, this.satHandler(), assumptions);
            this.satSolverFinished();
            if (res == Tristate.UNDEF) {
                return MaxSAT.MaxSATResult.UNDEF;
            }
            if (res == Tristate.TRUE) {
                ++this.nbSatisfiable;
                newCost = this.computeCostModel(this.solver.model(), 0x7FFFFFFF);
                this.saveModel(this.solver.model());
                if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                    this.output.println("o " + newCost);
                }
                this.ubCost = newCost;
                if (this.nbSatisfiable == 1) {
                    if (!this.foundUpperBound(this.ubCost, null)) {
                        return MaxSAT.MaxSATResult.UNDEF;
                    }
                    i = 0;
                    while (true) {
                        if (i >= this.objFunction.size()) continue block1;
                        assumptions.push(MiniSatStyleSolver.not(this.objFunction.get(i)));
                        ++i;
                    }
                }
                if (!MSU3.$assertionsDisabled && this.lbCost != newCost) {
                    throw new AssertionError();
                }
                return MaxSAT.MaxSATResult.OPTIMUM;
            }
            ++this.lbCost;
            ++this.nbCores;
            if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                this.output.println("c LB : " + this.lbCost);
            }
            if (this.nbSatisfiable == 0) {
                return MaxSAT.MaxSATResult.UNSATISFIABLE;
            }
            if (this.lbCost == this.ubCost) {
                if (!MSU3.$assertionsDisabled && this.nbSatisfiable <= 0) {
                    throw new AssertionError();
                }
                if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                    this.output.println("c LB = UB");
                }
                return MaxSAT.MaxSATResult.OPTIMUM;
            }
            this.sumSizeCores += (long)this.solver.conflict().size();
            if (this.solver.conflict().size() == 0) {
                return MaxSAT.MaxSATResult.UNSATISFIABLE;
            }
            if (!this.foundLowerBound(this.lbCost, null)) {
                return MaxSAT.MaxSATResult.UNDEF;
            }
            joinObjFunction.clear();
            for (i = 0; i < this.solver.conflict().size(); ++i) {
                if (!this.coreMapping.containsKey(this.solver.conflict().get(i))) continue;
                if (!MSU3.$assertionsDisabled && this.activeSoft.get((Integer)this.coreMapping.get(this.solver.conflict().get(i)))) {
                    throw new AssertionError();
                }
                this.activeSoft.set((Integer)this.coreMapping.get(this.solver.conflict().get(i)), true);
                joinObjFunction.push(((MSSoftClause)this.softClauses.get((Integer)this.coreMapping.get(this.solver.conflict().get(i)))).relaxationVars().get(0));
            }
            currentObjFunction.clear();
            assumptions.clear();
            for (i = 0; i < this.nSoft(); ++i) {
                if (this.activeSoft.get(i)) {
                    currentObjFunction.push(((MSSoftClause)this.softClauses.get(i)).relaxationVars().get(0));
                    continue;
                }
                assumptions.push(MiniSatStyleSolver.not(((MSSoftClause)this.softClauses.get(i)).assumptionVar()));
            }
            if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                this.output.println(String.format("c Relaxed soft clauses %d / %d", new Object[]{currentObjFunction.size(), this.objFunction.size()}));
            }
            if (!this.encoder.hasCardEncoding()) {
                if (this.lbCost != currentObjFunction.size()) {
                    this.encoder.buildCardinality(this.solver, currentObjFunction, this.lbCost);
                    joinObjFunction.clear();
                    this.encoder.incUpdateCardinality(this.solver, joinObjFunction, currentObjFunction, this.lbCost, encodingAssumptions);
                }
            } else {
                this.encoder.incUpdateCardinality(this.solver, joinObjFunction, currentObjFunction, this.lbCost, encodingAssumptions);
            }
            i = 0;
            while (true) {
                if (i < encodingAssumptions.size()) ** break;
                continue block1;
                assumptions.push(encodingAssumptions.get(i));
                ++i;
            }
            break;
        }
    }

    protected MiniSatStyleSolver rebuildSolver() {
        int i;
        MiniSatStyleSolver s = this.newSATSolver();
        for (i = 0; i < this.nVars(); ++i) {
            MSU3.newSATVariable(s);
        }
        for (i = 0; i < this.nHard(); ++i) {
            s.addClause(((MSHardClause)this.hardClauses.get(i)).clause(), null);
        }
        for (int i2 = 0; i2 < this.nSoft(); ++i2) {
            LNGIntVector clause = new LNGIntVector(((MSSoftClause)this.softClauses.get(i2)).clause());
            for (int j = 0; j < ((MSSoftClause)this.softClauses.get(i2)).relaxationVars().size(); ++j) {
                clause.push(((MSSoftClause)this.softClauses.get(i2)).relaxationVars().get(j));
            }
            s.addClause(clause, null);
        }
        return s;
    }

    protected void initRelaxation() {
        for (int i = 0; i < this.nbSoft; ++i) {
            int l = this.newLiteral(false);
            ((MSSoftClause)this.softClauses.get(i)).relaxationVars().push(l);
            ((MSSoftClause)this.softClauses.get(i)).setAssumptionVar(l);
            this.objFunction.push(l);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

