/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.solvers.maxsat.algorithms;

import java.io.PrintStream;
import org.logicng.collections.LNGIntVector;
import org.logicng.datastructures.Tristate;
import org.logicng.solvers.datastructures.MSHardClause;
import org.logicng.solvers.datastructures.MSSoftClause;
import org.logicng.solvers.maxsat.algorithms.MaxSAT;
import org.logicng.solvers.maxsat.algorithms.MaxSATConfig;
import org.logicng.solvers.maxsat.encodings.Encoder;
import org.logicng.solvers.sat.MiniSatStyleSolver;

public class LinearUS
extends MaxSAT {
    protected final Encoder encoder;
    protected final MaxSATConfig.IncrementalStrategy incrementalStrategy;
    protected final LNGIntVector objFunction;
    protected final PrintStream output;
    protected MiniSatStyleSolver solver = null;

    public LinearUS() {
        this(MaxSATConfig.builder().build());
    }

    public LinearUS(MaxSATConfig config) {
        super(config);
        this.verbosity = config.verbosity;
        this.incrementalStrategy = config.incrementalStrategy;
        this.encoder = new Encoder(config.cardinalityEncoding);
        this.objFunction = new LNGIntVector();
        this.output = config.output;
    }

    @Override
    public MaxSAT.MaxSATResult search() {
        if (this.problemType == MaxSAT.ProblemType.WEIGHTED) {
            throw new IllegalStateException("Error: Currently LinearUS does not support weighted MaxSAT instances.");
        }
        switch (this.incrementalStrategy) {
            case NONE: {
                return this.none();
            }
            case ITERATIVE: {
                if (this.encoder.cardEncoding() != MaxSATConfig.CardinalityEncoding.TOTALIZER) {
                    throw new IllegalStateException("Error: Currently iterative encoding in LinearUS only supports the Totalizer encoding.");
                }
                return this.iterative();
            }
        }
        throw new IllegalArgumentException("Unknown incremental strategy: " + (Object)((Object)this.incrementalStrategy));
    }

    protected MaxSAT.MaxSATResult none() {
        this.nbInitialVariables = this.nVars();
        this.initRelaxation();
        this.solver = this.rebuildSolver();
        LNGIntVector assumptions = new LNGIntVector();
        this.encoder.setIncremental(MaxSATConfig.IncrementalStrategy.NONE);
        while (true) {
            Tristate res = LinearUS.searchSATSolver(this.solver, this.satHandler(), assumptions);
            this.satSolverFinished();
            if (res == Tristate.UNDEF) {
                return MaxSAT.MaxSATResult.UNDEF;
            }
            if (res == Tristate.TRUE) {
                ++this.nbSatisfiable;
                int newCost = this.computeCostModel(this.solver.model(), Integer.MAX_VALUE);
                this.saveModel(this.solver.model());
                if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                    this.output.println("o " + newCost);
                }
                this.ubCost = newCost;
                if (this.nbSatisfiable == 1) {
                    if (!this.foundUpperBound(this.ubCost, null)) {
                        return MaxSAT.MaxSATResult.UNDEF;
                    }
                    if (this.encoder.cardEncoding() == MaxSATConfig.CardinalityEncoding.MTOTALIZER) {
                        this.encoder.setModulo((int)Math.ceil(Math.sqrt((double)this.ubCost + 1.0)));
                    }
                    this.encoder.encodeCardinality(this.solver, this.objFunction, 0);
                    continue;
                }
                return MaxSAT.MaxSATResult.OPTIMUM;
            }
            ++this.lbCost;
            if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                this.output.println("c LB : " + this.lbCost);
            }
            if (this.nbSatisfiable == 0) {
                return MaxSAT.MaxSATResult.UNSATISFIABLE;
            }
            if (this.lbCost == this.ubCost) {
                if (this.nbSatisfiable > 0) {
                    if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                        this.output.println("c LB = UB");
                    }
                    return MaxSAT.MaxSATResult.OPTIMUM;
                }
                return MaxSAT.MaxSATResult.UNSATISFIABLE;
            }
            if (!this.foundLowerBound(this.lbCost, null)) {
                return MaxSAT.MaxSATResult.UNDEF;
            }
            this.solver = this.rebuildSolver();
            this.encoder.encodeCardinality(this.solver, this.objFunction, this.lbCost);
        }
    }

    protected MaxSAT.MaxSATResult iterative() {
        assert (this.encoder.cardEncoding() == MaxSATConfig.CardinalityEncoding.TOTALIZER);
        this.nbInitialVariables = this.nVars();
        this.initRelaxation();
        this.solver = this.rebuildSolver();
        LNGIntVector assumptions = new LNGIntVector();
        this.encoder.setIncremental(MaxSATConfig.IncrementalStrategy.ITERATIVE);
        block0: while (true) {
            Tristate res = LinearUS.searchSATSolver(this.solver, this.satHandler(), assumptions);
            this.satSolverFinished();
            if (res == Tristate.UNDEF) {
                return MaxSAT.MaxSATResult.UNDEF;
            }
            if (res == Tristate.TRUE) {
                ++this.nbSatisfiable;
                int newCost = this.computeCostModel(this.solver.model(), Integer.MAX_VALUE);
                this.saveModel(this.solver.model());
                if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                    this.output.println("o " + newCost);
                }
                this.ubCost = newCost;
                if (this.nbSatisfiable == 1) {
                    if (!this.foundUpperBound(this.ubCost, null)) {
                        return MaxSAT.MaxSATResult.UNDEF;
                    }
                    int i = 0;
                    while (true) {
                        if (i >= this.objFunction.size()) continue block0;
                        assumptions.push(MiniSatStyleSolver.not(this.objFunction.get(i)));
                        ++i;
                    }
                }
                assert (this.lbCost == this.ubCost);
                return MaxSAT.MaxSATResult.OPTIMUM;
            }
            ++this.nbCores;
            ++this.lbCost;
            if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                this.output.println("c LB : " + this.lbCost);
            }
            if (this.nbSatisfiable == 0) {
                return MaxSAT.MaxSATResult.UNSATISFIABLE;
            }
            if (this.lbCost == this.ubCost) {
                if (this.nbSatisfiable > 0) {
                    if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                        this.output.println("c LB = UB");
                    }
                    return MaxSAT.MaxSATResult.OPTIMUM;
                }
                return MaxSAT.MaxSATResult.UNSATISFIABLE;
            }
            if (!this.foundLowerBound(this.lbCost, null)) {
                return MaxSAT.MaxSATResult.UNDEF;
            }
            if (!this.encoder.hasCardEncoding()) {
                this.encoder.buildCardinality(this.solver, this.objFunction, this.lbCost);
            }
            LNGIntVector join = new LNGIntVector();
            this.encoder.incUpdateCardinality(this.solver, join, this.objFunction, this.lbCost, assumptions);
        }
    }

    protected MiniSatStyleSolver rebuildSolver() {
        int i;
        MiniSatStyleSolver s = this.newSATSolver();
        for (i = 0; i < this.nVars(); ++i) {
            LinearUS.newSATVariable(s);
        }
        for (i = 0; i < this.nHard(); ++i) {
            s.addClause(((MSHardClause)this.hardClauses.get(i)).clause(), null);
        }
        for (int i2 = 0; i2 < this.nSoft(); ++i2) {
            LNGIntVector clause = new LNGIntVector(((MSSoftClause)this.softClauses.get(i2)).clause());
            for (int j = 0; j < ((MSSoftClause)this.softClauses.get(i2)).relaxationVars().size(); ++j) {
                clause.push(((MSSoftClause)this.softClauses.get(i2)).relaxationVars().get(j));
            }
            s.addClause(clause, null);
        }
        return s;
    }

    protected void initRelaxation() {
        for (int i = 0; i < this.nbSoft; ++i) {
            int l = this.newLiteral(false);
            ((MSSoftClause)this.softClauses.get(i)).relaxationVars().push(l);
            ((MSSoftClause)this.softClauses.get(i)).setAssumptionVar(l);
            this.objFunction.push(l);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

