/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.solvers.maxsat.algorithms;

import java.io.PrintStream;
import org.logicng.collections.LNGBooleanVector;
import org.logicng.collections.LNGIntVector;
import org.logicng.collections.LNGVector;
import org.logicng.datastructures.Tristate;
import org.logicng.solvers.datastructures.MSHardClause;
import org.logicng.solvers.datastructures.MSSoftClause;
import org.logicng.solvers.maxsat.algorithms.MaxSAT;
import org.logicng.solvers.maxsat.algorithms.MaxSATConfig;
import org.logicng.solvers.maxsat.encodings.Encoder;
import org.logicng.solvers.sat.MiniSatStyleSolver;

public class LinearSU
extends MaxSAT {
    protected final Encoder encoder;
    protected final boolean bmoMode;
    protected final LNGIntVector objFunction;
    protected final LNGIntVector coeffs;
    protected final PrintStream output;
    protected MiniSatStyleSolver solver = null;
    protected boolean isBmo;

    public LinearSU() {
        this(MaxSATConfig.builder().cardinality(MaxSATConfig.CardinalityEncoding.MTOTALIZER).build());
    }

    public LinearSU(MaxSATConfig config) {
        super(config);
        this.encoder = new Encoder(config.cardinalityEncoding);
        this.encoder.setPBEncoding(config.pbEncoding);
        this.verbosity = config.verbosity;
        this.bmoMode = config.bmo;
        this.isBmo = false;
        this.objFunction = new LNGIntVector();
        this.coeffs = new LNGIntVector();
        this.output = config.output;
    }

    @Override
    public MaxSAT.MaxSATResult search() {
        this.nbInitialVariables = this.nVars();
        if (this.currentWeight == 1) {
            this.problemType = MaxSAT.ProblemType.UNWEIGHTED;
        } else {
            this.isBmo = this.isBMO(true);
        }
        if (this.problemType == MaxSAT.ProblemType.WEIGHTED) {
            if (this.bmoMode && this.isBmo) {
                return this.bmoSearch();
            }
            return this.normalSearch();
        }
        return this.normalSearch();
    }

    protected MaxSAT.MaxSATResult bmoSearch() {
        assert (this.orderWeights.size() > 0);
        this.initRelaxation();
        int currentWeight = this.orderWeights.get(0);
        int minWeight = this.orderWeights.get(this.orderWeights.size() - 1);
        int posWeight = 0;
        LNGVector<LNGIntVector> functions = new LNGVector<LNGIntVector>();
        LNGIntVector weights = new LNGIntVector();
        this.solver = this.rebuildBMO(functions, weights, currentWeight);
        int localCost = 0;
        this.ubCost = 0;
        while (true) {
            Tristate res = LinearSU.searchSATSolver(this.solver, this.satHandler());
            this.satSolverFinished();
            if (res == Tristate.UNDEF) {
                return MaxSAT.MaxSATResult.UNDEF;
            }
            if (res == Tristate.TRUE) {
                ++this.nbSatisfiable;
                int newCost = this.computeCostModel(this.solver.model(), currentWeight);
                if (currentWeight == minWeight) {
                    this.saveModel(this.solver.model());
                    if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                        this.output.println("o " + (newCost + this.lbCost));
                    }
                    this.ubCost = newCost + this.lbCost;
                    if (newCost > 0 && !this.foundUpperBound(this.ubCost, null)) {
                        return MaxSAT.MaxSATResult.UNDEF;
                    }
                } else if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                    this.output.println(String.format("c BMO-UB : %d (Function %d/%d)", newCost, posWeight + 1, this.orderWeights.size()));
                }
                if (newCost == 0 && currentWeight == minWeight) {
                    return MaxSAT.MaxSATResult.OPTIMUM;
                }
                if (newCost == 0) {
                    functions.push(new LNGIntVector(this.objFunction));
                    localCost = newCost;
                    weights.push(localCost / currentWeight);
                    currentWeight = this.orderWeights.get(++posWeight);
                    localCost = 0;
                    this.solver = this.rebuildBMO(functions, weights, currentWeight);
                    if (this.verbosity == MaxSATConfig.Verbosity.NONE) continue;
                    this.output.println("c LB : " + this.lbCost);
                    continue;
                }
                if (localCost == 0) {
                    this.encoder.encodeCardinality(this.solver, this.objFunction, newCost / currentWeight - 1);
                } else {
                    this.encoder.updateCardinality(this.solver, newCost / currentWeight - 1);
                }
                localCost = newCost;
                continue;
            }
            ++this.nbCores;
            if (currentWeight == minWeight) {
                if (this.model.size() == 0) {
                    assert (this.nbSatisfiable == 0);
                    return MaxSAT.MaxSATResult.UNSATISFIABLE;
                }
                return MaxSAT.MaxSATResult.OPTIMUM;
            }
            functions.push(new LNGIntVector(this.objFunction));
            weights.push(localCost / currentWeight);
            this.lbCost += localCost;
            currentWeight = this.orderWeights.get(++posWeight);
            localCost = 0;
            if (!this.foundLowerBound(this.lbCost, null)) {
                return MaxSAT.MaxSATResult.UNDEF;
            }
            this.solver = this.rebuildBMO(functions, weights, currentWeight);
            if (this.verbosity == MaxSATConfig.Verbosity.NONE) continue;
            this.output.println("c LB : " + this.lbCost);
        }
    }

    protected MaxSAT.MaxSATResult normalSearch() {
        block12: {
            this.initRelaxation();
            this.solver = this.rebuildSolver(1);
            do {
                Tristate res = LinearSU.searchSATSolver(this.solver, this.satHandler());
                this.satSolverFinished();
                if (res == Tristate.UNDEF) {
                    return MaxSAT.MaxSATResult.UNDEF;
                }
                if (res != Tristate.TRUE) break block12;
                ++this.nbSatisfiable;
                int newCost = this.computeCostModel(this.solver.model(), Integer.MAX_VALUE);
                this.saveModel(this.solver.model());
                if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                    this.output.println("o " + newCost);
                }
                if (newCost == 0) {
                    this.ubCost = newCost;
                    return MaxSAT.MaxSATResult.OPTIMUM;
                }
                if (this.problemType == MaxSAT.ProblemType.WEIGHTED) {
                    if (!this.encoder.hasPBEncoding()) {
                        this.encoder.encodePB(this.solver, this.objFunction, this.coeffs, newCost - 1);
                    } else {
                        this.encoder.updatePB(this.solver, newCost - 1);
                    }
                } else if (!this.encoder.hasCardEncoding()) {
                    this.encoder.encodeCardinality(this.solver, this.objFunction, newCost - 1);
                } else {
                    this.encoder.updateCardinality(this.solver, newCost - 1);
                }
                this.ubCost = newCost;
            } while (this.foundUpperBound(this.ubCost, null));
            return MaxSAT.MaxSATResult.UNDEF;
        }
        ++this.nbCores;
        if (this.model.size() == 0) {
            assert (this.nbSatisfiable == 0);
            return MaxSAT.MaxSATResult.UNSATISFIABLE;
        }
        return MaxSAT.MaxSATResult.OPTIMUM;
    }

    protected MiniSatStyleSolver rebuildSolver(int minWeight) {
        int i;
        LNGBooleanVector seen = new LNGBooleanVector(this.nVars());
        seen.growTo(this.nVars(), false);
        MiniSatStyleSolver s = this.newSATSolver();
        for (i = 0; i < this.nVars(); ++i) {
            LinearSU.newSATVariable(s);
        }
        for (i = 0; i < this.nHard(); ++i) {
            s.addClause(((MSHardClause)this.hardClauses.get(i)).clause(), null);
        }
        for (i = 0; i < this.nSoft(); ++i) {
            if (((MSSoftClause)this.softClauses.get(i)).weight() < minWeight) continue;
            LNGIntVector clause = new LNGIntVector(((MSSoftClause)this.softClauses.get(i)).clause());
            for (int j = 0; j < ((MSSoftClause)this.softClauses.get(i)).relaxationVars().size(); ++j) {
                clause.push(((MSSoftClause)this.softClauses.get(i)).relaxationVars().get(j));
            }
            s.addClause(clause, null);
        }
        return s;
    }

    protected MiniSatStyleSolver rebuildBMO(LNGVector<LNGIntVector> functions, LNGIntVector rhs, int currentWeight) {
        int i;
        assert (functions.size() == rhs.size());
        MiniSatStyleSolver s = this.rebuildSolver(currentWeight);
        this.objFunction.clear();
        this.coeffs.clear();
        for (i = 0; i < this.nSoft(); ++i) {
            if (((MSSoftClause)this.softClauses.get(i)).weight() != currentWeight) continue;
            this.objFunction.push(((MSSoftClause)this.softClauses.get(i)).relaxationVars().get(0));
            this.coeffs.push(((MSSoftClause)this.softClauses.get(i)).weight());
        }
        for (i = 0; i < functions.size(); ++i) {
            this.encoder.encodeCardinality(s, functions.get(i), rhs.get(i));
        }
        return s;
    }

    protected void initRelaxation() {
        for (MSSoftClause softClause : this.softClauses) {
            int l = this.newLiteral(false);
            softClause.relaxationVars().push(l);
            this.objFunction.push(l);
            this.coeffs.push(softClause.weight());
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

