/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.solvers.maxsat.algorithms;

import java.io.PrintStream;
import java.util.HashSet;
import java.util.TreeMap;
import org.logicng.collections.LNGBooleanVector;
import org.logicng.collections.LNGIntVector;
import org.logicng.collections.LNGVector;
import org.logicng.datastructures.Tristate;
import org.logicng.solvers.datastructures.MSHardClause;
import org.logicng.solvers.datastructures.MSSoftClause;
import org.logicng.solvers.maxsat.algorithms.MaxSAT;
import org.logicng.solvers.maxsat.algorithms.MaxSATConfig;
import org.logicng.solvers.maxsat.algorithms.WBO;
import org.logicng.solvers.maxsat.encodings.Encoder;
import org.logicng.solvers.sat.MiniSatStyleSolver;
import org.logicng.util.Pair;

public class IncWBO
extends WBO {
    protected final Encoder encoder;
    protected final LNGBooleanVector incSoft;
    protected final PrintStream output;
    protected boolean firstBuild;

    public IncWBO() {
        this(MaxSATConfig.builder().build());
    }

    public IncWBO(MaxSATConfig config) {
        super(config);
        this.solver = null;
        this.verbosity = config.verbosity;
        this.nbCurrentSoft = 0;
        this.weightStrategy = config.weightStrategy;
        this.symmetryStrategy = config.symmetry;
        this.symmetryBreakingLimit = config.limit;
        this.firstBuild = true;
        this.coreMapping = new TreeMap();
        this.assumptions = new LNGIntVector();
        this.indexSoftCore = new LNGIntVector();
        this.softMapping = new LNGVector();
        this.relaxationMapping = new LNGVector();
        this.duplicatedSymmetryClauses = new HashSet();
        this.encoder = new Encoder(MaxSATConfig.CardinalityEncoding.TOTALIZER);
        this.encoder.setAMOEncoding(config.amoEncoding);
        this.incSoft = new LNGBooleanVector();
        this.output = config.output;
    }

    @Override
    public MaxSAT.MaxSATResult search() {
        this.nbInitialVariables = this.nVars();
        if (this.currentWeight == 1) {
            this.problemType = MaxSAT.ProblemType.UNWEIGHTED;
            this.weightStrategy = MaxSATConfig.WeightStrategy.NONE;
        }
        if (this.symmetryStrategy) {
            this.initSymmetry();
        }
        if (this.problemType == MaxSAT.ProblemType.UNWEIGHTED || this.weightStrategy == MaxSATConfig.WeightStrategy.NONE) {
            return this.normalSearch();
        }
        if (this.weightStrategy == MaxSATConfig.WeightStrategy.NORMAL || this.weightStrategy == MaxSATConfig.WeightStrategy.DIVERSIFY) {
            return this.weightSearch();
        }
        throw new IllegalArgumentException("Unknown problem type.");
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }

    protected void incrementalBuildWeightSolver(MaxSATConfig.WeightStrategy strategy) {
        assert (strategy == MaxSATConfig.WeightStrategy.NORMAL || strategy == MaxSATConfig.WeightStrategy.DIVERSIFY);
        if (this.firstBuild) {
            int i;
            this.solver = this.newSATSolver();
            for (i = 0; i < this.nVars(); ++i) {
                IncWBO.newSATVariable(this.solver);
            }
            for (i = 0; i < this.nHard(); ++i) {
                this.solver.addClause(((MSHardClause)this.hardClauses.get(i)).clause(), null);
            }
            if (this.symmetryStrategy) {
                this.symmetryBreaking();
            }
            this.firstBuild = false;
        }
        this.nbCurrentSoft = 0;
        for (int i = 0; i < this.nSoft(); ++i) {
            if (((MSSoftClause)this.softClauses.get(i)).weight() < this.currentWeight || ((MSSoftClause)this.softClauses.get(i)).weight() == 0) continue;
            ++this.nbCurrentSoft;
            LNGIntVector clause = new LNGIntVector(((MSSoftClause)this.softClauses.get(i)).clause());
            for (int j = 0; j < ((MSSoftClause)this.softClauses.get(i)).relaxationVars().size(); ++j) {
                clause.push(((MSSoftClause)this.softClauses.get(i)).relaxationVars().get(j));
            }
            clause.push(((MSSoftClause)this.softClauses.get(i)).assumptionVar());
            this.solver.addClause(clause, null);
        }
    }

    protected void relaxCore(LNGIntVector conflict, int weightCore) {
        assert (conflict.size() > 0);
        assert (weightCore > 0);
        LNGIntVector lits = new LNGIntVector();
        for (int i = 0; i < conflict.size(); ++i) {
            int j;
            LNGIntVector vars;
            LNGIntVector clause;
            int indexSoft = (Integer)this.coreMapping.get(conflict.get(i));
            if (((MSSoftClause)this.softClauses.get(indexSoft)).weight() == weightCore) {
                clause = new LNGIntVector(((MSSoftClause)this.softClauses.get(indexSoft)).clause());
                vars = new LNGIntVector(((MSSoftClause)this.softClauses.get(indexSoft)).relaxationVars());
                int p = this.newLiteral(false);
                IncWBO.newSATVariable(this.solver);
                vars.push(p);
                lits.push(p);
                this.addSoftClause(weightCore, clause, vars);
                int l = this.newLiteral(false);
                IncWBO.newSATVariable(this.solver);
                ((MSSoftClause)this.softClauses.get(this.nSoft() - 1)).setAssumptionVar(l);
                this.coreMapping.put(l, this.nSoft() - 1);
                this.incSoft.set(indexSoft, true);
                this.incSoft.push(false);
                for (int j2 = 0; j2 < vars.size(); ++j2) {
                    clause.push(vars.get(j2));
                }
                clause.push(l);
                this.solver.addClause(clause, null);
                clause.clear();
                clause.push(((MSSoftClause)this.softClauses.get(indexSoft)).assumptionVar());
                this.solver.addClause(clause, null);
                if (!this.symmetryStrategy) continue;
                this.softMapping.push(new LNGIntVector((LNGIntVector)this.softMapping.get(indexSoft)));
                ((LNGIntVector)this.softMapping.get(indexSoft)).clear();
                this.relaxationMapping.push(new LNGIntVector((LNGIntVector)this.relaxationMapping.get(indexSoft)));
                ((LNGIntVector)this.relaxationMapping.get(indexSoft)).clear();
                this.symmetryLog(this.nSoft() - 1);
                continue;
            }
            assert (((MSSoftClause)this.softClauses.get(indexSoft)).weight() - weightCore > 0);
            ((MSSoftClause)this.softClauses.get(indexSoft)).setWeight(((MSSoftClause)this.softClauses.get(indexSoft)).weight() - weightCore);
            clause = new LNGIntVector(((MSSoftClause)this.softClauses.get(indexSoft)).clause());
            vars = new LNGIntVector(((MSSoftClause)this.softClauses.get(indexSoft)).relaxationVars());
            this.addSoftClause(((MSSoftClause)this.softClauses.get(indexSoft)).weight(), clause, vars);
            if (this.symmetryStrategy) {
                this.softMapping.push(new LNGIntVector((LNGIntVector)this.softMapping.get(indexSoft)));
                ((LNGIntVector)this.softMapping.get(indexSoft)).clear();
                this.relaxationMapping.push(new LNGIntVector((LNGIntVector)this.relaxationMapping.get(indexSoft)));
                ((LNGIntVector)this.relaxationMapping.get(indexSoft)).clear();
            }
            this.incSoft.set(indexSoft, true);
            int l = this.newLiteral(false);
            IncWBO.newSATVariable(this.solver);
            ((MSSoftClause)this.softClauses.get(this.nSoft() - 1)).setAssumptionVar(l);
            this.coreMapping.put(l, this.nSoft() - 1);
            this.incSoft.push(false);
            for (j = 0; j < vars.size(); ++j) {
                clause.push(vars.get(j));
            }
            clause.push(l);
            this.solver.addClause(clause, null);
            clause.clear();
            vars.clear();
            clause = new LNGIntVector(((MSSoftClause)this.softClauses.get(indexSoft)).clause());
            vars = new LNGIntVector(((MSSoftClause)this.softClauses.get(indexSoft)).relaxationVars());
            l = this.newLiteral(false);
            IncWBO.newSATVariable(this.solver);
            vars.push(l);
            lits.push(l);
            this.addSoftClause(weightCore, clause, vars);
            l = this.newLiteral(false);
            IncWBO.newSATVariable(this.solver);
            ((MSSoftClause)this.softClauses.get(this.nSoft() - 1)).setAssumptionVar(l);
            this.coreMapping.put(l, this.nSoft() - 1);
            this.incSoft.push(false);
            for (j = 0; j < vars.size(); ++j) {
                clause.push(vars.get(j));
            }
            clause.push(l);
            this.solver.addClause(clause, null);
            clause.clear();
            clause.push(((MSSoftClause)this.softClauses.get(indexSoft)).assumptionVar());
            this.solver.addClause(clause, null);
            if (!this.symmetryStrategy) continue;
            this.softMapping.push(new LNGIntVector());
            this.relaxationMapping.push(new LNGIntVector());
            this.symmetryLog(this.nSoft() - 1);
        }
        this.encoder.encodeAMO(this.solver, lits);
        this.nbVars = this.solver.nVars();
        if (this.symmetryStrategy) {
            this.symmetryBreaking();
        }
        this.sumSizeCores += (long)conflict.size();
    }

    @Override
    protected void symmetryBreaking() {
        if (this.indexSoftCore.size() != 0 && this.nbSymmetryClauses < this.symmetryBreakingLimit) {
            LNGIntVector[] coreIntersection = new LNGIntVector[this.nbCores];
            LNGIntVector[] coreIntersectionCurrent = new LNGIntVector[this.nbCores];
            for (int i = 0; i < this.nbCores; ++i) {
                coreIntersection[i] = new LNGIntVector();
                coreIntersectionCurrent[i] = new LNGIntVector();
            }
            LNGIntVector coreList = new LNGIntVector();
            for (int i = 0; i < this.indexSoftCore.size(); ++i) {
                int core;
                int j;
                int p = this.indexSoftCore.get(i);
                LNGIntVector addCores = new LNGIntVector();
                for (j = 0; j < ((LNGIntVector)this.softMapping.get(p)).size() - 1; ++j) {
                    core = ((LNGIntVector)this.softMapping.get(p)).get(j);
                    addCores.push(core);
                    if (coreIntersection[core].size() == 0) {
                        coreList.push(core);
                    }
                    assert (j < ((LNGIntVector)this.relaxationMapping.get(p)).size());
                    assert (MiniSatStyleSolver.var(((LNGIntVector)this.relaxationMapping.get(p)).get(j)) > this.nbInitialVariables);
                    coreIntersection[core].push(((LNGIntVector)this.relaxationMapping.get(p)).get(j));
                }
                for (j = 0; j < addCores.size(); ++j) {
                    core = addCores.get(j);
                    int b = ((LNGIntVector)this.softMapping.get(p)).size() - 1;
                    assert (b < ((LNGIntVector)this.relaxationMapping.get(p)).size());
                    assert (MiniSatStyleSolver.var(((LNGIntVector)this.relaxationMapping.get(p)).get(b)) > this.nbInitialVariables);
                    coreIntersectionCurrent[core].push(((LNGIntVector)this.relaxationMapping.get(p)).get(b));
                }
                for (int k = 0; k < coreList.size(); ++k) {
                    for (int m = 0; m < coreIntersection[coreList.get(k)].size(); ++m) {
                        for (int j2 = m + 1; j2 < coreIntersectionCurrent[coreList.get(k)].size(); ++j2) {
                            LNGIntVector clause = new LNGIntVector();
                            clause.push(MiniSatStyleSolver.not(coreIntersection[coreList.get(k)].get(m)));
                            clause.push(MiniSatStyleSolver.not(coreIntersectionCurrent[coreList.get(k)].get(j2)));
                            Pair<Integer, Integer> symClause = new Pair<Integer, Integer>(MiniSatStyleSolver.var(coreIntersection[coreList.get(k)].get(m)), MiniSatStyleSolver.var(coreIntersectionCurrent[coreList.get(k)].get(j2)));
                            if (MiniSatStyleSolver.var(coreIntersection[coreList.get(k)].get(m)) > MiniSatStyleSolver.var(coreIntersectionCurrent[coreList.get(k)].get(j2))) {
                                symClause = new Pair<Integer, Integer>(MiniSatStyleSolver.var(coreIntersectionCurrent[coreList.get(k)].get(j2)), MiniSatStyleSolver.var(coreIntersection[coreList.get(k)].get(m)));
                            }
                            if (this.duplicatedSymmetryClauses.contains(symClause)) continue;
                            this.duplicatedSymmetryClauses.add(symClause);
                            this.solver.addClause(clause, null);
                            ++this.nbSymmetryClauses;
                            if (this.symmetryBreakingLimit == this.nbSymmetryClauses) break;
                        }
                        if (this.symmetryBreakingLimit == this.nbSymmetryClauses) break;
                    }
                    if (this.symmetryBreakingLimit == this.nbSymmetryClauses) break;
                }
                if (this.symmetryBreakingLimit == this.nbSymmetryClauses) break;
            }
        }
        this.indexSoftCore.clear();
    }

    @Override
    protected MaxSAT.MaxSATResult weightSearch() {
        assert (this.weightStrategy == MaxSATConfig.WeightStrategy.NORMAL || this.weightStrategy == MaxSATConfig.WeightStrategy.DIVERSIFY);
        Tristate unsatResult = this.unsatSearch();
        if (unsatResult == Tristate.UNDEF) {
            return MaxSAT.MaxSATResult.UNDEF;
        }
        if (unsatResult == Tristate.FALSE) {
            return MaxSAT.MaxSATResult.UNSATISFIABLE;
        }
        this.initAssumptions(this.assumptions);
        this.updateCurrentWeight(this.weightStrategy);
        this.incrementalBuildWeightSolver(this.weightStrategy);
        this.incSoft.growTo(this.nSoft(), false);
        while (true) {
            this.assumptions.clear();
            for (int i = 0; i < this.incSoft.size(); ++i) {
                if (this.incSoft.get(i)) continue;
                this.assumptions.push(MiniSatStyleSolver.not(((MSSoftClause)this.softClauses.get(i)).assumptionVar()));
            }
            Tristate res = IncWBO.searchSATSolver(this.solver, this.satHandler(), this.assumptions);
            this.satSolverFinished();
            if (res == Tristate.UNDEF) {
                return MaxSAT.MaxSATResult.UNDEF;
            }
            if (res == Tristate.FALSE) {
                ++this.nbCores;
                assert (this.solver.conflict().size() > 0);
                int coreCost = this.computeCostCore(this.solver.conflict());
                this.lbCost += coreCost;
                if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                    this.output.println(String.format("c LB : %d CS : %d W : %d", this.lbCost, this.solver.conflict().size(), coreCost));
                }
                if (!this.foundLowerBound(this.lbCost, null)) {
                    return MaxSAT.MaxSATResult.UNDEF;
                }
                this.relaxCore(this.solver.conflict(), coreCost);
                this.incrementalBuildWeightSolver(this.weightStrategy);
                continue;
            }
            ++this.nbSatisfiable;
            if (this.nbCurrentSoft == this.nSoft()) {
                assert (this.incComputeCostModel(this.solver.model()) == this.lbCost);
                if (this.lbCost == this.ubCost && this.verbosity != MaxSATConfig.Verbosity.NONE) {
                    this.output.println("c LB = UB");
                }
                if (this.lbCost < this.ubCost) {
                    this.ubCost = this.lbCost;
                    this.saveModel(this.solver.model());
                    if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                        this.output.println("o " + this.lbCost);
                    }
                }
                return MaxSAT.MaxSATResult.OPTIMUM;
            }
            this.updateCurrentWeight(this.weightStrategy);
            int cost = this.incComputeCostModel(this.solver.model());
            if (cost < this.ubCost) {
                this.ubCost = cost;
                this.saveModel(this.solver.model());
                if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                    this.output.println("o " + this.ubCost);
                }
            }
            if (this.lbCost == this.ubCost) {
                if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                    this.output.println("c LB = UB");
                }
                return MaxSAT.MaxSATResult.OPTIMUM;
            }
            if (!this.foundUpperBound(this.ubCost, null)) {
                return MaxSAT.MaxSATResult.UNDEF;
            }
            this.incrementalBuildWeightSolver(this.weightStrategy);
        }
    }

    protected int incComputeCostModel(LNGBooleanVector currentModel) {
        assert (currentModel.size() != 0);
        int currentCost = 0;
        for (int i = 0; i < this.nSoft(); ++i) {
            boolean unsatisfied = true;
            for (int j = 0; j < ((MSSoftClause)this.softClauses.get(i)).clause().size(); ++j) {
                if (this.incSoft.get(i)) {
                    unsatisfied = false;
                    continue;
                }
                assert (MiniSatStyleSolver.var(((MSSoftClause)this.softClauses.get(i)).clause().get(j)) < currentModel.size());
                if ((!MiniSatStyleSolver.sign(((MSSoftClause)this.softClauses.get(i)).clause().get(j)) || currentModel.get(MiniSatStyleSolver.var(((MSSoftClause)this.softClauses.get(i)).clause().get(j)))) && (MiniSatStyleSolver.sign(((MSSoftClause)this.softClauses.get(i)).clause().get(j)) || !currentModel.get(MiniSatStyleSolver.var(((MSSoftClause)this.softClauses.get(i)).clause().get(j))))) continue;
                unsatisfied = false;
                break;
            }
            if (!unsatisfied) continue;
            currentCost += ((MSSoftClause)this.softClauses.get(i)).weight();
        }
        return currentCost;
    }

    @Override
    protected MaxSAT.MaxSATResult normalSearch() {
        Tristate unsatResult = this.unsatSearch();
        if (unsatResult == Tristate.UNDEF) {
            return MaxSAT.MaxSATResult.UNDEF;
        }
        if (unsatResult == Tristate.FALSE) {
            return MaxSAT.MaxSATResult.UNSATISFIABLE;
        }
        this.initAssumptions(this.assumptions);
        this.solver = this.rebuildSolver();
        this.incSoft.growTo(this.nSoft(), false);
        while (true) {
            this.assumptions.clear();
            for (int i = 0; i < this.incSoft.size(); ++i) {
                if (this.incSoft.get(i)) continue;
                this.assumptions.push(MiniSatStyleSolver.not(((MSSoftClause)this.softClauses.get(i)).assumptionVar()));
            }
            Tristate res = IncWBO.searchSATSolver(this.solver, this.satHandler(), this.assumptions);
            this.satSolverFinished();
            if (res == Tristate.UNDEF) {
                return MaxSAT.MaxSATResult.UNDEF;
            }
            if (res != Tristate.FALSE) break;
            ++this.nbCores;
            assert (this.solver.conflict().size() > 0);
            int coreCost = this.computeCostCore(this.solver.conflict());
            this.lbCost += coreCost;
            if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                this.output.println(String.format("c LB : %d CS : %d W : %d", this.lbCost, this.solver.conflict().size(), coreCost));
            }
            if (this.lbCost == this.ubCost) {
                if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
                    this.output.println("c LB = UB");
                }
                return MaxSAT.MaxSATResult.OPTIMUM;
            }
            if (!this.foundLowerBound(this.lbCost, null)) {
                return MaxSAT.MaxSATResult.UNDEF;
            }
            this.relaxCore(this.solver.conflict(), coreCost);
        }
        ++this.nbSatisfiable;
        this.ubCost = this.incComputeCostModel(this.solver.model());
        assert (this.lbCost == this.ubCost);
        if (this.verbosity != MaxSATConfig.Verbosity.NONE) {
            this.output.println("o " + this.lbCost);
        }
        this.saveModel(this.solver.model());
        return MaxSAT.MaxSATResult.OPTIMUM;
    }
}

