/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.solvers.functions;

import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.logicng.collections.LNGIntVector;
import org.logicng.datastructures.Tristate;
import org.logicng.formulas.Literal;
import org.logicng.solvers.MiniSat;
import org.logicng.solvers.functions.SolverFunction;
import org.logicng.solvers.sat.MiniSatStyleSolver;

public final class UpZeroLiteralsFunction
implements SolverFunction<SortedSet<Literal>> {
    private static final UpZeroLiteralsFunction INSTANCE = new UpZeroLiteralsFunction();

    private UpZeroLiteralsFunction() {
    }

    public static UpZeroLiteralsFunction get() {
        return INSTANCE;
    }

    @Override
    public SortedSet<Literal> apply(MiniSat solver, Consumer<Tristate> resultSetter) {
        if (solver.getResult() == Tristate.UNDEF) {
            throw new IllegalStateException("Cannot get unit propagated literals on level 0 as long as the formula is not solved.  Call 'sat' first.");
        }
        if (solver.getResult() == Tristate.FALSE) {
            return null;
        }
        LNGIntVector literals = solver.underlyingSolver().upZeroLiterals();
        TreeSet<Literal> upZeroLiterals = new TreeSet<Literal>();
        for (int i = 0; i < literals.size(); ++i) {
            int lit = literals.get(i);
            upZeroLiterals.add(solver.factory().literal(solver.underlyingSolver().nameForIdx(MiniSatStyleSolver.var(lit)), !MiniSatStyleSolver.sign(lit)));
        }
        return upZeroLiterals;
    }
}

