/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.solvers.functions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.function.Consumer;
import org.logicng.collections.LNGIntVector;
import org.logicng.collections.LNGVector;
import org.logicng.datastructures.Tristate;
import org.logicng.explanations.UNSATCore;
import org.logicng.explanations.drup.DRUPTrim;
import org.logicng.formulas.Formula;
import org.logicng.formulas.Literal;
import org.logicng.propositions.Proposition;
import org.logicng.propositions.StandardProposition;
import org.logicng.solvers.MiniSat;
import org.logicng.solvers.functions.SolverFunction;
import org.logicng.solvers.sat.GlucoseSyrup;
import org.logicng.solvers.sat.MiniCard;
import org.logicng.solvers.sat.MiniSatStyleSolver;

public final class UnsatCoreFunction
implements SolverFunction<UNSATCore<Proposition>> {
    private static final UnsatCoreFunction INSTANCE = new UnsatCoreFunction();

    private UnsatCoreFunction() {
    }

    public static UnsatCoreFunction get() {
        return INSTANCE;
    }

    @Override
    public UNSATCore<Proposition> apply(MiniSat solver, Consumer<Tristate> resultSetter) {
        if (!solver.getConfig().proofGeneration()) {
            throw new IllegalStateException("Cannot generate an unsat core if proof generation is not turned on");
        }
        if (solver.getResult() == Tristate.TRUE) {
            throw new IllegalStateException("An unsat core can only be generated if the formula is solved and is UNSAT");
        }
        if (solver.getResult() == Tristate.UNDEF) {
            throw new IllegalStateException("Cannot generate an unsat core before the formula was solved.");
        }
        if (solver.underlyingSolver() instanceof MiniCard) {
            throw new IllegalStateException("Cannot compute an unsat core with MiniCard.");
        }
        if (solver.underlyingSolver() instanceof GlucoseSyrup && solver.getConfig().incremental()) {
            throw new IllegalStateException("Cannot compute an unsat core with Glucose in incremental mode.");
        }
        if (solver.isLastComputationWithAssumptions()) {
            throw new IllegalStateException("Cannot compute an unsat core for a computation with assumptions.");
        }
        DRUPTrim trimmer = new DRUPTrim();
        HashMap<Formula, Proposition> clause2proposition = new HashMap<Formula, Proposition>();
        LNGVector<LNGIntVector> clauses = new LNGVector<LNGIntVector>(solver.underlyingSolver().pgOriginalClauses().size());
        for (MiniSatStyleSolver.ProofInformation pi : solver.underlyingSolver().pgOriginalClauses()) {
            clauses.push(pi.clause());
            Formula clause = this.getFormulaForVector(solver, pi.clause());
            Proposition proposition = pi.proposition();
            if (proposition == null) {
                proposition = new StandardProposition(clause);
            }
            clause2proposition.put(clause, proposition);
        }
        if (this.containsEmptyClause(clauses)) {
            Proposition emptyClause = (Proposition)clause2proposition.get(solver.factory().falsum());
            return new UNSATCore<Proposition>(Collections.singletonList(emptyClause), true);
        }
        DRUPTrim.DRUPResult result = trimmer.compute(clauses, solver.underlyingSolver().pgProof());
        if (result.trivialUnsat()) {
            return this.handleTrivialCase(solver);
        }
        LinkedHashSet propositions = new LinkedHashSet();
        for (LNGIntVector vector : result.unsatCore()) {
            propositions.add(clause2proposition.get(this.getFormulaForVector(solver, vector)));
        }
        return new UNSATCore<Proposition>(new ArrayList(propositions), false);
    }

    private UNSATCore<Proposition> handleTrivialCase(MiniSat solver) {
        LNGVector<MiniSatStyleSolver.ProofInformation> clauses = solver.underlyingSolver().pgOriginalClauses();
        for (int i = 0; i < clauses.size(); ++i) {
            for (int j = i + 1; j < clauses.size(); ++j) {
                if (clauses.get(i).clause().size() != 1 || clauses.get(j).clause().size() != 1 || clauses.get(i).clause().get(0) + clauses.get(j).clause().get(0) != 0) continue;
                LinkedHashSet<Proposition> propositions = new LinkedHashSet<Proposition>();
                Proposition pi = clauses.get(i).proposition();
                Proposition pj = clauses.get(j).proposition();
                propositions.add(pi != null ? pi : new StandardProposition(this.getFormulaForVector(solver, clauses.get(i).clause())));
                propositions.add(pj != null ? pj : new StandardProposition(this.getFormulaForVector(solver, clauses.get(j).clause())));
                return new UNSATCore<Proposition>(new ArrayList(propositions), false);
            }
        }
        throw new IllegalStateException("Should be a trivial unsat core, but did not found one.");
    }

    private boolean containsEmptyClause(LNGVector<LNGIntVector> clauses) {
        for (LNGIntVector clause : clauses) {
            if (!clause.empty()) continue;
            return true;
        }
        return false;
    }

    private Formula getFormulaForVector(MiniSat solver, LNGIntVector vector) {
        ArrayList<Literal> literals = new ArrayList<Literal>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            int lit = vector.get(i);
            String varName = solver.underlyingSolver().nameForIdx(Math.abs(lit) - 1);
            literals.add(solver.factory().literal(varName, lit > 0));
        }
        return solver.factory().or(literals);
    }
}

