/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.solvers.functions;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.logicng.cardinalityconstraints.CCIncrementalData;
import org.logicng.collections.LNGBooleanVector;
import org.logicng.collections.LNGIntVector;
import org.logicng.datastructures.Assignment;
import org.logicng.datastructures.Tristate;
import org.logicng.formulas.CType;
import org.logicng.formulas.CardinalityConstraint;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;
import org.logicng.solvers.MiniSat;
import org.logicng.solvers.SolverState;
import org.logicng.solvers.functions.SolverFunction;

public final class OptimizationFunction
implements SolverFunction<Assignment> {
    private static final String SEL_PREFIX = "@SEL_OPT_";
    private final Collection<? extends Literal> literals;
    private final SortedSet<Variable> resultModelVariables;
    private final boolean maximize;

    private OptimizationFunction(Collection<? extends Literal> literals, Collection<Variable> additionalVariables, boolean maximize) {
        this.literals = literals;
        this.resultModelVariables = new TreeSet<Variable>(additionalVariables);
        for (Literal literal : literals) {
            this.resultModelVariables.add(literal.variable());
        }
        this.maximize = maximize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static OptimizationFunction maximize(Collection<? extends Literal> literals) {
        return new Builder().literals(literals).maximize().build();
    }

    public static OptimizationFunction minimize(Collection<? extends Literal> literals) {
        return new Builder().literals(literals).minimize().build();
    }

    @Override
    public Assignment apply(MiniSat solver, Consumer<Tristate> resultSetter) {
        SolverState initialState = null;
        if (solver.getStyle() == MiniSat.SolverStyle.MINISAT && solver.isIncremental()) {
            initialState = solver.saveState();
        }
        Assignment model = this.maximize(solver);
        if (solver.getStyle() == MiniSat.SolverStyle.MINISAT && solver.isIncremental()) {
            solver.loadState(initialState);
        }
        return model;
    }

    private Assignment maximize(MiniSat solver) {
        FormulaFactory f = solver.factory();
        TreeMap<Variable, Literal> selectorMap = new TreeMap<Variable, Literal>();
        for (Literal literal : this.literals) {
            Variable selVar2 = f.variable(SEL_PREFIX + selectorMap.size());
            selectorMap.put(selVar2, literal);
        }
        Set<Variable> selectors = selectorMap.keySet();
        if (this.maximize) {
            selectorMap.forEach((selVar, lit) -> solver.add(f.or(selVar.negate(), (Formula)lit)));
            selectorMap.forEach((selVar, lit) -> solver.add(f.or(lit.negate(), (Formula)selVar)));
        } else {
            selectorMap.forEach((selVar, lit) -> solver.add(f.or(selVar.negate(), lit.negate())));
            selectorMap.forEach((selVar, lit) -> solver.add(f.or((Formula)lit, (Formula)selVar)));
        }
        if (solver.sat() != Tristate.TRUE) {
            return null;
        }
        LNGBooleanVector internalModel = solver.underlyingSolver().model();
        Assignment assignment = solver.model(selectors);
        int currentBound = assignment.positiveVariables().size();
        if (currentBound == 0) {
            solver.add(f.cc(CType.GE, 1, selectors));
            if (solver.sat() == Tristate.FALSE) {
                return this.mkResultModel(solver, internalModel);
            }
            internalModel = solver.underlyingSolver().model();
            Assignment assignment2 = solver.model(selectors);
            currentBound = assignment2.positiveVariables().size();
        } else if (currentBound == selectors.size()) {
            return this.mkResultModel(solver, internalModel);
        }
        Formula cc = f.cc(CType.GE, currentBound + 1, selectors);
        assert (cc instanceof CardinalityConstraint);
        CCIncrementalData incrementalData = solver.addIncrementalCC((CardinalityConstraint)cc);
        while (solver.sat() == Tristate.TRUE) {
            internalModel = solver.underlyingSolver().model();
            Assignment assignment3 = solver.model(selectors);
            currentBound = assignment3.positiveVariables().size();
            if (currentBound == selectors.size()) {
                return this.mkResultModel(solver, internalModel);
            }
            incrementalData.newLowerBoundForSolver(currentBound + 1);
        }
        return this.mkResultModel(solver, internalModel);
    }

    private Assignment mkResultModel(MiniSat solver, LNGBooleanVector internalModel) {
        LNGIntVector relevantIndices = new LNGIntVector(this.resultModelVariables.size());
        for (Variable var : this.resultModelVariables) {
            relevantIndices.push(solver.underlyingSolver().idxForName(var.name()));
        }
        return solver.createAssignment(internalModel, relevantIndices);
    }

    public static class Builder {
        private Collection<? extends Literal> literals;
        private Collection<Variable> additionalVariables = new TreeSet<Variable>();
        private boolean maximize = true;

        private Builder() {
        }

        public Builder literals(Collection<? extends Literal> literals) {
            this.literals = literals;
            return this;
        }

        public Builder literals(Literal ... literals) {
            this.literals = Arrays.asList(literals);
            return this;
        }

        public Builder additionalVariables(Collection<Variable> variables) {
            this.additionalVariables = variables;
            return this;
        }

        public Builder additionalVariables(Variable ... variables) {
            this.additionalVariables = Arrays.asList(variables);
            return this;
        }

        public Builder minimize() {
            this.maximize = false;
            return this;
        }

        public Builder maximize() {
            this.maximize = true;
            return this;
        }

        public OptimizationFunction build() {
            return new OptimizationFunction(this.literals, this.additionalVariables, this.maximize);
        }
    }
}

