/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.solvers.functions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.logicng.collections.LNGBooleanVector;
import org.logicng.collections.LNGIntVector;
import org.logicng.datastructures.Assignment;
import org.logicng.datastructures.Tristate;
import org.logicng.formulas.Variable;
import org.logicng.handlers.ModelEnumerationHandler;
import org.logicng.handlers.SATHandler;
import org.logicng.solvers.MiniSat;
import org.logicng.solvers.SolverState;
import org.logicng.solvers.functions.SolverFunction;

public final class ModelEnumerationFunction
implements SolverFunction<List<Assignment>> {
    private final ModelEnumerationHandler handler;
    private final Collection<Variable> variables;
    private final Collection<Variable> additionalVariables;

    private ModelEnumerationFunction(ModelEnumerationHandler handler, Collection<Variable> variables, Collection<Variable> additionalVariables) {
        this.handler = handler;
        this.variables = variables;
        this.additionalVariables = additionalVariables;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public List<Assignment> apply(MiniSat solver, Consumer<Tristate> resultSetter) {
        LNGIntVector relevantIndices;
        if (this.handler != null) {
            this.handler.started();
        }
        ArrayList<Assignment> models = new ArrayList<Assignment>();
        SolverState stateBeforeEnumeration = null;
        if (solver.getStyle() == MiniSat.SolverStyle.MINISAT && solver.isIncremental()) {
            stateBeforeEnumeration = solver.saveState();
        }
        boolean proceed = true;
        if (this.variables == null) {
            if (!solver.getConfig().isAuxiliaryVariablesInModels()) {
                relevantIndices = new LNGIntVector();
                for (Map.Entry entry : solver.underlyingSolver().getName2idx().entrySet()) {
                    if (!solver.isRelevantVariable((String)entry.getKey())) continue;
                    relevantIndices.push((Integer)entry.getValue());
                }
            } else {
                relevantIndices = null;
            }
        } else {
            relevantIndices = new LNGIntVector(this.variables.size());
            for (Variable variable : this.variables) {
                relevantIndices.push(solver.underlyingSolver().idxForName(variable.name()));
            }
        }
        LNGIntVector relevantAllIndices = null;
        TreeSet treeSet = new TreeSet(this.additionalVariables == null ? Collections.emptyList() : this.additionalVariables);
        if (this.variables != null) {
            treeSet.removeAll(this.variables);
        }
        if (relevantIndices != null) {
            if (treeSet.isEmpty()) {
                relevantAllIndices = relevantIndices;
            } else {
                relevantAllIndices = new LNGIntVector(relevantIndices.size() + treeSet.size());
                for (int i = 0; i < relevantIndices.size(); ++i) {
                    relevantAllIndices.push(relevantIndices.get(i));
                }
                for (Variable var : treeSet) {
                    relevantAllIndices.push(solver.underlyingSolver().idxForName(var.name()));
                }
            }
        }
        while (proceed && this.modelEnumerationSATCall(solver, this.handler)) {
            LNGBooleanVector modelFromSolver = solver.underlyingSolver().model();
            Assignment model = solver.createAssignment(modelFromSolver, relevantAllIndices);
            models.add(model);
            boolean bl = proceed = this.handler == null || this.handler.foundModel(model);
            if (model.size() <= 0) break;
            LNGIntVector blockingClause = this.generateBlockingClause(modelFromSolver, relevantIndices);
            solver.underlyingSolver().addClause(blockingClause, null);
            resultSetter.accept(Tristate.UNDEF);
        }
        if (solver.getStyle() == MiniSat.SolverStyle.MINISAT && solver.isIncremental()) {
            solver.loadState(stateBeforeEnumeration);
        }
        return models;
    }

    private boolean modelEnumerationSATCall(MiniSat solver, ModelEnumerationHandler handler) {
        if (handler == null) {
            return solver.sat((SATHandler)null) == Tristate.TRUE;
        }
        Tristate tristate = solver.sat(handler.satHandler());
        return handler.satSolverFinished() && tristate == Tristate.TRUE;
    }

    private LNGIntVector generateBlockingClause(LNGBooleanVector modelFromSolver, LNGIntVector relevantVars) {
        LNGIntVector blockingClause;
        if (relevantVars != null) {
            blockingClause = new LNGIntVector(relevantVars.size());
            for (int i = 0; i < relevantVars.size(); ++i) {
                int varIndex = relevantVars.get(i);
                if (varIndex == -1) continue;
                boolean varAssignment = modelFromSolver.get(varIndex);
                blockingClause.push(varAssignment ? varIndex * 2 ^ 1 : varIndex * 2);
            }
        } else {
            blockingClause = new LNGIntVector(modelFromSolver.size());
            for (int i = 0; i < modelFromSolver.size(); ++i) {
                boolean varAssignment = modelFromSolver.get(i);
                blockingClause.push(varAssignment ? i * 2 ^ 1 : i * 2);
            }
        }
        return blockingClause;
    }

    public static class Builder {
        private ModelEnumerationHandler handler;
        private Collection<Variable> variables;
        private Collection<Variable> additionalVariables;

        private Builder() {
        }

        public Builder handler(ModelEnumerationHandler handler) {
            this.handler = handler;
            return this;
        }

        public Builder variables(Collection<Variable> variables) {
            this.variables = variables;
            return this;
        }

        public Builder variables(Variable ... variables) {
            this.variables = Arrays.asList(variables);
            return this;
        }

        public Builder additionalVariables(Collection<Variable> variables) {
            this.additionalVariables = variables;
            return this;
        }

        public Builder additionalVariables(Variable ... variables) {
            this.additionalVariables = Arrays.asList(variables);
            return this;
        }

        public ModelEnumerationFunction build() {
            return new ModelEnumerationFunction(this.handler, this.variables, this.additionalVariables);
        }
    }
}

