/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.solvers.functions;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.logicng.collections.LNGVector;
import org.logicng.datastructures.Tristate;
import org.logicng.formulas.CType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;
import org.logicng.solvers.MiniSat;
import org.logicng.solvers.datastructures.MSClause;
import org.logicng.solvers.datastructures.MSVariable;
import org.logicng.solvers.functions.SolverFunction;

public final class FormulaOnSolverFunction
implements SolverFunction<Set<Formula>> {
    private static final FormulaOnSolverFunction INSTANCE = new FormulaOnSolverFunction();

    private FormulaOnSolverFunction() {
    }

    public static FormulaOnSolverFunction get() {
        return INSTANCE;
    }

    @Override
    public Set<Formula> apply(MiniSat solver, Consumer<Tristate> resultSetter) {
        FormulaFactory f = solver.factory();
        LinkedHashSet<Formula> formulas = new LinkedHashSet<Formula>();
        for (MSClause clause : solver.underlyingSolver().clauses()) {
            ArrayList<Literal> lits = new ArrayList<Literal>();
            for (int i = 0; i < clause.size(); ++i) {
                int litInt = clause.get(i);
                lits.add(f.literal(solver.underlyingSolver().nameForIdx(litInt >> 1), (litInt & 1) != 1));
            }
            if (!clause.isAtMost()) {
                formulas.add(f.clause(lits));
                continue;
            }
            int rhs = clause.size() + 1 - clause.atMostWatchers();
            ArrayList<Variable> vars = new ArrayList<Variable>();
            for (Literal lit : lits) {
                vars.add(lit.variable());
            }
            formulas.add(f.cc(CType.LE, rhs, vars));
        }
        LNGVector<MSVariable> variables = solver.underlyingSolver().variables();
        for (int i = 0; i < variables.size(); ++i) {
            MSVariable var = variables.get(i);
            if (var.level() != 0) continue;
            formulas.add(f.literal(solver.underlyingSolver().nameForIdx(i), var.assignment() == Tristate.TRUE));
        }
        if (!solver.underlyingSolver().ok()) {
            formulas.add(f.falsum());
        }
        return formulas;
    }
}

